/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File Array.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.ArrayIDL;

/**

 * As previously stated, arrays are added to a configuration because they are an important aspect of how an antenna behaves.  These are high-level arrays; the ones that the Scheduling subsystem creates (not the sub-arrays created within an observing script).

 * Arrays are dynamic and are specific to a system execution.

 * Arrays are either automatic or manual.  If the array is manual, the user-id of the ALMA staff person responsible for the array is included.

 * The AntennaToArray table gives the list of antennas in the array.

 * If the array is an automatic array, the scheduling blocks executed by the array are contained in the SBExecution table.  This table ties the TMCDB to the APDM and ASDM databases.

   * Key: ArrayId is automatically generated from:  StartTime, BaseElementId

 *
 */
public class Array implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ArrayId;

    private int BaseElementId;

    private String Type;

    private String UserId;

    // private boolean nullUserId;

    private ArrayTime StartTime;

    private ArrayTime EndTime;

    // private boolean nullEndTime;

    private boolean NormalTermination;

    private int ComponentId;

    /**
     * Default Constructor for Array.  Setter methods must be used to insert data.
     */
    public Array () {

        // nullUserId = true;

        // nullEndTime = true;

    }

    /**
     * Create a Array by specifiying all data values.
     */
    public Array (

        int ArrayId,

        int BaseElementId,

        String Type,

        String UserId,

        ArrayTime StartTime,

        ArrayTime EndTime,

        boolean NormalTermination,

        int ComponentId

    ) {

		setArrayId(ArrayId);

		setBaseElementId(BaseElementId);

		setType(Type);

		setUserId(UserId);

		setStartTime(StartTime);

		setEndTime(EndTime);

		setNormalTermination(NormalTermination);

		setComponentId(ComponentId);

    }

    /**
     * Create a Array by specifiying data values as an array of strings.
     */
    public Array (String[] data) {
    	if (data.length != 8)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 8)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ArrayId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.BaseElementId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Type = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullUserId = true;
			// this.UserId = null;

		} else {

			// nullUserId = false;

			this.UserId = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndTime = true;
			// this.EndTime = null;

		} else {

			// nullEndTime = false;

			this.EndTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.NormalTermination = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComponentId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "Array:" + newline;

        s += "\tArrayId: " + ArrayId + newline;

        s += "\tBaseElementId: " + BaseElementId + newline;

        s += "\tType: " + Type + newline;

    	// if (UserId == null)
    	//	s += "\tUserId: null" + newline;
    	// else

        s += "\tUserId: " + UserId + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

    	// if (EndTime == null)
    	//	s += "\tEndTime: null" + newline;
    	// else

        s += "\tEndTime: " + EndTime.toFITS() + newline;

        s += "\tNormalTermination: " + NormalTermination + newline;

        s += "\tComponentId: " + ComponentId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "Array" + delimiter;  

        s += ArrayId + delimiter;

        s += BaseElementId + delimiter;

        s += Type + delimiter;

        // if (nullUserId)
        // 	s += delimiter;
        // else

        	// s += UserId + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

        // if (nullEndTime)
        // 	s += delimiter;
        // else

		// s += new String(EndTime.toFITS()) + delimiter;

        s += NormalTermination + delimiter;

        s += ComponentId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 8;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#Array" + delimiter  

        	+ "ArrayId" + delimiter

        	+ "BaseElementId" + delimiter

        	+ "Type" + delimiter

        	+ "UserId" + delimiter

        	+ "StartTime" + delimiter

        	+ "EndTime" + delimiter

        	+ "NormalTermination" + delimiter

        	+ "ComponentId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof Array)) return false;
    	Array arg = (Array) obj;

		if (this.ArrayId != arg.ArrayId)
			return false;

		if (this.BaseElementId != arg.BaseElementId)
			return false;

		if (this.Type == null) {	// Two null strings are equal
			if (arg.Type == null)
				return true;
			else
				return false;
		}
		if (!this.Type.equals(arg.Type))
			return false; 

		if (this.UserId == null) {	// Two null strings are equal
			if (arg.UserId == null)
				return true;
			else
				return false;
		}
		if (!this.UserId.equals(arg.UserId))
			return false; 

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.EndTime.get() != arg.EndTime.get())
			return false;

		if (this.NormalTermination != arg.NormalTermination)
			return false;

		if (this.ComponentId != arg.ComponentId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ArrayIDL toIDL() {
    	ArrayIDL x = new ArrayIDL ();

		x.ArrayId = this.ArrayId;

		x.BaseElementId = this.BaseElementId;

		x.Type = this.Type;

		x.UserId = this.UserId;

        // x.nullUserId = this.nullUserId;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.EndTime = this.EndTime.toIDLArrayTime();

        // x.nullEndTime = this.nullEndTime;

		x.NormalTermination = this.NormalTermination;

		x.ComponentId = this.ComponentId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ArrayIDL x) {

		this.ArrayId = x.ArrayId;

		this.BaseElementId = x.BaseElementId;

		this.Type = x.Type;

		this.UserId = x.UserId;

        // this.nullUserId = x.nullUserId;

		this.StartTime = new ArrayTime(x.StartTime);

		this.EndTime = new ArrayTime(x.EndTime);

        // this.nullEndTime = x.nullEndTime;

		this.NormalTermination = x.NormalTermination;

		this.ComponentId = x.ComponentId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ArrayId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for Array.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ArrayId.
     */
    public int getArrayId () {
        return ArrayId;
    }

    /**
     * Set ArrayId to the specified value.
     */
    public void setArrayId(int ArrayId) {

        this.ArrayId = ArrayId;

    }

    /**
     * Get the value for BaseElementId.
     */
    public int getBaseElementId () {
        return BaseElementId;
    }

    /**
     * Set BaseElementId to the specified value.
     */
    public void setBaseElementId(int BaseElementId) {

        this.BaseElementId = BaseElementId;

    }

    /**
     * Get the value for Type.
     */
    public String getType () {
        return Type;
    }

    /**
     * Set Type to the specified value.
     */
    public void setType(String Type) {

        this.Type = Type;

    }

    /**
     * Get the value for UserId.
     */
    public String getUserId () {
        return UserId;
    }

    /**
     * Set UserId to the specified value.
     */
    public void setUserId(String UserId) {

        // nullUserId = false;

        this.UserId = UserId;

    }

    /*
     * Is the UserId null?
     */
    // public boolean isUserIdNull() {
    //	return nullUserId;
    // }

    /*
     * Set the null indicator for UserId
     */       
    // public void setUserIdNull() {
    // 	nullUserId = true;
    // }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for EndTime.
     */
    public ArrayTime getEndTime () {
        return EndTime;
    }

    /**
     * Set EndTime to the specified value.
     */
    public void setEndTime(ArrayTime EndTime) {

        // nullEndTime = false;

        this.EndTime = EndTime;

    }

    /*
     * Is the EndTime null?
     */
    // public boolean isEndTimeNull() {
    //	return nullEndTime;
    // }

    /*
     * Set the null indicator for EndTime
     */       
    // public void setEndTimeNull() {
    // 	nullEndTime = true;
    // }

    /**
     * Get the value for NormalTermination.
     */
    public boolean getNormalTermination () {
        return NormalTermination;
    }

    /**
     * Set NormalTermination to the specified value.
     */
    public void setNormalTermination(boolean NormalTermination) {

        this.NormalTermination = NormalTermination;

    }

    /**
     * Get the value for ComponentId.
     */
    public int getComponentId () {
        return ComponentId;
    }

    /**
     * Set ComponentId to the specified value.
     */
    public void setComponentId(int ComponentId) {

        this.ComponentId = ComponentId;

    }

}
