/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AntennaToArray.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AntennaToArrayIDL;

/**

 * The AntennaToArray table give the antennas that belong to an array.

   * Key: AntennaId, ArrayId

 *
 */
public class AntennaToArray implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int AntennaId;

    private int ArrayId;

    /**
     * Default Constructor for AntennaToArray.  Setter methods must be used to insert data.
     */
    public AntennaToArray () {

    }

    /**
     * Create a AntennaToArray by specifiying all data values.
     */
    public AntennaToArray (

        int AntennaId,

        int ArrayId

    ) {

		setAntennaId(AntennaId);

		setArrayId(ArrayId);

    }

    /**
     * Create a AntennaToArray by specifiying data values as an array of strings.
     */
    public AntennaToArray (String[] data) {
    	if (data.length != 2)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 2)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AntennaId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ArrayId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AntennaToArray:" + newline;

        s += "\tAntennaId: " + AntennaId + newline;

        s += "\tArrayId: " + ArrayId + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AntennaToArray" + delimiter;  

        s += AntennaId + delimiter;

        s += ArrayId + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 2;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AntennaToArray" + delimiter  

        	+ "AntennaId" + delimiter

        	+ "ArrayId" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AntennaToArray)) return false;
    	AntennaToArray arg = (AntennaToArray) obj;

		if (this.AntennaId != arg.AntennaId)
			return false;

		if (this.ArrayId != arg.ArrayId)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AntennaToArrayIDL toIDL() {
    	AntennaToArrayIDL x = new AntennaToArrayIDL ();

		x.AntennaId = this.AntennaId;

		x.ArrayId = this.ArrayId;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AntennaToArrayIDL x) {

		this.AntennaId = x.AntennaId;

		this.ArrayId = x.ArrayId;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AntennaToArray.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for AntennaId.
     */
    public int getAntennaId () {
        return AntennaId;
    }

    /**
     * Set AntennaId to the specified value.
     */
    public void setAntennaId(int AntennaId) {

        this.AntennaId = AntennaId;

    }

    /**
     * Get the value for ArrayId.
     */
    public int getArrayId () {
        return ArrayId;
    }

    /**
     * Set ArrayId to the specified value.
     */
    public void setArrayId(int ArrayId) {

        this.ArrayId = ArrayId;

    }

}
