/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AntennaFocusModelTerm.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AntennaFocusModelTermIDL;

/**

 * The AntennaFocusModelTerm table gives the terms of a given Focus model.

   * Key: FocusModelId, CoeffName

 *
 */
public class AntennaFocusModelTerm implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int FocusModelId;

    private String CoeffName;

    private float CoeffValue;

    private float CoeffError;

    /**
     * Default Constructor for AntennaFocusModelTerm.  Setter methods must be used to insert data.
     */
    public AntennaFocusModelTerm () {

    }

    /**
     * Create a AntennaFocusModelTerm by specifiying all data values.
     */
    public AntennaFocusModelTerm (

        int FocusModelId,

        String CoeffName,

        float CoeffValue,

        float CoeffError

    ) {

		setFocusModelId(FocusModelId);

		setCoeffName(CoeffName);

		setCoeffValue(CoeffValue);

		setCoeffError(CoeffError);

    }

    /**
     * Create a AntennaFocusModelTerm by specifiying data values as an array of strings.
     */
    public AntennaFocusModelTerm (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FocusModelId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CoeffName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CoeffValue = new Float(Float.parseFloat(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CoeffError = new Float(Float.parseFloat(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AntennaFocusModelTerm:" + newline;

        s += "\tFocusModelId: " + FocusModelId + newline;

        s += "\tCoeffName: " + CoeffName + newline;

        s += "\tCoeffValue: " + CoeffValue + newline;

        s += "\tCoeffError: " + CoeffError + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AntennaFocusModelTerm" + delimiter;  

        s += FocusModelId + delimiter;

        s += CoeffName + delimiter;

        s += CoeffValue + delimiter;

        s += CoeffError + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AntennaFocusModelTerm" + delimiter  

        	+ "FocusModelId" + delimiter

        	+ "CoeffName" + delimiter

        	+ "CoeffValue" + delimiter

        	+ "CoeffError" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AntennaFocusModelTerm)) return false;
    	AntennaFocusModelTerm arg = (AntennaFocusModelTerm) obj;

		if (this.FocusModelId != arg.FocusModelId)
			return false;

		if (this.CoeffName == null) {	// Two null strings are equal
			if (arg.CoeffName == null)
				return true;
			else
				return false;
		}
		if (!this.CoeffName.equals(arg.CoeffName))
			return false; 

		if (this.CoeffValue != arg.CoeffValue)
			return false;

		if (this.CoeffError != arg.CoeffError)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AntennaFocusModelTermIDL toIDL() {
    	AntennaFocusModelTermIDL x = new AntennaFocusModelTermIDL ();

		x.FocusModelId = this.FocusModelId;

		x.CoeffName = this.CoeffName;

		x.CoeffValue = this.CoeffValue;

		x.CoeffError = this.CoeffError;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AntennaFocusModelTermIDL x) {

		this.FocusModelId = x.FocusModelId;

		this.CoeffName = x.CoeffName;

		this.CoeffValue = x.CoeffValue;

		this.CoeffError = x.CoeffError;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AntennaFocusModelTerm.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for FocusModelId.
     */
    public int getFocusModelId () {
        return FocusModelId;
    }

    /**
     * Set FocusModelId to the specified value.
     */
    public void setFocusModelId(int FocusModelId) {

        this.FocusModelId = FocusModelId;

    }

    /**
     * Get the value for CoeffName.
     */
    public String getCoeffName () {
        return CoeffName;
    }

    /**
     * Set CoeffName to the specified value.
     */
    public void setCoeffName(String CoeffName) {

        this.CoeffName = CoeffName;

    }

    /**
     * Get the value for CoeffValue.
     */
    public float getCoeffValue () {
        return CoeffValue;
    }

    /**
     * Set CoeffValue to the specified value.
     */
    public void setCoeffValue(float CoeffValue) {

        this.CoeffValue = CoeffValue;

    }

    /**
     * Get the value for CoeffError.
     */
    public float getCoeffError () {
        return CoeffError;
    }

    /**
     * Set CoeffError to the specified value.
     */
    public void setCoeffError(float CoeffError) {

        this.CoeffError = CoeffError;

    }

}
