/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AntennaFocusModel.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.AntennaFocusModelIDL;

/**

 * The AntennaFocusModel table gives the measured parameters of the focus model for the designated antenna.

 * The terms of the Focus model are given in the AntennaFocusModelTerm table.

   * Key: FocusModelId is automatically generated from:  AntennaId, ReceiverBand, StartValidTime

 *
 */
public class AntennaFocusModel implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int FocusModelId;

    private int AntennaId;

    private String ReceiverBand;

    private ArrayTime StartValidTime;

    private ArrayTime EndValidTime;

    // private boolean nullEndValidTime;

    private String AsdmUID;

    /**
     * Default Constructor for AntennaFocusModel.  Setter methods must be used to insert data.
     */
    public AntennaFocusModel () {

        // nullEndValidTime = true;

    }

    /**
     * Create a AntennaFocusModel by specifiying all data values.
     */
    public AntennaFocusModel (

        int FocusModelId,

        int AntennaId,

        String ReceiverBand,

        ArrayTime StartValidTime,

        ArrayTime EndValidTime,

        String AsdmUID

    ) {

		setFocusModelId(FocusModelId);

		setAntennaId(AntennaId);

		setReceiverBand(ReceiverBand);

		setStartValidTime(StartValidTime);

		setEndValidTime(EndValidTime);

		setAsdmUID(AsdmUID);

    }

    /**
     * Create a AntennaFocusModel by specifiying data values as an array of strings.
     */
    public AntennaFocusModel (String[] data) {
    	if (data.length != 6)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 6)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.FocusModelId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AntennaId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ReceiverBand = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartValidTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndValidTime = true;
			// this.EndValidTime = null;

		} else {

			// nullEndValidTime = false;

			this.EndValidTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AsdmUID = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AntennaFocusModel:" + newline;

        s += "\tFocusModelId: " + FocusModelId + newline;

        s += "\tAntennaId: " + AntennaId + newline;

        s += "\tReceiverBand: " + ReceiverBand + newline;

        s += "\tStartValidTime: " + StartValidTime.toFITS() + newline;

    	// if (EndValidTime == null)
    	//	s += "\tEndValidTime: null" + newline;
    	// else

        s += "\tEndValidTime: " + EndValidTime.toFITS() + newline;

        s += "\tAsdmUID: " + AsdmUID + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AntennaFocusModel" + delimiter;  

        s += FocusModelId + delimiter;

        s += AntennaId + delimiter;

        s += ReceiverBand + delimiter;

		s += new String(StartValidTime.toFITS()) + delimiter;

        // if (nullEndValidTime)
        // 	s += delimiter;
        // else

		// s += new String(EndValidTime.toFITS()) + delimiter;

        s += AsdmUID + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 6;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AntennaFocusModel" + delimiter  

        	+ "FocusModelId" + delimiter

        	+ "AntennaId" + delimiter

        	+ "ReceiverBand" + delimiter

        	+ "StartValidTime" + delimiter

        	+ "EndValidTime" + delimiter

        	+ "AsdmUID" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AntennaFocusModel)) return false;
    	AntennaFocusModel arg = (AntennaFocusModel) obj;

		if (this.FocusModelId != arg.FocusModelId)
			return false;

		if (this.AntennaId != arg.AntennaId)
			return false;

		if (this.ReceiverBand == null) {	// Two null strings are equal
			if (arg.ReceiverBand == null)
				return true;
			else
				return false;
		}
		if (!this.ReceiverBand.equals(arg.ReceiverBand))
			return false; 

		if (this.StartValidTime.get() != arg.StartValidTime.get())
			return false;

		if (this.EndValidTime.get() != arg.EndValidTime.get())
			return false;

		if (this.AsdmUID == null) {	// Two null strings are equal
			if (arg.AsdmUID == null)
				return true;
			else
				return false;
		}
		if (!this.AsdmUID.equals(arg.AsdmUID))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AntennaFocusModelIDL toIDL() {
    	AntennaFocusModelIDL x = new AntennaFocusModelIDL ();

		x.FocusModelId = this.FocusModelId;

		x.AntennaId = this.AntennaId;

		x.ReceiverBand = this.ReceiverBand;

		x.StartValidTime = this.StartValidTime.toIDLArrayTime();

		x.EndValidTime = this.EndValidTime.toIDLArrayTime();

        // x.nullEndValidTime = this.nullEndValidTime;

		x.AsdmUID = this.AsdmUID;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AntennaFocusModelIDL x) {

		this.FocusModelId = x.FocusModelId;

		this.AntennaId = x.AntennaId;

		this.ReceiverBand = x.ReceiverBand;

		this.StartValidTime = new ArrayTime(x.StartValidTime);

		this.EndValidTime = new ArrayTime(x.EndValidTime);

        // this.nullEndValidTime = x.nullEndValidTime;

		this.AsdmUID = x.AsdmUID;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return FocusModelId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AntennaFocusModel.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for FocusModelId.
     */
    public int getFocusModelId () {
        return FocusModelId;
    }

    /**
     * Set FocusModelId to the specified value.
     */
    public void setFocusModelId(int FocusModelId) {

        this.FocusModelId = FocusModelId;

    }

    /**
     * Get the value for AntennaId.
     */
    public int getAntennaId () {
        return AntennaId;
    }

    /**
     * Set AntennaId to the specified value.
     */
    public void setAntennaId(int AntennaId) {

        this.AntennaId = AntennaId;

    }

    /**
     * Get the value for ReceiverBand.
     */
    public String getReceiverBand () {
        return ReceiverBand;
    }

    /**
     * Set ReceiverBand to the specified value.
     */
    public void setReceiverBand(String ReceiverBand) {

        this.ReceiverBand = ReceiverBand;

    }

    /**
     * Get the value for StartValidTime.
     */
    public ArrayTime getStartValidTime () {
        return StartValidTime;
    }

    /**
     * Set StartValidTime to the specified value.
     */
    public void setStartValidTime(ArrayTime StartValidTime) {

        this.StartValidTime = StartValidTime;

    }

    /**
     * Get the value for EndValidTime.
     */
    public ArrayTime getEndValidTime () {
        return EndValidTime;
    }

    /**
     * Set EndValidTime to the specified value.
     */
    public void setEndValidTime(ArrayTime EndValidTime) {

        // nullEndValidTime = false;

        this.EndValidTime = EndValidTime;

    }

    /*
     * Is the EndValidTime null?
     */
    // public boolean isEndValidTimeNull() {
    //	return nullEndValidTime;
    // }

    /*
     * Set the null indicator for EndValidTime
     */       
    // public void setEndValidTimeNull() {
    // 	nullEndValidTime = true;
    // }

    /**
     * Get the value for AsdmUID.
     */
    public String getAsdmUID () {
        return AsdmUID;
    }

    /**
     * Set AsdmUID to the specified value.
     */
    public void setAsdmUID(String AsdmUID) {

        this.AsdmUID = AsdmUID;

    }

}
