/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AntennaDelayModelTerm.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AntennaDelayModelTermIDL;

/**

 * The AntennaDelayModelTerm table gives the measured terms for the designated antenna delay model.

   * Key: DelayModelId, CoeffName

 *
 */
public class AntennaDelayModelTerm implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int DelayModelId;

    private String CoeffName;

    private double CoeffValue;

    private double CoeffError;

    /**
     * Default Constructor for AntennaDelayModelTerm.  Setter methods must be used to insert data.
     */
    public AntennaDelayModelTerm () {

    }

    /**
     * Create a AntennaDelayModelTerm by specifiying all data values.
     */
    public AntennaDelayModelTerm (

        int DelayModelId,

        String CoeffName,

        double CoeffValue,

        double CoeffError

    ) {

		setDelayModelId(DelayModelId);

		setCoeffName(CoeffName);

		setCoeffValue(CoeffValue);

		setCoeffError(CoeffError);

    }

    /**
     * Create a AntennaDelayModelTerm by specifiying data values as an array of strings.
     */
    public AntennaDelayModelTerm (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DelayModelId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CoeffName = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CoeffValue = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.CoeffError = new Double(Double.parseDouble(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AntennaDelayModelTerm:" + newline;

        s += "\tDelayModelId: " + DelayModelId + newline;

        s += "\tCoeffName: " + CoeffName + newline;

        s += "\tCoeffValue: " + CoeffValue + newline;

        s += "\tCoeffError: " + CoeffError + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AntennaDelayModelTerm" + delimiter;  

        s += DelayModelId + delimiter;

        s += CoeffName + delimiter;

        s += CoeffValue + delimiter;

        s += CoeffError + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AntennaDelayModelTerm" + delimiter  

        	+ "DelayModelId" + delimiter

        	+ "CoeffName" + delimiter

        	+ "CoeffValue" + delimiter

        	+ "CoeffError" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AntennaDelayModelTerm)) return false;
    	AntennaDelayModelTerm arg = (AntennaDelayModelTerm) obj;

		if (this.DelayModelId != arg.DelayModelId)
			return false;

		if (this.CoeffName == null) {	// Two null strings are equal
			if (arg.CoeffName == null)
				return true;
			else
				return false;
		}
		if (!this.CoeffName.equals(arg.CoeffName))
			return false; 

		if (this.CoeffValue != arg.CoeffValue)
			return false;

		if (this.CoeffError != arg.CoeffError)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AntennaDelayModelTermIDL toIDL() {
    	AntennaDelayModelTermIDL x = new AntennaDelayModelTermIDL ();

		x.DelayModelId = this.DelayModelId;

		x.CoeffName = this.CoeffName;

		x.CoeffValue = this.CoeffValue;

		x.CoeffError = this.CoeffError;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AntennaDelayModelTermIDL x) {

		this.DelayModelId = x.DelayModelId;

		this.CoeffName = x.CoeffName;

		this.CoeffValue = x.CoeffValue;

		this.CoeffError = x.CoeffError;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AntennaDelayModelTerm.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for DelayModelId.
     */
    public int getDelayModelId () {
        return DelayModelId;
    }

    /**
     * Set DelayModelId to the specified value.
     */
    public void setDelayModelId(int DelayModelId) {

        this.DelayModelId = DelayModelId;

    }

    /**
     * Get the value for CoeffName.
     */
    public String getCoeffName () {
        return CoeffName;
    }

    /**
     * Set CoeffName to the specified value.
     */
    public void setCoeffName(String CoeffName) {

        this.CoeffName = CoeffName;

    }

    /**
     * Get the value for CoeffValue.
     */
    public double getCoeffValue () {
        return CoeffValue;
    }

    /**
     * Set CoeffValue to the specified value.
     */
    public void setCoeffValue(double CoeffValue) {

        this.CoeffValue = CoeffValue;

    }

    /**
     * Get the value for CoeffError.
     */
    public double getCoeffError () {
        return CoeffError;
    }

    /**
     * Set CoeffError to the specified value.
     */
    public void setCoeffError(double CoeffError) {

        this.CoeffError = CoeffError;

    }

}
