/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AntennaDelayModel.java
 */
package alma.TMCDB.generated;

import alma.TMCDB.types.ArrayTime;

import alma.TMCDB_GEN_IDL.AntennaDelayModelIDL;

/**

 * The antenna delay model gives the measured terms for calculating delays associated

 * with the antenna, pad and receiver band.

   * Key: DelayModelId is automatically generated from:  AntennaId, PadId, ReceiverBand, StartValidTime

 *
 */
public class AntennaDelayModel implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int DelayModelId;

    private int AntennaId;

    private int PadId;

    private String ReceiverBand;

    private ArrayTime StartTime;

    private ArrayTime StartValidTime;

    private ArrayTime EndValidTime;

    // private boolean nullEndValidTime;

    private String AsdmUID;

    /**
     * Default Constructor for AntennaDelayModel.  Setter methods must be used to insert data.
     */
    public AntennaDelayModel () {

        // nullEndValidTime = true;

    }

    /**
     * Create a AntennaDelayModel by specifiying all data values.
     */
    public AntennaDelayModel (

        int DelayModelId,

        int AntennaId,

        int PadId,

        String ReceiverBand,

        ArrayTime StartTime,

        ArrayTime StartValidTime,

        ArrayTime EndValidTime,

        String AsdmUID

    ) {

		setDelayModelId(DelayModelId);

		setAntennaId(AntennaId);

		setPadId(PadId);

		setReceiverBand(ReceiverBand);

		setStartTime(StartTime);

		setStartValidTime(StartValidTime);

		setEndValidTime(EndValidTime);

		setAsdmUID(AsdmUID);

    }

    /**
     * Create a AntennaDelayModel by specifiying data values as an array of strings.
     */
    public AntennaDelayModel (String[] data) {
    	if (data.length != 8)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 8)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.DelayModelId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AntennaId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.PadId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ReceiverBand = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.StartValidTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullEndValidTime = true;
			// this.EndValidTime = null;

		} else {

			// nullEndValidTime = false;

			this.EndValidTime = new ArrayTime(data[i]);

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AsdmUID = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AntennaDelayModel:" + newline;

        s += "\tDelayModelId: " + DelayModelId + newline;

        s += "\tAntennaId: " + AntennaId + newline;

        s += "\tPadId: " + PadId + newline;

        s += "\tReceiverBand: " + ReceiverBand + newline;

        s += "\tStartTime: " + StartTime.toFITS() + newline;

        s += "\tStartValidTime: " + StartValidTime.toFITS() + newline;

    	// if (EndValidTime == null)
    	//	s += "\tEndValidTime: null" + newline;
    	// else

        s += "\tEndValidTime: " + EndValidTime.toFITS() + newline;

        s += "\tAsdmUID: " + AsdmUID + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AntennaDelayModel" + delimiter;  

        s += DelayModelId + delimiter;

        s += AntennaId + delimiter;

        s += PadId + delimiter;

        s += ReceiverBand + delimiter;

		s += new String(StartTime.toFITS()) + delimiter;

		s += new String(StartValidTime.toFITS()) + delimiter;

        // if (nullEndValidTime)
        // 	s += delimiter;
        // else

		// s += new String(EndValidTime.toFITS()) + delimiter;

        s += AsdmUID + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 8;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AntennaDelayModel" + delimiter  

        	+ "DelayModelId" + delimiter

        	+ "AntennaId" + delimiter

        	+ "PadId" + delimiter

        	+ "ReceiverBand" + delimiter

        	+ "StartTime" + delimiter

        	+ "StartValidTime" + delimiter

        	+ "EndValidTime" + delimiter

        	+ "AsdmUID" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AntennaDelayModel)) return false;
    	AntennaDelayModel arg = (AntennaDelayModel) obj;

		if (this.DelayModelId != arg.DelayModelId)
			return false;

		if (this.AntennaId != arg.AntennaId)
			return false;

		if (this.PadId != arg.PadId)
			return false;

		if (this.ReceiverBand == null) {	// Two null strings are equal
			if (arg.ReceiverBand == null)
				return true;
			else
				return false;
		}
		if (!this.ReceiverBand.equals(arg.ReceiverBand))
			return false; 

		if (this.StartTime.get() != arg.StartTime.get())
			return false;

		if (this.StartValidTime.get() != arg.StartValidTime.get())
			return false;

		if (this.EndValidTime.get() != arg.EndValidTime.get())
			return false;

		if (this.AsdmUID == null) {	// Two null strings are equal
			if (arg.AsdmUID == null)
				return true;
			else
				return false;
		}
		if (!this.AsdmUID.equals(arg.AsdmUID))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AntennaDelayModelIDL toIDL() {
    	AntennaDelayModelIDL x = new AntennaDelayModelIDL ();

		x.DelayModelId = this.DelayModelId;

		x.AntennaId = this.AntennaId;

		x.PadId = this.PadId;

		x.ReceiverBand = this.ReceiverBand;

		x.StartTime = this.StartTime.toIDLArrayTime();

		x.StartValidTime = this.StartValidTime.toIDLArrayTime();

		x.EndValidTime = this.EndValidTime.toIDLArrayTime();

        // x.nullEndValidTime = this.nullEndValidTime;

		x.AsdmUID = this.AsdmUID;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AntennaDelayModelIDL x) {

		this.DelayModelId = x.DelayModelId;

		this.AntennaId = x.AntennaId;

		this.PadId = x.PadId;

		this.ReceiverBand = x.ReceiverBand;

		this.StartTime = new ArrayTime(x.StartTime);

		this.StartValidTime = new ArrayTime(x.StartValidTime);

		this.EndValidTime = new ArrayTime(x.EndValidTime);

        // this.nullEndValidTime = x.nullEndValidTime;

		this.AsdmUID = x.AsdmUID;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return DelayModelId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AntennaDelayModel.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for DelayModelId.
     */
    public int getDelayModelId () {
        return DelayModelId;
    }

    /**
     * Set DelayModelId to the specified value.
     */
    public void setDelayModelId(int DelayModelId) {

        this.DelayModelId = DelayModelId;

    }

    /**
     * Get the value for AntennaId.
     */
    public int getAntennaId () {
        return AntennaId;
    }

    /**
     * Set AntennaId to the specified value.
     */
    public void setAntennaId(int AntennaId) {

        this.AntennaId = AntennaId;

    }

    /**
     * Get the value for PadId.
     */
    public int getPadId () {
        return PadId;
    }

    /**
     * Set PadId to the specified value.
     */
    public void setPadId(int PadId) {

        this.PadId = PadId;

    }

    /**
     * Get the value for ReceiverBand.
     */
    public String getReceiverBand () {
        return ReceiverBand;
    }

    /**
     * Set ReceiverBand to the specified value.
     */
    public void setReceiverBand(String ReceiverBand) {

        this.ReceiverBand = ReceiverBand;

    }

    /**
     * Get the value for StartTime.
     */
    public ArrayTime getStartTime () {
        return StartTime;
    }

    /**
     * Set StartTime to the specified value.
     */
    public void setStartTime(ArrayTime StartTime) {

        this.StartTime = StartTime;

    }

    /**
     * Get the value for StartValidTime.
     */
    public ArrayTime getStartValidTime () {
        return StartValidTime;
    }

    /**
     * Set StartValidTime to the specified value.
     */
    public void setStartValidTime(ArrayTime StartValidTime) {

        this.StartValidTime = StartValidTime;

    }

    /**
     * Get the value for EndValidTime.
     */
    public ArrayTime getEndValidTime () {
        return EndValidTime;
    }

    /**
     * Set EndValidTime to the specified value.
     */
    public void setEndValidTime(ArrayTime EndValidTime) {

        // nullEndValidTime = false;

        this.EndValidTime = EndValidTime;

    }

    /*
     * Is the EndValidTime null?
     */
    // public boolean isEndValidTimeNull() {
    //	return nullEndValidTime;
    // }

    /*
     * Set the null indicator for EndValidTime
     */       
    // public void setEndValidTimeNull() {
    // 	nullEndValidTime = true;
    // }

    /**
     * Get the value for AsdmUID.
     */
    public String getAsdmUID () {
        return AsdmUID;
    }

    /**
     * Set AsdmUID to the specified value.
     */
    public void setAsdmUID(String AsdmUID) {

        this.AsdmUID = AsdmUID;

    }

}
