/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File AlarmCategory.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.AlarmCategoryIDL;

/**

   * Key: AlarmCategoryName

 *
 */
public class AlarmCategory implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private String AlarmCategoryName;

    private String Description;

    private String Path;

    private boolean IsDefault;

    /**
     * Default Constructor for AlarmCategory.  Setter methods must be used to insert data.
     */
    public AlarmCategory () {

    }

    /**
     * Create a AlarmCategory by specifiying all data values.
     */
    public AlarmCategory (

        String AlarmCategoryName,

        String Description,

        String Path,

        boolean IsDefault

    ) {

		setAlarmCategoryName(AlarmCategoryName);

		setDescription(Description);

		setPath(Path);

		setIsDefault(IsDefault);

    }

    /**
     * Create a AlarmCategory by specifiying data values as an array of strings.
     */
    public AlarmCategory (String[] data) {
    	if (data.length != 4)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 4)");
    	int i = 0;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.AlarmCategoryName = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Description = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.Path = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.IsDefault = new Boolean((data[i].equals("true") || data[i].equals("TRUE")) ? true : false);

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "AlarmCategory:" + newline;

        s += "\tAlarmCategoryName: " + AlarmCategoryName + newline;

        s += "\tDescription: " + Description + newline;

        s += "\tPath: " + Path + newline;

        s += "\tIsDefault: " + IsDefault + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "AlarmCategory" + delimiter;  

        s += AlarmCategoryName + delimiter;

        s += Description + delimiter;

        s += Path + delimiter;

        s += IsDefault + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 4;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#AlarmCategory" + delimiter  

        	+ "AlarmCategoryName" + delimiter

        	+ "Description" + delimiter

        	+ "Path" + delimiter

        	+ "IsDefault" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof AlarmCategory)) return false;
    	AlarmCategory arg = (AlarmCategory) obj;

		if (this.AlarmCategoryName == null) {	// Two null strings are equal
			if (arg.AlarmCategoryName == null)
				return true;
			else
				return false;
		}
		if (!this.AlarmCategoryName.equals(arg.AlarmCategoryName))
			return false; 

		if (this.Description == null) {	// Two null strings are equal
			if (arg.Description == null)
				return true;
			else
				return false;
		}
		if (!this.Description.equals(arg.Description))
			return false; 

		if (this.Path == null) {	// Two null strings are equal
			if (arg.Path == null)
				return true;
			else
				return false;
		}
		if (!this.Path.equals(arg.Path))
			return false; 

		if (this.IsDefault != arg.IsDefault)
			return false;

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public AlarmCategoryIDL toIDL() {
    	AlarmCategoryIDL x = new AlarmCategoryIDL ();

		x.AlarmCategoryName = this.AlarmCategoryName;

		x.Description = this.Description;

		x.Path = this.Path;

		x.IsDefault = this.IsDefault;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(AlarmCategoryIDL x) {

		this.AlarmCategoryName = x.AlarmCategoryName;

		this.Description = x.Description;

		this.Path = x.Path;

		this.IsDefault = x.IsDefault;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

    	return 0;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for AlarmCategory.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for AlarmCategoryName.
     */
    public String getAlarmCategoryName () {
        return AlarmCategoryName;
    }

    /**
     * Set AlarmCategoryName to the specified value.
     */
    public void setAlarmCategoryName(String AlarmCategoryName) {

        this.AlarmCategoryName = AlarmCategoryName;

    }

    /**
     * Get the value for Description.
     */
    public String getDescription () {
        return Description;
    }

    /**
     * Set Description to the specified value.
     */
    public void setDescription(String Description) {

        this.Description = Description;

    }

    /**
     * Get the value for Path.
     */
    public String getPath () {
        return Path;
    }

    /**
     * Set Path to the specified value.
     */
    public void setPath(String Path) {

        this.Path = Path;

    }

    /**
     * Get the value for IsDefault.
     */
    public boolean getIsDefault () {
        return IsDefault;
    }

    /**
     * Set IsDefault to the specified value.
     */
    public void setIsDefault(boolean IsDefault) {

        this.IsDefault = IsDefault;

    }

}
