/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 * 
 * /////////////////////////////////////////////////////////////////
 * // WARNING!  DO NOT MODIFY THIS FILE!                          //
 * //  ---------------------------------------------------------  //
 * // | This is generated code!  Do not modify this file.       | //
 * // | Any changes will be lost when the file is re-generated. | //
 * //  ---------------------------------------------------------  //
 * /////////////////////////////////////////////////////////////////
 *
 * File ACS.java
 */
package alma.TMCDB.generated;

import alma.TMCDB_GEN_IDL.ACSIDL;

/**

 * The ACS table contains values of environment variables and other information needed to start ACS.

 * Only one computer is referenced but in the future there may be more than one referenced to specify where Major ACS modules may run.

 * This table is obviously incomplete, but will be in the future.  The intention is to specify values of variables that might be overridden from the ACS installation in a run-time configuration.

   * Key: ACSId is automatically generated from:  ACSVersion, ConfigurationId, ComputerId

 *
 */
public class ACS implements alma.TMCDB.TableBase, java.io.Serializable {
    static private final String newline = System.getProperty("line.separator");

    private int ACSId;

    private String ACSVersion;

    private int ConfigurationId;

    private int ComputerId;

    private String Var1;

    // private boolean nullVar1;

    private String Var2;

    // private boolean nullVar2;

    private String Var3;

    // private boolean nullVar3;

    /**
     * Default Constructor for ACS.  Setter methods must be used to insert data.
     */
    public ACS () {

        // nullVar1 = true;

        // nullVar2 = true;

        // nullVar3 = true;

    }

    /**
     * Create a ACS by specifiying all data values.
     */
    public ACS (

        int ACSId,

        String ACSVersion,

        int ConfigurationId,

        int ComputerId,

        String Var1,

        String Var2,

        String Var3

    ) {

		setACSId(ACSId);

		setACSVersion(ACSVersion);

		setConfigurationId(ConfigurationId);

		setComputerId(ComputerId);

		setVar1(Var1);

		setVar2(Var2);

		setVar3(Var3);

    }

    /**
     * Create a ACS by specifiying data values as an array of strings.
     */
    public ACS (String[] data) {
    	if (data.length != 7)
    		throw new IllegalArgumentException("Wrong number of items in the data array!  (" + data.length + " are specified; should be 7)");
    	int i = 0;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ACSId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ACSVersion = data[i];

		}

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ConfigurationId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

	  try {

		if (data[i] == null || data[i].length() == 0) {

			throw new IllegalArgumentException("Invalid data format: Data item number " + i + " cannot be null.");

		} else {

			this.ComputerId = new Integer(Integer.parseInt(data[i]));

		}

	  } catch (NumberFormatException err) {
			throw new IllegalArgumentException("Invalid number format: (" + data[i] + ").");
	  }

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullVar1 = true;
			// this.Var1 = null;

		} else {

			// nullVar1 = false;

			this.Var1 = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullVar2 = true;
			// this.Var2 = null;

		} else {

			// nullVar2 = false;

			this.Var2 = data[i];

		}

		++i;

		if (data[i] == null || data[i].length() == 0) {

			// nullVar3 = true;
			// this.Var3 = null;

		} else {

			// nullVar3 = false;

			this.Var3 = data[i];

		}

		++i;

    }

    /**
     * Display the values of this object.
     */
    public String toString() {
    	String s =  "ACS:" + newline;

        s += "\tACSId: " + ACSId + newline;

        s += "\tACSVersion: " + ACSVersion + newline;

        s += "\tConfigurationId: " + ConfigurationId + newline;

        s += "\tComputerId: " + ComputerId + newline;

    	// if (Var1 == null)
    	//	s += "\tVar1: null" + newline;
    	// else

        s += "\tVar1: " + Var1 + newline;

    	// if (Var2 == null)
    	//	s += "\tVar2: null" + newline;
    	// else

        s += "\tVar2: " + Var2 + newline;

    	// if (Var3 == null)
    	//	s += "\tVar3: null" + newline;
    	// else

        s += "\tVar3: " + Var3 + newline;

    	return s;
    }

    /**
     * Create a string in the "unload" format.
     */
    public String toString(String delimiter) {
    	String s =  "ACS" + delimiter;  

        s += ACSId + delimiter;

        s += ACSVersion + delimiter;

        s += ConfigurationId + delimiter;

        s += ComputerId + delimiter;

        // if (nullVar1)
        // 	s += delimiter;
        // else

        	// s += Var1 + delimiter;

        // if (nullVar2)
        // 	s += delimiter;
        // else

        	// s += Var2 + delimiter;

        // if (nullVar3)
        // 	s += delimiter;
        // else

        	// s += Var3 + delimiter;

    	return s;
    }

    /**
     * Return the number of columns in the table.
     */
    public static int getNumberColumns() {
    	return 7;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public static String getColumnNames(String delimiter) {
    	String s =  "#ACS" + delimiter  

        	+ "ACSId" + delimiter

        	+ "ACSVersion" + delimiter

        	+ "ConfigurationId" + delimiter

        	+ "ComputerId" + delimiter

        	+ "Var1" + delimiter

        	+ "Var2" + delimiter

        	+ "Var3" + delimiter

			;
    	return s;
    }

    /**
     * Create a string with the column names in the "unload" format.
     */
    public String getTheColumnNames(String delimiter) {
    	return getColumnNames(delimiter);
    }

    /**
     * Compare this oblect with another object of the same type.
     */
    public boolean equals(Object obj) {
    	if (obj == null) return false;
    	if (!(obj instanceof ACS)) return false;
    	ACS arg = (ACS) obj;

		if (this.ACSId != arg.ACSId)
			return false;

		if (this.ACSVersion == null) {	// Two null strings are equal
			if (arg.ACSVersion == null)
				return true;
			else
				return false;
		}
		if (!this.ACSVersion.equals(arg.ACSVersion))
			return false; 

		if (this.ConfigurationId != arg.ConfigurationId)
			return false;

		if (this.ComputerId != arg.ComputerId)
			return false;

		if (this.Var1 == null) {	// Two null strings are equal
			if (arg.Var1 == null)
				return true;
			else
				return false;
		}
		if (!this.Var1.equals(arg.Var1))
			return false; 

		if (this.Var2 == null) {	// Two null strings are equal
			if (arg.Var2 == null)
				return true;
			else
				return false;
		}
		if (!this.Var2.equals(arg.Var2))
			return false; 

		if (this.Var3 == null) {	// Two null strings are equal
			if (arg.Var3 == null)
				return true;
			else
				return false;
		}
		if (!this.Var3.equals(arg.Var3))
			return false; 

		return true;   
    }

    /**
     * Convert this object to its IDL format.
     */
    public ACSIDL toIDL() {
    	ACSIDL x = new ACSIDL ();

		x.ACSId = this.ACSId;

		x.ACSVersion = this.ACSVersion;

		x.ConfigurationId = this.ConfigurationId;

		x.ComputerId = this.ComputerId;

		x.Var1 = this.Var1;

        // x.nullVar1 = this.nullVar1;

		x.Var2 = this.Var2;

        // x.nullVar2 = this.nullVar2;

		x.Var3 = this.Var3;

        // x.nullVar3 = this.nullVar3;

    	return x;
    }

    /**
     *  Populate this object from an IDL format.
     */
    public void fromIDL(ACSIDL x) {

		this.ACSId = x.ACSId;

		this.ACSVersion = x.ACSVersion;

		this.ConfigurationId = x.ConfigurationId;

		this.ComputerId = x.ComputerId;

		this.Var1 = x.Var1;

        // this.nullVar1 = x.nullVar1;

		this.Var2 = x.Var2;

        // this.nullVar2 = x.nullVar2;

		this.Var3 = x.Var3;

        // this.nullVar3 = x.nullVar3;

    }

    /*
     * If this is a database entry has a generated key, return the value
     * of its generated id; otherwise, return 0.
     */
    public int getId() {

		return ACSId;

    }

    /////////////////////////////////////////////////////////////
    // Getter and Setter Methods for ACS.
    /////////////////////////////////////////////////////////////

    /**
     * Get the value for ACSId.
     */
    public int getACSId () {
        return ACSId;
    }

    /**
     * Set ACSId to the specified value.
     */
    public void setACSId(int ACSId) {

        this.ACSId = ACSId;

    }

    /**
     * Get the value for ACSVersion.
     */
    public String getACSVersion () {
        return ACSVersion;
    }

    /**
     * Set ACSVersion to the specified value.
     */
    public void setACSVersion(String ACSVersion) {

        this.ACSVersion = ACSVersion;

    }

    /**
     * Get the value for ConfigurationId.
     */
    public int getConfigurationId () {
        return ConfigurationId;
    }

    /**
     * Set ConfigurationId to the specified value.
     */
    public void setConfigurationId(int ConfigurationId) {

        this.ConfigurationId = ConfigurationId;

    }

    /**
     * Get the value for ComputerId.
     */
    public int getComputerId () {
        return ComputerId;
    }

    /**
     * Set ComputerId to the specified value.
     */
    public void setComputerId(int ComputerId) {

        this.ComputerId = ComputerId;

    }

    /**
     * Get the value for Var1.
     */
    public String getVar1 () {
        return Var1;
    }

    /**
     * Set Var1 to the specified value.
     */
    public void setVar1(String Var1) {

        // nullVar1 = false;

        this.Var1 = Var1;

    }

    /*
     * Is the Var1 null?
     */
    // public boolean isVar1Null() {
    //	return nullVar1;
    // }

    /*
     * Set the null indicator for Var1
     */       
    // public void setVar1Null() {
    // 	nullVar1 = true;
    // }

    /**
     * Get the value for Var2.
     */
    public String getVar2 () {
        return Var2;
    }

    /**
     * Set Var2 to the specified value.
     */
    public void setVar2(String Var2) {

        // nullVar2 = false;

        this.Var2 = Var2;

    }

    /*
     * Is the Var2 null?
     */
    // public boolean isVar2Null() {
    //	return nullVar2;
    // }

    /*
     * Set the null indicator for Var2
     */       
    // public void setVar2Null() {
    // 	nullVar2 = true;
    // }

    /**
     * Get the value for Var3.
     */
    public String getVar3 () {
        return Var3;
    }

    /**
     * Set Var3 to the specified value.
     */
    public void setVar3(String Var3) {

        // nullVar3 = false;

        this.Var3 = Var3;

    }

    /*
     * Is the Var3 null?
     */
    // public boolean isVar3Null() {
    //	return nullVar3;
    // }

    /*
     * Set the null indicator for Var3
     */       
    // public void setVar3Null() {
    // 	nullVar3 = true;
    // }

}
