package alma.xmlstore;

/**
 * XML binding class aware ACS component interface IdentifierJ */
public interface IdentifierJ extends alma.ACS.ACSComponentOperations
{
    /**
     * 
     * Returns an array of new UniqueIdentifiers. The number of UniqueIdentifiers is
     * specified by the input parameter number
     */
    public String[] getUIDs(short number)
        throws alma.xmlstore.IdentifierPackage.NotAvailable;

    /**
     * 
     * RESTRICTED USE: Only the Container may call this, other subsystems use
     * the method getUIDs().
     * 
     * Returns a new UniqueIdentifier. Its local part (the hex number following
     * the second X) will always be "00000000". Should only be used by the 
     * Container.  
     */
    public String getIdNamespace()
        throws alma.xmlstore.IdentifierPackage.NotAvailable;

    /**
     * Operation getNewRange
     */
    public alma.archive.range.IdentifierRange getNewRange()
        throws alma.xmlstore.IdentifierPackage.NotAvailable;

    /**
     * Operation getNewRestrictedRange
     */
    public alma.archive.range.IdentifierRange getNewRestrictedRange(int number, String user)
        throws alma.xmlstore.IdentifierPackage.NotAvailable;

    /**
     * Operation getExistingRange
     */
    public alma.archive.range.IdentifierRange getExistingRange(String identifier, String user)
        throws alma.xmlstore.IdentifierPackage.NotFound;

    /**
     * returns true if identifier is a syntactically correct UID, else false.
     */
    public boolean checkUIDsyntax(String identifier);

}
