/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.tmcdb.DAO;

import alma.TMCDB.TimeValue;
import alma.archive.tmcdb.DAO.TimeValuePager;
import alma.archive.tmcdb.Persistence.Util.TMCDBPersistence;
import alma.archive.tmcdb.Persistence.pojo.MonitorData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

public class TimeValuePagerImpl
implements TimeValuePager {
    private long monitorPointId;
    private Timestamp startTimestamp;
    private Timestamp stopTimestamp;
    private long maxSampleResults;
    private long maxRowResults;
    private int currentPage;
    private int totalPages;
    private int pageSize;
    private String monitorPointName;
    private List clobResultList;
    private String datatype;
    private TMCDBPersistence myPersistenceLayer = new TMCDBPersistence();

    public TimeValuePagerImpl() {
    }

    @Override
    public TimeValuePager.DataType getDataType() {
        if (this.datatype.equalsIgnoreCase("integer")) {
            return TimeValuePager.DataType.INTEGER;
        }
        if (this.datatype.equalsIgnoreCase("float")) {
            return TimeValuePager.DataType.FLOAT;
        }
        if (this.datatype.equalsIgnoreCase("string")) {
            return TimeValuePager.DataType.STRING;
        }
        if (this.datatype.equalsIgnoreCase("boolean")) {
            return TimeValuePager.DataType.BOOLEAN;
        }
        if (this.datatype.equalsIgnoreCase("double")) {
            return TimeValuePager.DataType.DOUBLE;
        }
        return TimeValuePager.DataType.UNKNOWN;
    }

    @Override
    public ArrayList<TimeValue> getValues() {
        return this.parseCurrentClobResultList();
    }

    @Override
    public int getCurrentPageNumber() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPageNumber(int n) {
        this.currentPage = n;
    }

    @Override
    public int getTotalNumberOfPages() {
        return this.totalPages;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getMonitorPointName() {
        return this.monitorPointName;
    }

    @Override
    public boolean hasNextPage() {
        return this.totalPages - 1 - this.currentPage != 0;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.currentPage != 0;
    }

    @Override
    public TimeValuePager getNextPage() {
        if (this.hasNextPage()) {
            ++this.currentPage;
            this.clobResultList = this.getCurrentResults();
            return this;
        }
        return null;
    }

    @Override
    public TimeValuePager getPreviousPage() {
        --this.currentPage;
        this.clobResultList = this.getCurrentResults();
        return this;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public TimeValuePagerImpl(long l, Timestamp timestamp, Timestamp timestamp2) {
        this.startTimestamp = timestamp;
        this.monitorPointId = l;
        this.stopTimestamp = timestamp2;
        this.currentPage = 0;
        this.pageSize = 50;
        this.maxSampleResults = this.retrieveMaxSampleResultsMonitorData();
        this.maxRowResults = this.retrieveMaxRowResultsMonitorData();
        this.totalPages = (int)Math.floor(this.maxRowResults / (long)this.pageSize + 1L);
        this.monitorPointName = this.retrieveMonitorPointName();
        this.datatype = this.retrieveDataType();
        this.clobResultList = this.getCurrentResults();
    }

    private ArrayList<TimeValue> parseCurrentClobResultList() {
        ArrayList<TimeValue> arrayList = new ArrayList<TimeValue>();
        for (Object e : this.clobResultList) {
            String string = ((MonitorData)e).getMonitorClob();
            String[] stringArray = null;
            stringArray = string.split("\\|");
            for (int i = 0; i < stringArray.length; i += 2) {
                TimeValue timeValue = new TimeValue(Long.parseLong(stringArray[i].trim()), stringArray[i + 1]);
                arrayList.add(timeValue);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long retrieveMaxRowResultsMonitorData() {
        long l = 0L;
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("getMaxRowResultsMonitorData");
            query.setParameter("monitorPointId", (Object)this.monitorPointId);
            query.setParameter("startTimestamp", (Object)this.startTimestamp);
            query.setParameter("stopTimestamp", (Object)this.stopTimestamp);
            try {
                l = ((Long)query.getSingleResult()).intValue();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        finally {
            entityManager.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long retrieveMaxSampleResultsMonitorData() {
        int n = 0;
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("getMaxSampleResultsMonitorData");
            query.setParameter("monitorPointId", (Object)this.monitorPointId);
            query.setParameter("startTimestamp", (Object)this.startTimestamp);
            query.setParameter("stopTimestamp", (Object)this.stopTimestamp);
            try {
                n = ((Long)query.getSingleResult()).intValue();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        finally {
            entityManager.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveMonitorPointName() {
        String string = "";
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("findMonitorPointNameGivenMonitorPointId");
            query.setParameter("monitorPointId", (Object)this.monitorPointId);
            try {
                string = query.getSingleResult().toString();
            }
            catch (NoResultException noResultException) {
                string = "no name";
            }
        }
        finally {
            entityManager.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveDataType() {
        String string = "";
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("findDatatypeGivenMonitorPointId");
            query.setParameter("monitorPointId", (Object)this.monitorPointId);
            try {
                string = (String)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
                string = "no datatype defined";
            }
        }
        finally {
            entityManager.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getCurrentResults() {
        List list = null;
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("findMonitorDataByMonitorPointIdAndTimestampRange");
            query.setFirstResult(this.currentPage * this.pageSize);
            query.setMaxResults(this.pageSize);
            query.setParameter("monitorPointId", (Object)this.monitorPointId);
            query.setParameter("startTimestamp", (Object)this.startTimestamp);
            query.setParameter("stopTimestamp", (Object)this.stopTimestamp);
            try {
                list = query.getResultList();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        finally {
            entityManager.close();
        }
        return list;
    }
}

