/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.tmcdb.DAO;

import alma.archive.tmcdb.DAO.QueryDAO;
import alma.archive.tmcdb.DAO.TimeValuePager;
import alma.archive.tmcdb.DAO.TimeValuePagerImpl;
import alma.archive.tmcdb.Persistence.Util.TMCDBConfig;
import alma.archive.tmcdb.Persistence.Util.TMCDBPersistence;
import alma.archive.tmcdb.Persistence.pojo.Assembly;
import alma.archive.tmcdb.Persistence.pojo.BACIProperty;
import alma.archive.tmcdb.Persistence.pojo.Component;
import alma.archive.tmcdb.Persistence.pojo.Configuration;
import alma.archive.tmcdb.Persistence.pojo.MonitorPoint;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

public class QueryDAOImpl
implements QueryDAO {
    private Logger log;
    private TMCDBPersistence myPersistenceLayer = new TMCDBPersistence();
    private String myConfigName = TMCDBConfig.getInstance().getConfigurationName();

    public QueryDAOImpl(Logger logger) {
        this.log = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMonitorDataList(long l, Timestamp timestamp, Timestamp timestamp2) {
        List list = null;
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("findMonitorDataByMonitorPointIdAndTimestampRange");
            query.setParameter("monitorPointId", (Object)l);
            query.setParameter("startTimestamp", (Object)timestamp);
            query.setParameter("stopTimestamp", (Object)timestamp2);
            try {
                list = query.getResultList();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        finally {
            entityManager.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getLocations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("findConfigurationByName");
            query.setParameter("configurationName", (Object)this.myConfigName);
            Configuration configuration = (Configuration)query.getSingleResult();
            long l = configuration.getConfigurationId();
            Query query2 = entityManager.createNamedQuery("findAllComponentsByConfigurationId");
            query2.setParameter("configurationId", (Object)l);
            List list = query2.getResultList();
            for (Object e : list) {
                if (((Component)e).getComponentName().indexOf("CONTROL") != -1) {
                    int n = ((Component)e).getComponentName().indexOf("/");
                    int n2 = ((Component)e).getComponentName().indexOf("/", n + 1);
                    this.log.info("ComponentName=" + ((Component)e).getComponentName());
                    this.log.info("firstSlash=" + n);
                    this.log.info("secondSlash=" + n2);
                    if (n == -1 || n2 == -1) continue;
                    String string = ((Component)e).getComponentName().substring(n + 1, n2);
                    this.log.info("location=" + string);
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                    continue;
                }
                if (((Component)e).getComponentName().indexOf("AOSTiming") != -1) {
                    if (arrayList.contains("AOSTiming")) continue;
                    arrayList.add("AOSTiming");
                    continue;
                }
                if (((Component)e).getComponentName().indexOf("CentralLO") == -1 || arrayList.contains("CentralLO")) continue;
                arrayList.add("CentralLO");
            }
        }
        finally {
            entityManager.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComponentName(String string, String string2) {
        String string3 = "";
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("findConfigurationByName");
            query.setParameter("configurationName", (Object)string2);
            Configuration configuration = (Configuration)query.getSingleResult();
            long l = configuration.getConfigurationId();
            Query query2 = entityManager.createNamedQuery("findAssemblyBySerialNumberAndConfigurationId");
            query2.setParameter("serialNumber", (Object)string);
            query2.setParameter("configurationId", (Object)l);
            Assembly assembly = (Assembly)query2.getSingleResult();
            Long l2 = assembly.getAssemblyId();
            Query query3 = entityManager.createNamedQuery("findMonitorPointByAssemblyId");
            query3.setParameter("assemblyId", (Object)l2);
            List list = query3.getResultList();
            Long l3 = ((MonitorPoint)list.get(0)).getBaciPropertyId();
            Query query4 = entityManager.createNamedQuery("findBACIPropertyByBaciPropertyId");
            query4.setParameter("baciPropertyId", (Object)l3);
            BACIProperty bACIProperty = (BACIProperty)query4.getSingleResult();
            Long l4 = bACIProperty.getComponentId();
            Query query5 = entityManager.createNamedQuery("findComponentByComponentId");
            query5.setParameter("componentId", (Object)l4);
            Component component = (Component)query5.getSingleResult();
            string3 = component.getComponentName();
        }
        finally {
            entityManager.close();
        }
        return string3;
    }

    @Override
    public String getComponentName(String string) {
        return this.getComponentName(string, this.myConfigName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerialNumber(String string, String string2) {
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        String string3 = "";
        try {
            Query query = entityManager.createNamedQuery("findConfigurationByName");
            query.setParameter("configurationName", (Object)string2);
            Configuration configuration = (Configuration)query.getSingleResult();
            long l = configuration.getConfigurationId();
            this.log.info("getSerialNumber---> configurationId=" + l);
            Query query2 = entityManager.createNamedQuery("findComponentByComponentName");
            query2.setParameter("componentName", (Object)string);
            query2.setParameter("configurationId", (Object)l);
            Component component = (Component)query2.getSingleResult();
            Long l2 = component.getComponentId();
            this.log.info("getSerialNumber---> componentId=" + l2);
            Query query3 = entityManager.createNamedQuery("findBACIPropertyByComponentId");
            query3.setParameter("componentId", (Object)l2);
            List list = query3.getResultList();
            Long l3 = ((BACIProperty)list.get(0)).getBACIPropertyId();
            this.log.info("getSerialNumber---> baciPropertyId=" + l3);
            Query query4 = entityManager.createNamedQuery("findMonitorPointByBACIPropertyId");
            query4.setParameter("baciPropertyId", (Object)l3);
            List list2 = query4.getResultList();
            Long l4 = ((MonitorPoint)list2.get(0)).getAssemblyId();
            this.log.info("getSerialNumber---> assemblyId=" + l4);
            Query query5 = entityManager.createNamedQuery("findAssemblyByAssemblyIdAndConfigurationId");
            query5.setParameter("assemblyId", (Object)l4);
            query5.setParameter("configurationId", (Object)l);
            Assembly assembly = (Assembly)query5.getSingleResult();
            string3 = assembly.getSerialNumber();
            this.log.info("getSerialNumber---> serialNumber=" + assembly.getSerialNumber());
        }
        finally {
            entityManager.close();
        }
        return string3;
    }

    @Override
    public String getSerialNumber(String string) {
        return this.getSerialNumber(string, this.myConfigName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getAllSerialNumbers(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        try {
            Query query = entityManager.createNamedQuery("findConfigurationByName");
            query.setParameter("configurationName", (Object)string);
            Configuration configuration = (Configuration)query.getSingleResult();
            long l = configuration.getConfigurationId();
            Query query2 = entityManager.createNamedQuery("findAssemblyByConfigurationId");
            query2.setParameter("configurationId", (Object)l);
            List list = query2.getResultList();
            for (Object e : list) {
                arrayList.add(((Assembly)e).getSerialNumber());
            }
        }
        finally {
            entityManager.close();
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getAllSerialNumbers() {
        return this.getAllSerialNumbers(this.myConfigName);
    }

    @Override
    public TimeValuePager getMonitorData(long l, Timestamp timestamp, Timestamp timestamp2) {
        TimeValuePagerImpl timeValuePagerImpl = new TimeValuePagerImpl(l, timestamp, timestamp2);
        return timeValuePagerImpl;
    }
}

