/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.tmcdb.DAO;

import alma.DAOErrType.wrappers.AcsJDynConfigFailureEx;
import alma.DAOErrType.wrappers.AcsJGettingMonitorCharacteristicsEx;
import alma.DAOErrType.wrappers.AcsJStoreFailureEx;
import alma.archive.tmcdb.DAO.ComponentData;
import alma.archive.tmcdb.DAO.ComponentResolver;
import alma.archive.tmcdb.DAO.MonitorCharacteristicIDs;
import alma.archive.tmcdb.DAO.MonitorDAO;
import alma.archive.tmcdb.Persistence.Util.TMCDBConfig;
import alma.archive.tmcdb.Persistence.Util.TMCDBPersistence;
import alma.archive.tmcdb.Persistence.pojo.Assembly;
import alma.archive.tmcdb.Persistence.pojo.AssemblyType;
import alma.archive.tmcdb.Persistence.pojo.BACIProperty;
import alma.archive.tmcdb.Persistence.pojo.Component;
import alma.archive.tmcdb.Persistence.pojo.ComponentType;
import alma.archive.tmcdb.Persistence.pojo.Configuration;
import alma.archive.tmcdb.Persistence.pojo.DefaultBACIProperty;
import alma.archive.tmcdb.Persistence.pojo.DefaultComponent;
import alma.archive.tmcdb.Persistence.pojo.DefaultMonitorPoint;
import alma.archive.tmcdb.Persistence.pojo.MonitorData;
import alma.archive.tmcdb.Persistence.pojo.MonitorPoint;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;

public class MonitorDAOImpl
implements MonitorDAO {
    private Logger log;
    private HashMap<String, Object> myConfiguredComponentsMap = new HashMap();
    private TMCDBPersistence myPersistenceLayer = new TMCDBPersistence();
    private EntityManager entityManagerStore;
    private EntityTransaction transactionStore;
    private boolean dbConnectionEnabled = false;

    public MonitorDAOImpl(Logger logger) {
        this.log = logger;
        this.dbConnectionEnabled = TMCDBConfig.getInstance().isDBConnectionEnabled();
    }

    @Override
    public void close() {
        this.myPersistenceLayer.close();
    }

    @Override
    public void openTransactionStore() {
        this.entityManagerStore = this.myPersistenceLayer.getEntityManager();
        this.transactionStore = this.entityManagerStore.getTransaction();
        this.transactionStore.begin();
    }

    @Override
    public void closeTransactionStore() {
        this.transactionStore.commit();
        this.entityManagerStore.close();
    }

    private boolean hasFailedToConfigured(ComponentData componentData) {
        String string = componentData.componentName + ":" + componentData.propertyName + ":" + componentData.index;
        return this.myConfiguredComponentsMap.containsKey(string);
    }

    private void failedToConfigured(ComponentData componentData) {
        String string = componentData.componentName + ":" + componentData.propertyName + ":" + componentData.index;
        this.myConfiguredComponentsMap.put(string, null);
        this.log.fine("Dynamic configuration failed for blob " + string);
    }

    private Long getConfigurationId(EntityManager entityManager, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findConfigurationByName");
        query.setParameter("configurationName", (Object)string);
        Configuration configuration = (Configuration)query.getSingleResult();
        Long l = configuration.getConfigurationId();
        this.log.fine("ConfigurationId = " + l);
        return l;
    }

    private Long getAssemblyId(EntityManager entityManager, Long l, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findAssemblyBySerialNumberAndConfigurationId");
        query.setParameter("serialNumber", (Object)string);
        query.setParameter("configurationId", (Object)l);
        Assembly assembly = (Assembly)query.getSingleResult();
        Long l2 = assembly.getAssemblyId();
        this.log.fine("assemblyId = " + l2);
        return l2;
    }

    private Long getComponentId(EntityManager entityManager, Long l, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findComponentByComponentName");
        query.setParameter("componentName", (Object)string);
        query.setParameter("configurationId", (Object)l);
        Component component = (Component)query.getSingleResult();
        Long l2 = component.getComponentId();
        this.log.fine("componentId = " + l2);
        return l2;
    }

    private Long getBaciPropertyId(EntityManager entityManager, Long l, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findBACIPropertyIdByPropertyNameANDComponentId");
        query.setParameter("componentId", (Object)l);
        query.setParameter("propertyName", (Object)string);
        BACIProperty bACIProperty = (BACIProperty)query.getSingleResult();
        Long l2 = bACIProperty.getBACIPropertyId();
        this.log.fine("baciPropertyId = " + l2);
        return l2;
    }

    private Long getMonitorPointId(EntityManager entityManager, Long l, Long l2, int n) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findMonitorPointIdByAssemblyIdANDBACIPropertyIdANDIndex");
        query.setParameter("assemblyId", (Object)l);
        query.setParameter("baciPropertyId", (Object)l2);
        query.setParameter("index", (Object)n);
        MonitorPoint monitorPoint = (MonitorPoint)query.getSingleResult();
        Long l3 = monitorPoint.getMonitorPointId();
        this.log.fine("index = " + n);
        this.log.fine("monitorPointId = " + l3);
        return l3;
    }

    public MonitorCharacteristicIDs getMonitorCharacteristicIDs(EntityManager entityManager, String string, ComponentData componentData) throws AcsJGettingMonitorCharacteristicsEx, AcsJDynConfigFailureEx {
        Long l;
        Long l2;
        MonitorCharacteristicIDs monitorCharacteristicIDs = new MonitorCharacteristicIDs();
        try {
            l2 = this.getConfigurationId(entityManager, string);
            monitorCharacteristicIDs.setConfigurationId(l2);
        }
        catch (NoResultException noResultException) {
            throw new AcsJGettingMonitorCharacteristicsEx("Could not find configuration matching the given name.", (Throwable)noResultException);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJGettingMonitorCharacteristicsEx("Found multiple configuration matching the given name.", (Throwable)nonUniqueResultException);
        }
        try {
            l2 = this.getAssemblyId(entityManager, monitorCharacteristicIDs.getConfigurationId(), componentData.serialNumber.toUpperCase());
            monitorCharacteristicIDs.setAssemblyId(l2);
        }
        catch (NoResultException noResultException) {
            l = this.configureNewAssembly(monitorCharacteristicIDs, componentData);
            monitorCharacteristicIDs.setAssemblyId(l);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJGettingMonitorCharacteristicsEx("Found multiple assemblyIds with serialnumber=" + componentData.serialNumber.toUpperCase(), (Throwable)nonUniqueResultException);
        }
        try {
            l2 = this.getComponentId(entityManager, monitorCharacteristicIDs.getConfigurationId(), componentData.componentName);
            monitorCharacteristicIDs.setComponentId(l2);
        }
        catch (NoResultException noResultException) {
            l = this.configureNewComponent(monitorCharacteristicIDs, componentData);
            monitorCharacteristicIDs.setComponentId(l);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJGettingMonitorCharacteristicsEx("Found multiple componentId matching the given componentName.", (Throwable)nonUniqueResultException);
        }
        try {
            l2 = this.getBaciPropertyId(entityManager, monitorCharacteristicIDs.getComponentId(), componentData.propertyName);
            monitorCharacteristicIDs.setBACIPropertyId(l2);
        }
        catch (NoResultException noResultException) {
            l = this.configureNewProperty(monitorCharacteristicIDs, componentData);
            monitorCharacteristicIDs.setBACIPropertyId(l);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJGettingMonitorCharacteristicsEx("Found multiple BACI properties matching the given property name and componentId.", (Throwable)nonUniqueResultException);
        }
        try {
            l2 = this.getMonitorPointId(entityManager, monitorCharacteristicIDs.getAssemblyId(), monitorCharacteristicIDs.getBACIPropertyId(), componentData.index);
            monitorCharacteristicIDs.setIndex(componentData.index);
            monitorCharacteristicIDs.setMonitorPointId(l2);
            monitorCharacteristicIDs.setIsOnDB(true);
        }
        catch (NoResultException noResultException) {
            l = this.configureNewMonitorPoint(monitorCharacteristicIDs, componentData);
            monitorCharacteristicIDs.setIndex(componentData.index);
            monitorCharacteristicIDs.setMonitorPointId(l);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJGettingMonitorCharacteristicsEx("Found multiple monitor points matching the given assemblyId, baciPropertyId and index.", (Throwable)nonUniqueResultException);
        }
        return monitorCharacteristicIDs;
    }

    @Override
    public void store(ComponentData componentData) throws Exception {
        this.log.fine("Handling component: " + componentData);
        if (!componentData.componentName.contains("CONTROL/LA") && this.dbConnectionEnabled) {
            if (!this.hasFailedToConfigured(componentData)) {
                MonitorCharacteristicIDs monitorCharacteristicIDs;
                try {
                    String string = TMCDBConfig.getInstance().getConfigurationName();
                    monitorCharacteristicIDs = this.getMonitorCharacteristicIDs(this.entityManagerStore, string, componentData);
                }
                catch (AcsJGettingMonitorCharacteristicsEx acsJGettingMonitorCharacteristicsEx) {
                    throw new AcsJStoreFailureEx("Failure when getting monitor characteristics", (Throwable)acsJGettingMonitorCharacteristicsEx);
                }
                catch (AcsJDynConfigFailureEx acsJDynConfigFailureEx) {
                    this.failedToConfigured(componentData);
                    this.log.fine("Monitor point could not be autoconfigured for component = " + componentData.componentName + ", serialNumber = " + componentData.serialNumber + ", propertyName = " + componentData.propertyName + ", index = " + componentData.index + " .");
                    throw new AcsJStoreFailureEx("Failure when configuring DB for: " + componentData.componentName + ":" + componentData.propertyName + ":" + componentData.index, (Throwable)acsJDynConfigFailureEx);
                }
                this.persistNewMonitorData(this.entityManagerStore, componentData, monitorCharacteristicIDs);
            } else {
                throw new AcsJStoreFailureEx("Dropping this blob since monitor point could not be configured previously");
            }
        }
    }

    public String getComponentIDL(String string) throws Exception {
        ComponentResolver componentResolver = ComponentResolver.getResolver();
        String string2 = componentResolver.resolve(string);
        return string2;
    }

    private String getAssemblyTypeName(String string) {
        String string2 = string.split(":")[1];
        String[] stringArray = string2.split("/");
        string2 = stringArray[stringArray.length - 1];
        return string2;
    }

    public Long configureNewAssembly(MonitorCharacteristicIDs monitorCharacteristicIDs, ComponentData componentData) throws AcsJDynConfigFailureEx {
        String string;
        this.log.fine("Going to add configuration for assembly with SN = " + componentData.serialNumber.toUpperCase());
        Long l = monitorCharacteristicIDs.getConfigurationId();
        try {
            string = this.getComponentIDL(componentData.componentName);
        }
        catch (Exception exception) {
            throw new AcsJDynConfigFailureEx("Could not get IDL based on component name. Aborting dynamic configuration", (Throwable)exception);
        }
        String string2 = this.getAssemblyTypeName(string);
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        try {
            Long l2;
            AssemblyType assemblyType = this.getAssemblyTypeByLikeAssemblyCode(string2, entityManager);
            this.persistNewAssembly(entityManager, assemblyType, l, componentData);
            entityTransaction.commit();
            Long l3 = l2 = this.getAssemblyId(entityManager, monitorCharacteristicIDs.getConfigurationId(), componentData.serialNumber.toUpperCase());
            return l3;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJDynConfigFailureEx("Found multiple assembly types matching the assembly code " + string2 + ".", (Throwable)nonUniqueResultException);
        }
        catch (NoResultException noResultException) {
            throw new AcsJDynConfigFailureEx("Found no assembly type matching the assembly code " + string2 + ".", (Throwable)noResultException);
        }
        catch (Exception exception) {
            if (entityTransaction != null) {
                try {
                    this.log.fine("Exception detected, rollback.");
                    entityTransaction.rollback();
                }
                catch (RuntimeException runtimeException) {
                    this.log.fine("Couldn't roll back transaction: " + runtimeException.toString());
                }
            }
            throw new AcsJDynConfigFailureEx("Failure while persisting new assembly: " + string2 + ".", (Throwable)exception);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    private Long configureNewComponent(MonitorCharacteristicIDs monitorCharacteristicIDs, ComponentData componentData) throws AcsJDynConfigFailureEx {
        String string;
        this.log.fine("Going to add configuration for component = " + componentData.componentName);
        Long l = monitorCharacteristicIDs.getConfigurationId();
        try {
            string = this.getComponentIDL(componentData.componentName);
        }
        catch (Exception exception) {
            throw new AcsJDynConfigFailureEx("Could not get IDL based on component name. Aborting dynamic configuration", (Throwable)exception);
        }
        String string2 = this.getAssemblyTypeName(string);
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        try {
            Long l2;
            ComponentType componentType = this.getComponentTypeByLikeIDL(entityManager, string);
            DefaultComponent defaultComponent = this.getDefaultComponentByLikeAssemblyTypeName(entityManager, string2);
            this.persistNewComponent(entityManager, l, componentType, componentData, defaultComponent);
            entityTransaction.commit();
            Long l3 = l2 = this.getComponentId(entityManager, monitorCharacteristicIDs.getConfigurationId(), componentData.componentName);
            return l3;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJDynConfigFailureEx("Found multiple component types matching the given IDL" + string + ".", (Throwable)nonUniqueResultException);
        }
        catch (NoResultException noResultException) {
            throw new AcsJDynConfigFailureEx("Found no component types matching the given IDL" + string + ".", (Throwable)noResultException);
        }
        catch (Exception exception) {
            if (entityTransaction != null) {
                try {
                    this.log.fine("Exception detected, rollback.");
                    entityTransaction.rollback();
                }
                catch (RuntimeException runtimeException) {
                    this.log.fine("Couldn't roll back transaction: " + runtimeException.toString());
                }
            }
            throw new AcsJDynConfigFailureEx("Failure while persisting new component: " + componentData.componentName + ".", (Throwable)exception);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    private Long configureNewProperty(MonitorCharacteristicIDs monitorCharacteristicIDs, ComponentData componentData) throws AcsJDynConfigFailureEx {
        String string;
        this.log.fine("Going to add configuration for property = " + componentData.propertyName);
        Long l = monitorCharacteristicIDs.getConfigurationId();
        Long l2 = monitorCharacteristicIDs.getComponentId();
        try {
            string = this.getComponentIDL(componentData.componentName);
        }
        catch (Exception exception) {
            throw new AcsJDynConfigFailureEx("Could not get IDL based on component name. Aborting dynamic configuration", (Throwable)exception);
        }
        String string2 = this.getAssemblyTypeName(string);
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        try {
            Long l3;
            DefaultComponent defaultComponent = this.getDefaultComponentByLikeAssemblyTypeName(entityManager, string2);
            DefaultBACIProperty defaultBACIProperty = this.getDefaultBACIPropertyByDefaultComponentIdAndPropertyName(entityManager, defaultComponent.getDefaultComponentId(), componentData.propertyName);
            this.persistNewBACIProperty(entityManager, defaultBACIProperty, l2);
            entityTransaction.commit();
            Long l4 = l3 = this.getBaciPropertyId(entityManager, l2, componentData.propertyName);
            return l4;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJDynConfigFailureEx("Found multiple default baci properties matching the given property name" + componentData.propertyName + ".", (Throwable)nonUniqueResultException);
        }
        catch (NoResultException noResultException) {
            throw new AcsJDynConfigFailureEx("Found no default baci properties matching the given property name" + componentData.propertyName + ".", (Throwable)noResultException);
        }
        catch (Exception exception) {
            if (entityTransaction != null) {
                try {
                    this.log.fine("Exception detected, rollback.");
                    entityTransaction.rollback();
                }
                catch (RuntimeException runtimeException) {
                    this.log.fine("Couldn't roll back transaction: " + runtimeException.toString());
                }
            }
            throw new AcsJDynConfigFailureEx("Failure while persisting new baci property: " + componentData.propertyName + ".", (Throwable)exception);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    private Long configureNewMonitorPoint(MonitorCharacteristicIDs monitorCharacteristicIDs, ComponentData componentData) throws AcsJDynConfigFailureEx {
        String string;
        this.log.fine("Going to add configuration for monitor point index = " + componentData.index + ", of property = " + componentData.propertyName);
        Long l = monitorCharacteristicIDs.getConfigurationId();
        Long l2 = monitorCharacteristicIDs.getAssemblyId();
        Long l3 = monitorCharacteristicIDs.getComponentId();
        Long l4 = monitorCharacteristicIDs.getBACIPropertyId();
        try {
            string = this.getComponentIDL(componentData.componentName);
        }
        catch (Exception exception) {
            throw new AcsJDynConfigFailureEx("Could not get IDL based on component name. Aborting dynamic configuration", (Throwable)exception);
        }
        String string2 = this.getAssemblyTypeName(string);
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        try {
            Long l5;
            DefaultComponent defaultComponent = this.getDefaultComponentByLikeAssemblyTypeName(entityManager, string2);
            DefaultBACIProperty defaultBACIProperty = this.getDefaultBACIPropertyByDefaultComponentIdAndPropertyName(entityManager, defaultComponent.getDefaultComponentId(), componentData.propertyName);
            DefaultMonitorPoint defaultMonitorPoint = this.getDefaultMonitorPointByDefaultBACIPropId(entityManager, defaultBACIProperty.getDefaultBACIPropertyId(), componentData.index);
            this.persistNewMonitorPoint(entityManager, defaultMonitorPoint, l4, l2);
            entityTransaction.commit();
            Long l6 = l5 = this.getMonitorPointId(entityManager, l2, l4, componentData.index);
            return l6;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw new AcsJDynConfigFailureEx("Found multiple default monitor point matching the index" + componentData.index + ".", (Throwable)nonUniqueResultException);
        }
        catch (NoResultException noResultException) {
            throw new AcsJDynConfigFailureEx("Found no default monitor point matching the given index" + componentData.index + ".", (Throwable)noResultException);
        }
        catch (Exception exception) {
            if (entityTransaction != null) {
                try {
                    this.log.fine("Exception detected, rollback.");
                    entityTransaction.rollback();
                }
                catch (RuntimeException runtimeException) {
                    this.log.fine("Couldn't roll back transaction: " + runtimeException.toString());
                }
            }
            throw new AcsJDynConfigFailureEx("Failure while persisting new monitorpoint: " + componentData.propertyName + ".", (Throwable)exception);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    private AssemblyType getAssemblyTypeByLikeAssemblyCode(String string, EntityManager entityManager) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findAssemblyTypeByLikeAssemblyCode");
        query.setParameter("assemblyTypeName", (Object)string);
        AssemblyType assemblyType = (AssemblyType)query.getSingleResult();
        this.log.fine("Assembly Type name to be associated is " + assemblyType.getAssemblyTypeName());
        return assemblyType;
    }

    private Assembly getAssemblyBySerialNumberAndConfigurationId(EntityManager entityManager, Long l, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findAssemblyBySerialNumberAndConfigurationId");
        query.setParameter("serialNumber", (Object)string.toUpperCase());
        query.setParameter("configurationId", (Object)l);
        Assembly assembly = (Assembly)query.getSingleResult();
        return assembly;
    }

    private DefaultComponent getDefaultComponentByLikeAssemblyTypeName(EntityManager entityManager, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findDefaultComponentByLikeAssemblyTypeName");
        query.setParameter("assemblyTypeName", (Object)string);
        DefaultComponent defaultComponent = (DefaultComponent)query.getSingleResult();
        this.log.fine("Default component: " + defaultComponent.getAssemblyName());
        return defaultComponent;
    }

    private ComponentType getComponentTypeByLikeIDL(EntityManager entityManager, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findComponentTypeBylikeIDL");
        query.setParameter("idl", (Object)string);
        ComponentType componentType = (ComponentType)query.getSingleResult();
        this.log.fine("Component Type with idl " + componentType.getIdl() + " associated with component.");
        return componentType;
    }

    private DefaultBACIProperty getDefaultBACIPropertyByDefaultComponentIdAndPropertyName(EntityManager entityManager, Long l, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findDefaultBACIPropertyByDefaultComponentId");
        query.setParameter("defaultComponentId", (Object)l);
        query.setParameter("propertyName", (Object)string);
        DefaultBACIProperty defaultBACIProperty = (DefaultBACIProperty)query.getSingleResult();
        return defaultBACIProperty;
    }

    private Component getComponentByComponentNameAndConfigurationId(EntityManager entityManager, Long l, String string) throws NonUniqueResultException, NoResultException {
        Query query = entityManager.createNamedQuery("findComponentByComponentName");
        query.setParameter("componentName", (Object)string);
        query.setParameter("configurationId", (Object)l);
        Component component = (Component)query.getSingleResult();
        return component;
    }

    private DefaultMonitorPoint getDefaultMonitorPointByDefaultBACIPropId(EntityManager entityManager, Long l, int n) throws NoResultException, NonUniqueResultException {
        Query query = entityManager.createNamedQuery("findDefaultMonitorPointListByDefaultBACIPropId");
        query.setParameter("defaultBACIPropertyId", (Object)l);
        query.setParameter("index", (Object)n);
        DefaultMonitorPoint defaultMonitorPoint = (DefaultMonitorPoint)query.getSingleResult();
        return defaultMonitorPoint;
    }

    private void persistNewAssembly(EntityManager entityManager, AssemblyType assemblyType, Long l, ComponentData componentData) {
        Assembly assembly = new Assembly();
        assembly.setAssemblyId(0L);
        assembly.setAssemblyTypeName(assemblyType.getAssemblyTypeName());
        assembly.setConfigurationId(l);
        assembly.setSerialNumber(componentData.serialNumber);
        entityManager.persist((Object)assembly);
        this.log.fine("Assembly " + assemblyType.getAssemblyTypeName() + "with serial number " + componentData.serialNumber + " was added to configuration id " + l);
    }

    private void persistNewComponent(EntityManager entityManager, Long l, ComponentType componentType, ComponentData componentData, DefaultComponent defaultComponent) {
        Component component = new Component();
        component.setComponentId(0L);
        component.setComponentTypeId(componentType.getComponentTypeId());
        component.setComponentName(componentData.componentName);
        component.setConfigurationId(l);
        component.setContainerId(1L);
        component.setImplLang(defaultComponent.getImplLang());
        component.setRealTime(defaultComponent.getRealTime());
        component.setCode(defaultComponent.getCode());
        component.setPath(defaultComponent.getPath());
        component.setIsAutoStart(defaultComponent.getIsAutoStart());
        component.setIsDefault(defaultComponent.getIsDefault());
        component.setIsStandaloneDefined(defaultComponent.getIsStandaloneDefined());
        component.setKeepAliveTime(defaultComponent.getKeepAliveTime());
        component.setMinLogLevel(defaultComponent.getMinLogLevel());
        component.setMinLogLevelLocal(defaultComponent.getMinLogLevelLocal());
        entityManager.persist((Object)component);
        this.log.fine("Component " + componentData.componentName + " was added to configuration id " + l);
    }

    private void persistNewBACIProperty(EntityManager entityManager, DefaultBACIProperty defaultBACIProperty, Long l) {
        BACIProperty bACIProperty = new BACIProperty();
        bACIProperty.setBACIPropertyId(0L);
        bACIProperty.setComponentId(l);
        bACIProperty.setPropertyName(defaultBACIProperty.getPropertyName());
        bACIProperty.setDescription(defaultBACIProperty.getDescription());
        bACIProperty.setIsSequence(1);
        bACIProperty.setFormat(defaultBACIProperty.getFormat());
        bACIProperty.setUnits(defaultBACIProperty.getUnits());
        bACIProperty.setResolution(defaultBACIProperty.getResolution());
        bACIProperty.setArchiveMinInt(defaultBACIProperty.getArchiveMinInt());
        bACIProperty.setArchiveMaxInt(defaultBACIProperty.getArchiveMaxInt());
        bACIProperty.setDefaultTimerTrig(defaultBACIProperty.getDefaultTimerTrig());
        bACIProperty.setMinTimerTrig(defaultBACIProperty.getMinTimerTrig());
        bACIProperty.setArchiveDelta(defaultBACIProperty.getArchiveDelta());
        bACIProperty.setInitializeDEVIO(defaultBACIProperty.getInitializeDEVIO());
        bACIProperty.setMinDeltaTrig(defaultBACIProperty.getMinDeltaTrig());
        bACIProperty.setDefaultValue(defaultBACIProperty.getDefaultValue());
        bACIProperty.setArchivePriority(defaultBACIProperty.getArchivePriority());
        entityManager.persist((Object)bACIProperty);
        this.log.fine("BACI Property " + defaultBACIProperty.getPropertyName() + " was added to configuration .");
    }

    private void persistNewMonitorPoint(EntityManager entityManager, DefaultMonitorPoint defaultMonitorPoint, Long l, Long l2) {
        MonitorPoint monitorPoint = new MonitorPoint();
        monitorPoint.setMonitorPointId(0L);
        monitorPoint.setBaciPropertyId(l);
        monitorPoint.setMonitorPointName(defaultMonitorPoint.getMonitorPointName());
        monitorPoint.setAssemblyId(l2);
        monitorPoint.setIndex(defaultMonitorPoint.getIndex());
        monitorPoint.setDatatype(defaultMonitorPoint.getDatatype());
        monitorPoint.setRCA(defaultMonitorPoint.getRCA());
        monitorPoint.setTERelated(defaultMonitorPoint.getTERelated());
        monitorPoint.setRawDatatype(defaultMonitorPoint.getRawDatatype());
        monitorPoint.setWorldDatatype(defaultMonitorPoint.getWorldDatatype());
        monitorPoint.setUnits(defaultMonitorPoint.getUnits());
        monitorPoint.setScale(defaultMonitorPoint.getScale());
        monitorPoint.setOffset(defaultMonitorPoint.getOffset());
        monitorPoint.setMinRange(defaultMonitorPoint.getMinRange());
        monitorPoint.setMaxRange(defaultMonitorPoint.getMinRange());
        monitorPoint.setDescription(defaultMonitorPoint.getDescription());
        entityManager.persist((Object)monitorPoint);
        this.log.fine("Monitor Point " + defaultMonitorPoint.getMonitorPointName() + " has been configured.");
    }

    private void persistNewMonitorData(EntityManager entityManager, ComponentData componentData, MonitorCharacteristicIDs monitorCharacteristicIDs) {
        MonitorData monitorData = new MonitorData();
        monitorData.setMonitorPointId(monitorCharacteristicIDs.getMonitorPointId());
        monitorData.setStartTime(componentData.startTime);
        monitorData.setEndTime(componentData.stopTime);
        monitorData.setMonitorTs(new Timestamp(System.currentTimeMillis()));
        monitorData.setSampleSize(componentData.sampleSize);
        monitorData.setMonitorClob(componentData.clob);
        if (componentData.statistics != null) {
            monitorData.setMinStat(componentData.statistics.min.doubleValue());
            monitorData.setMaxStat(componentData.statistics.max.doubleValue());
            monitorData.setMeanStat(componentData.statistics.mean.doubleValue());
            monitorData.setStdDevStat(componentData.statistics.stdDev.doubleValue());
        }
        this.entityManagerStore.persist((Object)monitorData);
    }

    @Override
    public List getMonitorData(long l, Timestamp timestamp, Timestamp timestamp2) {
        EntityManager entityManager = this.myPersistenceLayer.getEntityManager();
        Query query = entityManager.createNamedQuery("findMonitorDataByMonitorPointIdAndTimestampRange");
        query.setParameter("monitorPointId", (Object)l);
        query.setParameter("startTimestamp", (Object)timestamp);
        query.setParameter("stopTimestamp", (Object)timestamp2);
        return query.getResultList();
    }
}

