/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.util.Date;
import org.eso.fits.FitsException;
import org.eso.fits.FitsKeyword;

public class TestKeyword {
    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"ABOOLEAN=  F / Comment", "REALKW  =  1201.21e-2 / Just something", "INTEGER =  3321234   / An integer", "INTEGER1=  12", "STRING1 = 'Any thing' / Simple string", "STRING2 = 'It''s nice' / One with a quote", "STRING3 = 'I''ll know if it''s nice' / One with several quotes", "STRING4 = 'O' / Short string", "DATE-OBS= '01/11/89' / A date", "DATE    = '2002-11-04' / Another date", "DATE1   = '1782-09-21T11:32:47' / Yet another date", "DATE123 = '01/11/89' / An old format date", "ACOMMENT CARD with some words", "HIERARCH ESO DET CHIP ON  = T / HIERARCH boolean", "HIERARCH ESO DET CHIP ID  = 'CCD-223''en' / HIERARCH string", "HIERARCH ANY INT NO  = 732 / Test HIERARCH integer", "HIERARCH ANY TEMP12  = 123.90", "HIERARCH ANY time DATE  = '2001-05-22' / Check HIERARCH date", "\u0000\nTRY THIS KEYWORD", "AND_JUST_A_LONG_COMMENT", "END       and some terxt", "        = 'this is actually a comment'", "HIERARCH ESO DET CHIP ID but no equal sign"};
        System.out.println("-- Test reading keyword cards --");
        for (int i = 0; i < stringArray2.length; ++i) {
            TestKeyword.testString(stringArray2[i].getBytes());
        }
        System.out.println("-- Test construntors -----------");
        FitsKeyword fitsKeyword = new FitsKeyword("Aname", "test a string", "This is a string");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("AndALONGNAME", 98, "This is an integer");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("Aname", 123.231, "This is a double");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("Aname", 1.2334634734823109E26, "This is a double");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("ANd.AN.Hierarch.keyword", "test a string", "This is a string");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("DATE-OBS", new Date(), "This is a date");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("eso.ins.date", new Date(), "This is a date with a long comment");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("TEST", true, "This is a boolean");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("TEST.and.one.more", false, "This is a boolean");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("Aname", "This is a comment card");
        System.out.println(fitsKeyword);
        fitsKeyword = new FitsKeyword("Comment", "This is a comment card with a very long comment line which does not fit on a single card");
        System.out.println(fitsKeyword);
        System.out.println("-- Test special cases ----------");
        fitsKeyword = new FitsKeyword("Ctest", 12, "Test integer conversion");
        System.out.println(fitsKeyword);
        System.out.println("Read int as B,R : " + fitsKeyword.getBool() + ", " + fitsKeyword.getReal());
        fitsKeyword = new FitsKeyword("Ctest", 12.32, "Test real conversion");
        System.out.println(fitsKeyword);
        System.out.println("Read real as B,I,D : " + fitsKeyword.getBool() + ", " + fitsKeyword.getInt() + ", " + fitsKeyword.getDate());
        fitsKeyword = new FitsKeyword("Cdate", "1949-02-12", "Test date conversion");
        System.out.println(fitsKeyword);
        System.out.println("Read string as D,I : " + fitsKeyword.getDate() + ", " + fitsKeyword.getInt());
        fitsKeyword = new FitsKeyword("Cdate", "01/01/89", "Test date conversion");
        System.out.println(fitsKeyword);
        System.out.println("Read string as D,I : " + fitsKeyword.getDate() + ", " + fitsKeyword.getInt() + ", " + fitsKeyword.getReal());
        fitsKeyword = new FitsKeyword("Cdate", "1922.11.01", "Test date conversion");
        System.out.println(fitsKeyword);
        System.out.println("Read string as D,I : " + fitsKeyword.getDate() + ", " + fitsKeyword.getInt());
        fitsKeyword = new FitsKeyword("LSTRING", "This is a string which will be truncated when written out to the FITS 80 character card", "");
        System.out.println(fitsKeyword);
        System.out.println("Was truncated : " + fitsKeyword.isValueTruncated());
        try {
            fitsKeyword = new FitsKeyword("A_STRING= 'a word' / simple string keyword");
        }
        catch (FitsException fitsException) {
            System.out.println("Exception: " + fitsException);
        }
        System.out.println(fitsKeyword);
        System.out.println("Was modified : " + fitsKeyword.isModified());
        fitsKeyword.setValue("Any string");
        System.out.println(fitsKeyword);
        System.out.println("Was modified : " + fitsKeyword.isModified());
        System.out.println("Is empty card : " + fitsKeyword.isEmpty());
        try {
            fitsKeyword = new FitsKeyword(" ");
        }
        catch (FitsException fitsException) {
            System.out.println("Exception: " + fitsException);
        }
        System.out.println(fitsKeyword);
        System.out.println("Is empty card : " + fitsKeyword.isEmpty());
        System.out.println("Read string as D,I,R : " + fitsKeyword.getDate() + ", " + fitsKeyword.getInt() + ", " + fitsKeyword.getReal());
        System.out.println("-- Test finished ---------------");
    }

    private static void testString(byte[] byArray) {
        System.out.println("--------------------------------");
        FitsKeyword fitsKeyword = null;
        FitsKeyword fitsKeyword2 = null;
        try {
            fitsKeyword = new FitsKeyword(byArray);
            System.out.println(fitsKeyword);
            String string = fitsKeyword.toString();
            fitsKeyword = new FitsKeyword(string);
            System.out.println(fitsKeyword);
        }
        catch (FitsException fitsException) {
            System.out.println("FitsException>" + fitsException);
            return;
        }
        int n = fitsKeyword.getType();
        switch (n) {
            case 1: {
                System.out.println("->" + fitsKeyword.getName() + "<C> " + fitsKeyword.getComment());
                fitsKeyword2 = new FitsKeyword(fitsKeyword.getName(), "");
                System.out.println(fitsKeyword2);
                fitsKeyword2.setName(fitsKeyword.getName());
                fitsKeyword2.setComment(fitsKeyword.getComment());
                break;
            }
            case 2: {
                System.out.println("->" + fitsKeyword.getName() + "<S> " + fitsKeyword.getString() + " <> " + fitsKeyword.getString());
                fitsKeyword2 = new FitsKeyword(fitsKeyword.getName(), "", fitsKeyword.getComment());
                System.out.println(fitsKeyword2);
                fitsKeyword2.setName(fitsKeyword.getName());
                fitsKeyword2.setValue(fitsKeyword.getString());
                break;
            }
            case 3: {
                System.out.println("->" + fitsKeyword.getName() + "<B> " + fitsKeyword.getBool() + " <> " + fitsKeyword.getString());
                fitsKeyword2 = new FitsKeyword(fitsKeyword.getName(), false, fitsKeyword.getComment());
                System.out.println(fitsKeyword2);
                fitsKeyword2.setName(fitsKeyword.getName());
                fitsKeyword2.setValue(fitsKeyword.getBool());
                break;
            }
            case 4: {
                System.out.println("->" + fitsKeyword.getName() + "<I> " + fitsKeyword.getInt() + " <> " + fitsKeyword.getString());
                fitsKeyword2 = new FitsKeyword(fitsKeyword.getName(), -123.0, fitsKeyword.getComment());
                System.out.println(fitsKeyword2);
                fitsKeyword2.setName(fitsKeyword.getName());
                fitsKeyword2.setValue(fitsKeyword.getInt());
                break;
            }
            case 5: {
                System.out.println("->" + fitsKeyword.getName() + "<R> " + fitsKeyword.getReal() + " <> " + fitsKeyword.getString());
                fitsKeyword2 = new FitsKeyword(fitsKeyword.getName(), -0.0021332, fitsKeyword.getComment());
                System.out.println(fitsKeyword2);
                fitsKeyword2.setName(fitsKeyword.getName());
                fitsKeyword2.setValue(fitsKeyword.getReal());
                break;
            }
            case 6: {
                System.out.println("->" + fitsKeyword.getName() + "<D> " + fitsKeyword.getDate() + " <> " + fitsKeyword.getString());
                fitsKeyword2 = new FitsKeyword("testkey", new Date(0L), fitsKeyword.getComment());
                System.out.println(fitsKeyword2);
                fitsKeyword2.setName(fitsKeyword.getName());
                fitsKeyword2.setValue(fitsKeyword.getDate());
                break;
            }
        }
        System.out.println("->" + fitsKeyword2.getName() + " ->> " + fitsKeyword2.getString());
        System.out.println(fitsKeyword2);
    }
}

