/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.IOException;
import java.util.Enumeration;
import org.eso.fits.Fits;
import org.eso.fits.FitsColumn;
import org.eso.fits.FitsData;
import org.eso.fits.FitsException;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsMatrix;
import org.eso.fits.FitsTable;

public class TestFits {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Error: must have at least one argument");
            System.exit(1);
        }
        System.out.println("-- Test FITS files --------");
        FitsFile fitsFile = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                fitsFile = new FitsFile(stringArray[i]);
            }
            catch (FitsException fitsException) {
                System.out.println("Error: is not a FITS file >" + stringArray[i] + "<");
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Error: cannot open file >" + stringArray[i] + "<");
                continue;
            }
            int n = fitsFile.getNoHDUnits();
            System.out.println("FITS file has " + n + " HDUnits");
            for (int j = 0; j < n; ++j) {
                int n2;
                Object[] objectArray;
                Object object;
                FitsHDUnit fitsHDUnit = fitsFile.getHDUnit(j);
                FitsHeader fitsHeader = fitsHDUnit.getHeader();
                int n3 = fitsHeader.getNoKeywords();
                int n4 = fitsHeader.getType();
                int n5 = (int)fitsHeader.getDataSize();
                System.out.println("  " + j + ": >" + fitsHeader.getName() + "< of type >" + Fits.getType(n4) + "< with " + n3 + " keywords" + " and " + n5 + " bytes of data");
                System.out.println("   Keywords:");
                Enumeration enumeration = fitsHeader.getKeywords();
                while (enumeration.hasMoreElements()) {
                    object = (FitsKeyword)enumeration.nextElement();
                    System.out.print("     " + ((FitsKeyword)object).getName());
                    switch (((FitsKeyword)object).getType()) {
                        case 1: {
                            System.out.print("(C) " + ((FitsKeyword)object).getComment());
                            break;
                        }
                        case 2: {
                            System.out.print("(S)= '" + ((FitsKeyword)object).getString() + "'");
                            break;
                        }
                        case 3: {
                            System.out.print("(B)= " + ((FitsKeyword)object).getBool());
                            break;
                        }
                        case 4: {
                            System.out.print("(I)= " + ((FitsKeyword)object).getInt());
                            break;
                        }
                        case 5: {
                            System.out.print("(R)= " + ((FitsKeyword)object).getReal());
                            break;
                        }
                        case 6: {
                            System.out.print("(D)= " + ((FitsKeyword)object).getString());
                            break;
                        }
                    }
                    if (0 < ((FitsKeyword)object).getComment().length() && ((FitsKeyword)object).getType() != 1) {
                        System.out.print(" / " + ((FitsKeyword)object).getComment());
                    }
                    System.out.println();
                }
                if (n4 == 1) {
                    System.out.println("\n  Check data matrix - compute mean and rms");
                    object = (FitsMatrix)fitsHDUnit.getData();
                    int[] nArray = ((FitsData)object).getNaxis();
                    double[] dArray = ((FitsMatrix)object).getCrval();
                    objectArray = ((FitsMatrix)object).getCrpix();
                    double[] dArray2 = ((FitsMatrix)object).getCdelt();
                    System.out.println("  Dimension of matrix: " + nArray.length);
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        System.out.println("   Axis " + n2 + ": " + nArray[n2] + ",  " + objectArray[n2] + ",  " + dArray[n2] + ",  " + dArray2[n2]);
                    }
                    System.out.println("\n");
                    int n6 = ((FitsMatrix)object).getNoValues();
                    if (0 >= n6) continue;
                    int n7 = nArray[0];
                    int n8 = n6 / n7;
                    System.out.println(" Npixel,row,col: " + n6 + ", " + n8 + ", " + n7);
                    float[] fArray = new float[n7];
                    int n9 = 0;
                    n2 = 0;
                    int n10 = 0;
                    double d = 0.0;
                    double d2 = 0.0;
                    long l = System.currentTimeMillis();
                    for (int k = 0; k < n8; ++k) {
                        try {
                            ((FitsMatrix)object).getFloatValues(n10, n7, fArray);
                            for (int i2 = 0; i2 < n7; ++i2) {
                                double d3 = fArray[i2];
                                ++n9;
                                d2 += d3;
                                d += d3 * d3;
                            }
                        }
                        catch (FitsException fitsException) {
                            // empty catch block
                        }
                        n10 += n7;
                    }
                    d = 0.0 < (d = d / (double)n9 - (d2 /= (double)n9) * d2) ? Math.sqrt(d) : 0.0;
                    float f = (float)(1000.0 * (double)(System.currentTimeMillis() - l) / (double)n6);
                    System.out.println("  Mean: " + (float)d2 + ", rms: " + (float)d + ", Time: " + f + " S/Mp, Pixels: " + n9);
                    continue;
                }
                if (n4 != 2 && n4 != 3) continue;
                System.out.println("\n  Check table data - list columns");
                object = (FitsTable)fitsHDUnit.getData();
                int n11 = ((FitsTable)object).getNoRows();
                int n12 = ((FitsTable)object).getNoColumns();
                objectArray = new FitsColumn[n12];
                System.out.println("  Columns: " + n12 + ", Rows: " + n11);
                for (int k = 0; k < n12; ++k) {
                    double d;
                    long l;
                    double d4;
                    double d5;
                    objectArray[k] = (double)((FitsTable)object).getColumn(k);
                    System.out.print("  " + k + " >" + objectArray[k].getLabel() + "<, ");
                    System.out.print(objectArray[k].getRepeat() + " ");
                    System.out.print(objectArray[k].getDataType() + ", >");
                    System.out.print(objectArray[k].getDisplay() + "<, >");
                    System.out.println(objectArray[k].getUnit() + "<");
                    if (objectArray[k].getDataType() == 'F' || objectArray[k].getDataType() == 'E' || objectArray[k].getDataType() == 'D') {
                        n2 = 0;
                        d5 = 0.0;
                        d4 = 0.0;
                        l = System.currentTimeMillis();
                        for (int i3 = 0; i3 < n11; ++i3) {
                            d = objectArray[k].getReal(i3);
                            if (Double.isNaN(d)) continue;
                            ++n2;
                            d4 += d;
                            d5 += d * d;
                        }
                        float f = (float)(1000.0 * (double)(System.currentTimeMillis() - l) / (double)n11);
                        d5 = 0.0 < (d5 = d5 / (double)n2 - (d4 /= (double)n2) * d4) ? Math.sqrt(d5) : 0.0;
                        System.out.println("      no,mean,rms: " + n2 + ", " + (float)d4 + ", " + (float)d5 + "; " + f + " S/Mp");
                        continue;
                    }
                    if (objectArray[k].getDataType() != 'I' && objectArray[k].getDataType() != 'J' && objectArray[k].getDataType() != 'B') continue;
                    n2 = 0;
                    d5 = 0.0;
                    d4 = 0.0;
                    l = System.currentTimeMillis();
                    for (int i4 = 0; i4 < n11; ++i4) {
                        d = objectArray[k].getInt(i4);
                        if (d == -9.223372036854776E18) continue;
                        ++n2;
                        d4 += d;
                        d5 += d * d;
                    }
                    float f = (float)(1000.0 * (double)(System.currentTimeMillis() - l) / (double)n11);
                    d5 = 0.0 < (d5 = d5 / (double)n2 - (d4 /= (double)n2) * d4) ? Math.sqrt(d5) : 0.0;
                    System.out.println("      no,mean,rms: " + n2 + ", " + (float)d4 + ", " + (float)d5 + "; " + f + " S/Mp");
                }
            }
            System.out.println("-- Test finished -----------------");
        }
        System.exit(0);
    }
}

