/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;

public class FitsWCS {
    public static final int LIN = 0;
    public static final int TAN = 1;
    public static final int ARC = 2;
    private static final int MPS = 20;
    protected int type = 0;
    protected int nax = 0;
    protected int[] cproj;
    protected double[] crpix;
    protected double[] crval;
    protected double[] cdelt;
    protected double[] crota;
    protected String[] ctype;
    protected double[][] cdMatrix;
    protected double[][] pcMatrix;
    protected boolean hasPcMatrix = false;
    protected boolean hasCdMatrix = false;
    protected double[] amdx = new double[20];
    protected double[] amdy = new double[20];

    public FitsWCS() {
    }

    public FitsWCS(FitsHeader fitsHeader) {
        this();
        this.setHeader(fitsHeader, ' ');
    }

    public FitsWCS(FitsHeader fitsHeader, char c) {
        this();
        this.setHeader(fitsHeader, c);
    }

    public FitsWCS(int n) {
        this();
        this.init(n);
    }

    public void setHeader(FitsHeader fitsHeader, char c) {
        int n;
        this.type = fitsHeader.getType();
        FitsKeyword fitsKeyword = fitsHeader.getKeyword("NAXIS");
        this.nax = fitsKeyword == null ? 0 : fitsKeyword.getInt();
        this.init(this.nax);
        String string = String.valueOf(c).toUpperCase().trim();
        for (n = 1; n <= this.nax; ++n) {
            int n2;
            String string2;
            fitsKeyword = fitsHeader.getKeyword("CRPIX" + n + string);
            this.crpix[n - 1] = fitsKeyword == null ? 0.0 : fitsKeyword.getReal();
            fitsKeyword = fitsHeader.getKeyword("CRVAL" + n + string);
            this.crval[n - 1] = fitsKeyword == null ? 0.0 : fitsKeyword.getReal();
            fitsKeyword = fitsHeader.getKeyword("CDELT" + n + string);
            this.cdelt[n - 1] = fitsKeyword == null ? 1.0 : fitsKeyword.getReal();
            this.cdMatrix[n - 1][n - 1] = this.cdelt[n - 1];
            fitsKeyword = fitsHeader.getKeyword("CTYPE" + n + string);
            String string3 = this.ctype[n - 1] = fitsKeyword == null ? "        " : fitsKeyword.getString();
            this.cproj[n - 1] = 7 < this.ctype[n - 1].length() ? ((string2 = this.ctype[n - 1].substring(5, 7)).equals("TAN") ? 1 : (string2.equals("ARC") ? 2 : 0)) : 0;
            for (n2 = 1; n2 <= this.nax; ++n2) {
                fitsKeyword = fitsHeader.getKeyword("CD" + n + "_" + n + string);
                if (fitsKeyword == null) continue;
                this.cdMatrix[n - 1][n2 - 1] = fitsKeyword.getReal();
                this.hasCdMatrix = true;
            }
            for (n2 = 1; n2 <= this.nax; ++n2) {
                fitsKeyword = fitsHeader.getKeyword("PC" + n + "_" + n2 + string);
                if (fitsKeyword == null) continue;
                this.pcMatrix[n - 1][n2 - 1] = fitsKeyword.getReal();
                this.hasPcMatrix = true;
            }
        }
        for (n = 1; n < 20; ++n) {
            fitsKeyword = fitsHeader.getKeyword("AMDX" + n);
            this.amdx[n - 1] = fitsKeyword == null ? 0.0 : fitsKeyword.getReal();
            fitsKeyword = fitsHeader.getKeyword("AMDY" + n);
            this.amdy[n - 1] = fitsKeyword == null ? 0.0 : fitsKeyword.getReal();
        }
    }

    private void init(int n) {
        this.cproj = new int[n];
        this.crpix = new double[n];
        this.crval = new double[n];
        this.cdelt = new double[n];
        this.ctype = new String[n];
        this.cdMatrix = new double[n][n];
        this.pcMatrix = new double[n][n];
        this.ctype = new String[n];
        for (int i = 0; i < n; ++i) {
            this.cproj[i] = 0;
            this.crpix[i] = 0.0;
            this.crval[i] = 0.0;
            this.cdelt[i] = 1.0;
            this.ctype[i] = "        ";
            for (int j = 0; j < n; ++j) {
                this.cdMatrix[i][j] = j == i ? 1.0 : 0.0;
                this.pcMatrix[i][j] = j == i ? 1.0 : 0.0;
            }
        }
    }

    public double[] toWCS(double[] dArray) {
        double[] dArray2;
        int n;
        for (n = 0; n < this.nax; ++n) {
            int n2 = n;
            dArray[n2] = dArray[n2] - this.crpix[n];
        }
        if (this.hasPcMatrix) {
            dArray2 = this.matrixMult(this.pcMatrix, dArray);
            for (n = 0; n < this.nax; ++n) {
                int n3 = n;
                dArray2[n3] = dArray2[n3] * this.cdelt[n];
            }
        } else if (this.hasCdMatrix) {
            dArray2 = this.matrixMult(this.cdMatrix, dArray);
        } else {
            dArray2 = dArray;
            for (n = 0; n < this.nax; ++n) {
                int n4 = n;
                dArray2[n4] = dArray2[n4] * this.cdelt[n];
            }
        }
        switch (this.cproj[0]) {
            case 0: 
            case 1: {
                for (n = 0; n < this.nax; ++n) {
                    int n5 = n;
                    dArray2[n5] = dArray2[n5] + this.crval[n];
                }
                break;
            }
        }
        return dArray2;
    }

    public double[] toPixel(double[] dArray) {
        double[] dArray2 = new double[this.nax];
        double[] dArray3 = new double[this.nax];
        for (int i = 0; i < this.nax; ++i) {
            dArray2[i] = (dArray[i] - this.crval[i]) / this.cdelt[i] + this.crpix[i];
        }
        return dArray2;
    }

    private double[] matrixMult(double[][] dArray, double[] dArray2) {
        int n = dArray2.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                dArray3[n2] = dArray3[n2] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }
}

