/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.DataInput;
import java.util.Enumeration;
import java.util.Vector;
import org.eso.fits.FitsColumn;
import org.eso.fits.FitsData;
import org.eso.fits.FitsException;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;

public class FitsTable
extends FitsData {
    private Vector columns;
    private int noRows;

    public FitsTable(FitsHeader fitsHeader, DataInput dataInput, boolean bl) throws FitsException {
        super(fitsHeader, dataInput, bl);
        if (this.bitpix != 8 || this.noParm < 0 || this.noGroup != 1) {
            throw new FitsException("Incompatible TABLE header", 4);
        }
        FitsKeyword fitsKeyword = fitsHeader.getKeyword("TFIELDS");
        if (fitsKeyword == null) {
            throw new FitsException("Missing TFIELDS keyword", 4);
        }
        int n = fitsKeyword.getInt();
        this.columns = new Vector(n);
        int n2 = this.naxis[0];
        this.noRows = this.naxis[1];
        fitsKeyword = fitsHeader.getKeyword("THEAP");
        long l = fitsKeyword == null ? 0L : (long)fitsKeyword.getInt();
        int n3 = 0;
        for (int i = 1; i <= n; ++i) {
            fitsKeyword = fitsHeader.getKeyword("TFORM" + i);
            if (fitsKeyword == null) {
                throw new FitsException("Missing TFORMn keyword", 4);
            }
            String string = fitsKeyword.getString();
            if (this.type == 3) {
                fitsKeyword = fitsHeader.getKeyword("TBCOL" + i);
                if (fitsKeyword == null) {
                    throw new FitsException("Missing TBCOLn keyword", 4);
                }
                n3 = fitsKeyword.getInt();
            }
            String string2 = (fitsKeyword = fitsHeader.getKeyword("TTYPE" + i)) == null ? "Label" + i : fitsKeyword.getString();
            FitsColumn fitsColumn = new FitsColumn(this.type, string, string2, this.noRows);
            if (this.isRAFile) {
                fitsColumn.setData(this.dataFile, this.dataOffset, n3, n2);
            } else if (this.dataArray != null) {
                fitsColumn.setData(this.dataArray, n3, n2);
            }
            if (this.type == 2) {
                n3 += fitsColumn.getWidth();
            }
            if ((fitsKeyword = fitsHeader.getKeyword("TZERO" + i)) != null) {
                fitsColumn.setZero(fitsKeyword.getReal());
            }
            if ((fitsKeyword = fitsHeader.getKeyword("TSCALE" + i)) != null) {
                fitsColumn.setScale(fitsKeyword.getReal());
            }
            if ((fitsKeyword = fitsHeader.getKeyword("TNULL" + i)) != null) {
                if (this.type == 2) {
                    fitsColumn.setNull(fitsKeyword.getInt());
                } else {
                    fitsColumn.setNull(fitsKeyword.getString());
                }
            }
            if ((fitsKeyword = fitsHeader.getKeyword("TUNIT" + i)) != null) {
                fitsColumn.setUnit(fitsKeyword.getString());
            }
            if ((fitsKeyword = fitsHeader.getKeyword("TDISP" + i)) != null) {
                fitsColumn.setDisplay(fitsKeyword.getString());
            }
            if ((fitsKeyword = fitsHeader.getKeyword("TDIM" + i)) != null) {
                fitsColumn.setDim(fitsKeyword.getString());
            }
            this.columns.addElement(fitsColumn);
        }
    }

    @Override
    public FitsHeader getHeader() {
        FitsHeader fitsHeader = new FitsHeader();
        fitsHeader.addKeyword(new FitsKeyword("XTENSION", "BINTABLE", "Bibary table extension"));
        fitsHeader.addKeyword(new FitsKeyword("BITPIX", 8, "No. of bits per pixel"));
        fitsHeader.addKeyword(new FitsKeyword("NAXIS", 2, "No. of axes in image"));
        int n = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
        }
        fitsHeader.addKeyword(new FitsKeyword("NAXIS1", n, "No. of bytes in row"));
        fitsHeader.addKeyword(new FitsKeyword("NAXIS2", this.getNoRows(), "No. of rows in table"));
        fitsHeader.addKeyword(new FitsKeyword("PCOUNT", this.noParm, "Size of heap area"));
        fitsHeader.addKeyword(new FitsKeyword("GCOUNT", this.noGroup, "Group count"));
        fitsHeader.addKeyword(new FitsKeyword("TFIELDS", this.getNoColumns(), "No. of columns in table"));
        return fitsHeader;
    }

    public void addColumn(FitsColumn fitsColumn) {
        this.columns.addElement(fitsColumn);
    }

    public void insertColumnAt(FitsColumn fitsColumn, int n) {
        this.columns.insertElementAt(fitsColumn, n);
    }

    public void removeColumnAt(int n) {
        this.columns.removeElementAt(n);
    }

    public FitsColumn getColumn(int n) {
        if (n < 0 || this.columns.size() <= n) {
            return null;
        }
        Enumeration enumeration = this.columns.elements();
        while (0 < n--) {
            enumeration.nextElement();
        }
        return (FitsColumn)enumeration.nextElement();
    }

    public FitsColumn getColumn(String string) {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            FitsColumn fitsColumn = (FitsColumn)enumeration.nextElement();
            if (!string.equalsIgnoreCase(fitsColumn.getLabel())) continue;
            return fitsColumn;
        }
        return null;
    }

    public int getNoColumns() {
        return this.columns.size();
    }

    public int getNoRows() {
        return this.noRows;
    }
}

