/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.types;

import cl.utfsm.acs.types.AcsComplexType;
import cl.utfsm.acs.types.SimpleObject;
import cl.utfsm.acs.types.TypedObject;
import java.util.ArrayList;
import java.util.TreeMap;

public class ComplexObject
extends TypedObject {
    protected AcsComplexType cType;
    protected TreeMap<String, SimpleObject> attributes;

    public ComplexObject(AcsComplexType acsComplexType) {
        if (acsComplexType == null) {
            throw new NullPointerException();
        }
        this.cType = acsComplexType;
        this.type = acsComplexType;
        this.attributes = new TreeMap();
        ArrayList<String> arrayList = acsComplexType.getAttrNames();
        for (String string : arrayList) {
            SimpleObject simpleObject = new SimpleObject(acsComplexType.getAttrType(string));
            simpleObject.setValue("");
            this.attributes.put(string, simpleObject);
        }
    }

    public void setAttributeValue(String string, String string2) {
        for (String string3 : this.attributes.keySet()) {
            if (string3.compareTo(string) != 0) continue;
            SimpleObject simpleObject = this.attributes.get(string);
            simpleObject.setValue(string2);
            return;
        }
        throw new IllegalArgumentException("The attribute \"" + string + "\" is not supported by \"" + this.type.name + "\" type definition.");
    }

    public String getAttributeValue(String string) {
        SimpleObject simpleObject = this.attributes.get(string);
        if (simpleObject == null) {
            return null;
        }
        return simpleObject.getValue();
    }

    public SimpleObject getAttribute(String string) {
        return this.attributes.get(string);
    }

    public TreeMap<String, SimpleObject> getAttributes() {
        return this.attributes;
    }
}

