/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.ebe;

import cl.utfsm.acs.ebe.Completion;
import cl.utfsm.acs.ebe.EbeDocument;
import cl.utfsm.acs.ebe.EbeDocumentManager;
import cl.utfsm.acs.ebe.Error;
import cl.utfsm.acs.ebe.ErrorTreeCellRenderer;
import cl.utfsm.acs.ebe.Member;
import cl.utfsm.acs.ebe.util.EbeOpenFileFilter;
import cl.utfsm.acs.ebe.util.EbeTableModel;
import cl.utfsm.acs.ebe.util.MembersTableModel;
import cl.utfsm.acs.types.ComplexObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ErrorBrowserEditor
extends JFrame {
    private JPanel jContentPane = null;
    private JSplitPane jSplitPane = null;
    private JPanel mainPanel = null;
    private JScrollPane jScrollPane = null;
    private static JTextPane textMessagePane = null;
    private JSplitPane jSplitPane1 = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel tableViewPanel = null;
    private JPanel xmlViewPanel = null;
    private JPanel nodesPanel = null;
    private JPanel jPanel = null;
    private JScrollPane jScrollPane2 = null;
    private JTable docTable = null;
    private JScrollPane jScrollPane3 = null;
    private JTable nodeAttributesTable = null;
    private JScrollPane jScrollPane4 = null;
    private JTree nodesTree = null;
    private JScrollPane jScrollPane5 = null;
    private JTable membersTable = null;
    private JPanel jPanel1 = null;
    private JScrollPane jScrollPane1 = null;
    private JTree docsTree = null;
    private JScrollPane jScrollPane6 = null;
    private JEditorPane xmlEditorPane = null;
    private JMenuBar EBEMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem exitItem = null;
    private JPanel jPanel2 = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JPopupMenu addPopupMenu = null;
    private JMenuItem addFileItem = null;
    private JMenuItem addDirectoryItem = null;
    private JMenuItem addDefaultsItem = null;
    private DefaultMutableTreeNode docNodeSelected = null;
    private EbeDocument docSelected = null;
    private DefaultMutableTreeNode complexNodeSelected = null;
    private ComplexObject complexSelected = null;
    private static EbeDocumentManager manager = null;
    private JPanel nodesEditPanel = null;
    private JButton newNodeButton = null;
    private JButton removeNodeButton = null;
    private JSplitPane jSplitPane2 = null;
    private JToolBar jToolBar = null;
    private JButton editButton = null;
    private JButton saveButton = null;
    private JButton cancelEditButton = null;
    private JLabel jLabel = null;
    private JLabel locationField = null;
    private JButton deleteDocButton = null;
    private JButton newDocButton = null;
    private JPanel jPanel4 = null;
    private JPanel membersEditPanel = null;
    private JButton addMemmberButton = null;
    private JButton removeMemberButton = null;
    private JPopupMenu newNodePopupMenu = null;
    private JMenuItem newErrorMenuItem = null;
    private JMenuItem newCompletionMenuItem = null;
    private JPopupMenu removePopupMenu = null;
    private JMenuItem removeSelectedItem = null;
    private JMenuItem cleanAllFilesItem = null;
    public static boolean logInfo = true;

    public ErrorBrowserEditor() {
        this.initialize();
        manager = new EbeDocumentManager();
        ArrayList<String> arrayList = Member.getClassType().getAttrNames();
        Object[] objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0);
        this.membersTable.setModel(defaultTableModel);
    }

    private void initialize() {
        this.setSize(800, 630);
        this.setJMenuBar(this.getEBEMenuBar());
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Error browser and editor");
        this.setJMenuBar(this.getEBEMenuBar());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), "Center");
            this.jContentPane.add((Component)this.getJToolBar(), "North");
        }
        return this.jContentPane;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setTopComponent(this.getMainPanel());
            this.jSplitPane.setBottomComponent(this.getJScrollPane());
            this.jSplitPane.setDividerLocation(470);
        }
        return this.jSplitPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getJSplitPane1(), "Center");
        }
        return this.mainPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(ErrorBrowserEditor.getTextMessagePane());
        }
        return this.jScrollPane;
    }

    private static JTextPane getTextMessagePane() {
        if (textMessagePane == null) {
            textMessagePane = new JTextPane();
            textMessagePane.setEditable(false);
        }
        return textMessagePane;
    }

    private JSplitPane getJSplitPane1() {
        if (this.jSplitPane1 == null) {
            this.jSplitPane1 = new JSplitPane();
            this.jSplitPane1.setDividerLocation(200);
            this.jSplitPane1.setLeftComponent(this.getJPanel1());
            this.jSplitPane1.setRightComponent(this.getJTabbedPane());
        }
        return this.jSplitPane1;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Table view", null, this.getTableViewPanel(), null);
            this.jTabbedPane.addTab("XML View", null, this.getXmlViewPanel(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getTableViewPanel() {
        if (this.tableViewPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.tableViewPanel = new JPanel();
            this.tableViewPanel.setLayout(gridLayout);
            this.tableViewPanel.add((Component)this.getNodesPanel(), null);
        }
        return this.tableViewPanel;
    }

    private JPanel getXmlViewPanel() {
        if (this.xmlViewPanel == null) {
            this.xmlViewPanel = new JPanel();
            this.xmlViewPanel.setLayout(new BorderLayout());
            this.xmlViewPanel.add((Component)this.getJScrollPane6(), "Center");
        }
        return this.xmlViewPanel;
    }

    private JPanel getNodesPanel() {
        if (this.nodesPanel == null) {
            this.nodesPanel = new JPanel();
            this.nodesPanel.setLayout(new BorderLayout());
            this.nodesPanel.add((Component)this.getJPanel(), "West");
            this.nodesPanel.add((Component)this.getJScrollPane2(), "North");
            this.nodesPanel.add((Component)this.getJSplitPane2(), "Center");
        }
        return this.nodesPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, "Errors/Completions", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jPanel.setPreferredSize(new Dimension(200, 300));
            this.jPanel.add((Component)this.getJScrollPane4(), "Center");
            this.jPanel.add((Component)this.getNodesEditPanel(), "South");
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setBorder(BorderFactory.createTitledBorder(null, "Error file attributes", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jScrollPane2.setPreferredSize(new Dimension(460, 175));
            this.jScrollPane2.setViewportView(this.getDocTable());
        }
        return this.jScrollPane2;
    }

    private JTable getDocTable() {
        if (this.docTable == null) {
            this.docTable = new JTable();
            this.docTable.setModel(new EbeTableModel());
            this.docTable.setEnabled(true);
        }
        return this.docTable;
    }

    private JScrollPane getJScrollPane3() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setBorder(BorderFactory.createTitledBorder(null, "Errors/Completions Attributes", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jScrollPane3.setPreferredSize(new Dimension(100, 100));
            this.jScrollPane3.setViewportView(this.getNodeAttributesTable());
        }
        return this.jScrollPane3;
    }

    private JTable getNodeAttributesTable() {
        if (this.nodeAttributesTable == null) {
            this.nodeAttributesTable = new JTable();
            this.nodeAttributesTable.setModel(new EbeTableModel());
            this.nodeAttributesTable.setEnabled(false);
        }
        return this.nodeAttributesTable;
    }

    private JScrollPane getJScrollPane4() {
        if (this.jScrollPane4 == null) {
            this.jScrollPane4 = new JScrollPane();
            this.jScrollPane4.setPreferredSize(new Dimension(125, 363));
            this.jScrollPane4.setViewportView(this.getNodesTree());
        }
        return this.jScrollPane4;
    }

    private JTree getNodesTree() {
        if (this.nodesTree == null) {
            this.nodesTree = new JTree(new DefaultMutableTreeNode("ROOT"));
            this.nodesTree.setRootVisible(false);
            this.nodesTree.setCellRenderer(new ErrorTreeCellRenderer());
            this.nodesTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    ErrorBrowserEditor.this.complexNodeSelected = (DefaultMutableTreeNode)ErrorBrowserEditor.this.nodesTree.getLastSelectedPathComponent();
                    if (ErrorBrowserEditor.this.complexNodeSelected != null) {
                        ErrorBrowserEditor.this.complexSelected = (ComplexObject)ErrorBrowserEditor.this.complexNodeSelected.getUserObject();
                    }
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                    ErrorBrowserEditor.this.refreshMembersTable();
                }
            });
        }
        ToolTipManager.sharedInstance().registerComponent(this.nodesTree);
        return this.nodesTree;
    }

    private JScrollPane getJScrollPane5() {
        if (this.jScrollPane5 == null) {
            this.jScrollPane5 = new JScrollPane();
            this.jScrollPane5.setBorder(BorderFactory.createTitledBorder(null, "Members", 0, 0, null, null));
            this.jScrollPane5.setPreferredSize(new Dimension(10, 100));
            this.jScrollPane5.setViewportView(this.getMembersTable());
        }
        return this.jScrollPane5;
    }

    private JTable getMembersTable() {
        if (this.membersTable == null) {
            this.membersTable = new JTable();
            this.membersTable.setEnabled(false);
        }
        return this.membersTable;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.add((Component)this.getJScrollPane1(), "Center");
            this.jPanel1.add((Component)this.getJPanel2(), "South");
        }
        return this.jPanel1;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, "Error definition files", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jScrollPane1.setViewportView(this.getDocsTree());
        }
        return this.jScrollPane1;
    }

    private JTree getDocsTree() {
        if (this.docsTree == null) {
            this.docsTree = new JTree(new DefaultMutableTreeNode("ROOT"));
            this.docsTree.setRootVisible(false);
            this.docsTree.setToggleClickCount(1);
            this.docsTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    ErrorBrowserEditor.this.docNodeSelected = (DefaultMutableTreeNode)ErrorBrowserEditor.this.docsTree.getLastSelectedPathComponent();
                    if (ErrorBrowserEditor.this.docNodeSelected != null) {
                        ErrorBrowserEditor.this.docSelected = (EbeDocument)ErrorBrowserEditor.this.docNodeSelected.getUserObject();
                        ErrorBrowserEditor.this.locationField.setText(ErrorBrowserEditor.this.docSelected.getPath());
                    } else {
                        ErrorBrowserEditor.this.locationField.setText("(none)");
                    }
                    ErrorBrowserEditor.this.complexNodeSelected = null;
                    ErrorBrowserEditor.this.complexSelected = null;
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshDocTable();
                    try {
                        ErrorBrowserEditor.this.loadXmlView();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        }
        ToolTipManager.sharedInstance().registerComponent(this.docsTree);
        return this.docsTree;
    }

    private JScrollPane getJScrollPane6() {
        if (this.jScrollPane6 == null) {
            this.jScrollPane6 = new JScrollPane();
            this.jScrollPane6.setViewportView(this.getXmlEditorPane());
        }
        return this.jScrollPane6;
    }

    private JEditorPane getXmlEditorPane() {
        if (this.xmlEditorPane == null) {
            this.xmlEditorPane = new JEditorPane();
            this.xmlEditorPane.setContentType("text/plain");
            this.xmlEditorPane.setEditable(false);
        }
        return this.xmlEditorPane;
    }

    private JMenuBar getEBEMenuBar() {
        if (this.EBEMenuBar == null) {
            this.EBEMenuBar = new JMenuBar();
            this.EBEMenuBar.add(this.getFileMenu());
        }
        return this.EBEMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getExitItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getExitItem() {
        if (this.exitItem == null) {
            this.exitItem = new JMenuItem();
            this.exitItem.setText("Exit");
            this.exitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
        }
        return this.exitItem;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridx = 1;
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getAddButton(), gridBagConstraints3);
            this.jPanel2.add((Component)this.getRemoveButton(), gridBagConstraints2);
        }
        return this.jPanel2;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Load");
            this.addButton.setFont(new Font("Dialog", 1, 10));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ErrorBrowserEditor.this.getAddButton().getX();
                    int n2 = ErrorBrowserEditor.this.getAddButton().getY();
                    ErrorBrowserEditor.this.getAddPopupMenu().show(ErrorBrowserEditor.this.getAddButton(), n, n2);
                }
            });
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            this.removeButton.setFont(new Font("Dialog", 1, 10));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ErrorBrowserEditor.this.getRemoveButton().getX();
                    int n2 = ErrorBrowserEditor.this.getRemoveButton().getY();
                    ErrorBrowserEditor.this.getRemovePopupMenu().show(ErrorBrowserEditor.this.getRemoveButton(), n - 40, n2);
                }
            });
        }
        return this.removeButton;
    }

    private JPopupMenu getAddPopupMenu() {
        if (this.addPopupMenu == null) {
            this.addPopupMenu = new JPopupMenu();
            this.addPopupMenu.add(this.getAddFileItem());
            this.addPopupMenu.add(this.getAddDirectoryItem());
            this.addPopupMenu.add(this.getAddDefaultsItem());
        }
        return this.addPopupMenu;
    }

    private JMenuItem getAddFileItem() {
        if (this.addFileItem == null) {
            this.addFileItem = new JMenuItem();
            this.addFileItem.setText("File");
            this.addFileItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileFilter(new EbeOpenFileFilter());
                    int n = jFileChooser.showOpenDialog(ErrorBrowserEditor.this);
                    if (n == 0) {
                        manager.loadDocument(jFileChooser.getSelectedFile().getAbsolutePath());
                        ErrorBrowserEditor.this.refreshDocsTree();
                    }
                }
            });
        }
        return this.addFileItem;
    }

    private JMenuItem getAddDirectoryItem() {
        if (this.addDirectoryItem == null) {
            this.addDirectoryItem = new JMenuItem();
            this.addDirectoryItem.setText("Directory");
            this.addDirectoryItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(1);
                    int n = jFileChooser.showOpenDialog(ErrorBrowserEditor.this);
                    if (n == 0) {
                        manager.addDirectory(jFileChooser.getSelectedFile().getAbsolutePath());
                        ErrorBrowserEditor.this.refreshDocsTree();
                    }
                }
            });
        }
        return this.addDirectoryItem;
    }

    private JMenuItem getAddDefaultsItem() {
        if (this.addDefaultsItem == null) {
            this.addDefaultsItem = new JMenuItem();
            this.addDefaultsItem.setText("Defaults");
            this.addDefaultsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    manager.addDefaults();
                    ErrorBrowserEditor.this.refreshDocsTree();
                }
            });
        }
        return this.addDefaultsItem;
    }

    public void refreshDocsTree() {
        TreeMap<String, EbeDocument> treeMap = manager.getDocuments();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.docsTree.getModel().getRoot();
        defaultMutableTreeNode.removeAllChildren();
        for (EbeDocument ebeDocument : treeMap.values()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(ebeDocument));
        }
        ((DefaultTreeModel)this.docsTree.getModel()).reload();
    }

    public EbeDocument getSelectedDoc() {
        return this.docSelected;
    }

    public Error getSelectedError() {
        return (Error)this.complexSelected;
    }

    private void refreshNodesTree() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.nodesTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultMutableTreeNode.removeAllChildren();
        if (this.docSelected == null) {
            defaultTreeModel.reload();
            return;
        }
        TreeMap<String, ComplexObject> treeMap = this.docSelected.getNodes();
        for (ComplexObject complexObject : treeMap.values()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(complexObject));
        }
        defaultTreeModel.reload();
    }

    public void publicRefreshNodeTree() {
        this.refreshNodesTree();
        this.complexSelected = null;
        this.complexNodeSelected = null;
        this.refreshNodeAttributesTable();
        this.refreshMembersTable();
    }

    private void refreshDocTable() {
        if (this.docSelected == null) {
            this.docTable.setModel(new EbeTableModel());
            return;
        }
        EbeTableModel ebeTableModel = new EbeTableModel(this.docSelected, this);
        this.docTable.setModel(ebeTableModel);
        this.docTable.validate();
    }

    private void refreshNodeAttributesTable() {
        if (this.complexSelected == null) {
            this.nodeAttributesTable.setModel(new EbeTableModel());
            return;
        }
        EbeTableModel ebeTableModel = new EbeTableModel(this.complexSelected, this);
        this.nodeAttributesTable.setModel(ebeTableModel);
        this.nodeAttributesTable.validate();
    }

    public void refreshMembersTable() {
        if (this.complexSelected == null || !(this.complexSelected instanceof Error)) {
            MembersTableModel membersTableModel = new MembersTableModel();
            this.membersTable.setModel(membersTableModel);
            return;
        }
        MembersTableModel membersTableModel = new MembersTableModel(this);
        this.membersTable.setModel(membersTableModel);
    }

    private JPanel getNodesEditPanel() {
        if (this.nodesEditPanel == null) {
            this.nodesEditPanel = new JPanel();
            this.nodesEditPanel.setVisible(false);
            this.nodesEditPanel.add((Component)this.getNewNodeButton(), null);
            this.nodesEditPanel.add((Component)this.getRemoveNodeButton(), null);
        }
        return this.nodesEditPanel;
    }

    private JButton getNewNodeButton() {
        if (this.newNodeButton == null) {
            this.newNodeButton = new JButton();
            this.newNodeButton.setText("New");
            this.newNodeButton.setFont(new Font("Dialog", 1, 10));
            this.newNodeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ErrorBrowserEditor.this.getMousePosition().x;
                    int n2 = ErrorBrowserEditor.this.getMousePosition().y;
                    ErrorBrowserEditor.this.getNewNodePopupMenu().show(ErrorBrowserEditor.this.getNewDocButton(), n, n2 - 50);
                }
            });
        }
        return this.newNodeButton;
    }

    private JButton getRemoveNodeButton() {
        if (this.removeNodeButton == null) {
            this.removeNodeButton = new JButton();
            this.removeNodeButton.setText("Remove");
            this.removeNodeButton.setFont(new Font("Dialog", 1, 10));
            this.removeNodeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ErrorBrowserEditor.this.complexSelected == null) {
                        return;
                    }
                    ErrorBrowserEditor.this.docSelected.getNodes().remove(ErrorBrowserEditor.this.complexSelected.toString());
                    ErrorBrowserEditor.log("\t[Node " + ErrorBrowserEditor.this.complexSelected.toString() + " removed]");
                    ErrorBrowserEditor.this.complexNodeSelected = null;
                    ErrorBrowserEditor.this.complexSelected = null;
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                    ErrorBrowserEditor.this.refreshMembersTable();
                }
            });
        }
        return this.removeNodeButton;
    }

    private JSplitPane getJSplitPane2() {
        if (this.jSplitPane2 == null) {
            this.jSplitPane2 = new JSplitPane();
            this.jSplitPane2.setOrientation(0);
            this.jSplitPane2.setDividerLocation(180);
            this.jSplitPane2.setOneTouchExpandable(false);
            this.jSplitPane2.setBottomComponent(this.getJPanel4());
            this.jSplitPane2.setTopComponent(this.getJScrollPane3());
        }
        return this.jSplitPane2;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.locationField = new JLabel();
            this.locationField.setText("(none)");
            this.locationField.setBackground(Color.WHITE);
            this.jLabel = new JLabel();
            this.jLabel.setText("Path:  ");
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getNewDocButton());
            this.jToolBar.add(this.getEditButton());
            this.jToolBar.add(this.getCancelEditButton());
            this.jToolBar.add(this.getSaveButton());
            this.jToolBar.addSeparator();
            this.jToolBar.addSeparator();
            this.jToolBar.addSeparator();
            this.jToolBar.add(this.jLabel);
            this.jToolBar.add(this.locationField);
            this.jToolBar.add(this.getDeleteDocButton());
        }
        return this.jToolBar;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorBrowserEditor.this.enterEditMode();
                }
            });
        }
        return this.editButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("Save");
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorBrowserEditor.this.exitEditMode();
                    try {
                        ErrorBrowserEditor.this.docSelected.save();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        JOptionPane.showMessageDialog(ErrorBrowserEditor.this, "You don't have permission to save the file", "Error", 0);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    ErrorBrowserEditor.log("[Document " + ErrorBrowserEditor.this.docSelected.getPath() + " saved ]");
                    ErrorBrowserEditor.this.docSelected.load();
                    ErrorBrowserEditor.this.refreshDocTable();
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                    ErrorBrowserEditor.this.refreshMembersTable();
                    try {
                        ErrorBrowserEditor.this.loadXmlView();
                    }
                    catch (IOException iOException) {
                        System.out.println("Error");
                    }
                }
            });
        }
        return this.saveButton;
    }

    private JButton getCancelEditButton() {
        if (this.cancelEditButton == null) {
            this.cancelEditButton = new JButton();
            this.cancelEditButton.setText("Cancel");
            this.cancelEditButton.setEnabled(false);
            this.cancelEditButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorBrowserEditor.this.exitEditMode();
                    try {
                        ErrorBrowserEditor.this.docSelected.load();
                    }
                    catch (NullPointerException nullPointerException) {
                        manager.removeDocument(ErrorBrowserEditor.this.docSelected.getValue());
                        ErrorBrowserEditor.this.docNodeSelected = null;
                        ErrorBrowserEditor.this.docSelected = null;
                        ErrorBrowserEditor.this.complexNodeSelected = null;
                        ErrorBrowserEditor.this.complexSelected = null;
                    }
                    ErrorBrowserEditor.this.refreshDocsTree();
                    ErrorBrowserEditor.this.refreshDocTable();
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                    ErrorBrowserEditor.this.refreshMembersTable();
                }
            });
        }
        return this.cancelEditButton;
    }

    private JButton getDeleteDocButton() {
        if (this.deleteDocButton == null) {
            this.deleteDocButton = new JButton();
            this.deleteDocButton.setText("Delete");
            this.deleteDocButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ErrorBrowserEditor.this.docSelected == null) {
                        return;
                    }
                    int n = JOptionPane.showConfirmDialog(ErrorBrowserEditor.this, "Are you sure you want to remove permanently the file from disk?", "Nuclear launch detected", 0);
                    if (n != 0) {
                        return;
                    }
                    manager.deleteDocument(ErrorBrowserEditor.this.docSelected.toString());
                    ErrorBrowserEditor.this.docSelected = null;
                    ErrorBrowserEditor.this.docNodeSelected = null;
                    ErrorBrowserEditor.this.complexSelected = null;
                    ErrorBrowserEditor.this.complexNodeSelected = null;
                    ErrorBrowserEditor.this.refreshDocsTree();
                    ErrorBrowserEditor.this.refreshDocTable();
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                    ErrorBrowserEditor.this.refreshMembersTable();
                }
            });
        }
        return this.deleteDocButton;
    }

    private JButton getNewDocButton() {
        if (this.newDocButton == null) {
            this.newDocButton = new JButton();
            this.newDocButton.setText("New error file");
            this.newDocButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileFilter(new EbeOpenFileFilter());
                    jFileChooser.setSelectedFile(new File("newErrorDocument.xml"));
                    int n = jFileChooser.showDialog(ErrorBrowserEditor.this, "Create new document");
                    if (n == 0) {
                        int n2;
                        if (jFileChooser.getSelectedFile().exists() && (n2 = JOptionPane.showConfirmDialog(ErrorBrowserEditor.this, "The file already exists, Do you want overwrite the file?", "Warning", 0)) == 1) {
                            return;
                        }
                        String string = jFileChooser.getSelectedFile().getName();
                        if (string.indexOf(".xml") == -1) {
                            jFileChooser.setSelectedFile(new File(string + ".xml"));
                        }
                        string = string.substring(0, string.lastIndexOf(46));
                        manager.newDocument(jFileChooser.getSelectedFile().getAbsolutePath(), string);
                        ErrorBrowserEditor.this.refreshDocsTree();
                        ErrorBrowserEditor.this.docSelected = manager.getDocuments().get(string);
                        ErrorBrowserEditor.this.refreshDocTable();
                        ErrorBrowserEditor.this.refreshMembersTable();
                        ErrorBrowserEditor.this.refreshNodeAttributesTable();
                        ErrorBrowserEditor.this.refreshNodesTree();
                        ErrorBrowserEditor.this.enterEditMode();
                    }
                }
            });
        }
        return this.newDocButton;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.add((Component)this.getJScrollPane5(), "Center");
            this.jPanel4.add((Component)this.getMembersEditPanel(), "West");
        }
        return this.jPanel4;
    }

    private JPanel getMembersEditPanel() {
        if (this.membersEditPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 4, 0, 3);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 4, 0, 3);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            this.membersEditPanel = new JPanel();
            this.membersEditPanel.setLayout(new GridBagLayout());
            this.membersEditPanel.setVisible(false);
            this.membersEditPanel.add((Component)this.getAddMemmberButton(), gridBagConstraints2);
            this.membersEditPanel.add((Component)this.getRemoveMemberButton(), gridBagConstraints);
        }
        return this.membersEditPanel;
    }

    private JButton getAddMemmberButton() {
        if (this.addMemmberButton == null) {
            this.addMemmberButton = new JButton();
            this.addMemmberButton.setText("Add");
            this.addMemmberButton.setFont(new Font("Dialog", 1, 10));
            this.addMemmberButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!(ErrorBrowserEditor.this.complexSelected instanceof Error)) {
                        return;
                    }
                    if (((Error)ErrorBrowserEditor.this.complexSelected).getMembers().get("NewMember") != null) {
                        ErrorBrowserEditor.log("\t[ATENTION: 'NewMember' is not allowed as a valid member name, please change it before adding new members]");
                    } else {
                        Member member = new Member();
                        member.setValue("NewMember");
                        member.setAttributeValue("name", "NewMember");
                        ((Error)ErrorBrowserEditor.this.complexSelected).getMembers().put("NewMember", member);
                        ErrorBrowserEditor.log("\t[New member added]");
                    }
                    ErrorBrowserEditor.this.refreshMembersTable();
                }
            });
        }
        return this.addMemmberButton;
    }

    private JButton getRemoveMemberButton() {
        if (this.removeMemberButton == null) {
            this.removeMemberButton = new JButton();
            this.removeMemberButton.setText("Remove");
            this.removeMemberButton.setFont(new Font("Dialog", 1, 10));
            this.removeMemberButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ErrorBrowserEditor.this.membersTable.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    Error error = (Error)ErrorBrowserEditor.this.complexSelected;
                    TreeMap<String, Member> treeMap = error.getMembers();
                    String string = ErrorBrowserEditor.this.membersTable.getValueAt(n, 0).toString();
                    treeMap.remove(string);
                    ErrorBrowserEditor.log("\t[Member " + string + " removed]");
                    ErrorBrowserEditor.this.refreshMembersTable();
                }
            });
        }
        return this.removeMemberButton;
    }

    private JPopupMenu getNewNodePopupMenu() {
        if (this.newNodePopupMenu == null) {
            this.newNodePopupMenu = new JPopupMenu();
            this.newNodePopupMenu.add(this.getNewErrorMenuItem());
            this.newNodePopupMenu.add(this.getNewCompletionMenuItem());
        }
        return this.newNodePopupMenu;
    }

    private JMenuItem getNewErrorMenuItem() {
        if (this.newErrorMenuItem == null) {
            this.newErrorMenuItem = new JMenuItem();
            this.newErrorMenuItem.setText("Error");
            this.newErrorMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ErrorBrowserEditor.this.docSelected.getNode("NewError") != null) {
                        ErrorBrowserEditor.log("\t[ATENTION: 'NewError' is not allowed as a valid error name, please change it before adding new errors]");
                    } else {
                        Error error = new Error();
                        error.setValue("NewError");
                        error.setAttributeValue("name", "NewError");
                        ErrorBrowserEditor.this.docSelected.putNode(error);
                        ErrorBrowserEditor.this.complexSelected = error;
                        ErrorBrowserEditor.log("\t[New Error Added ]");
                    }
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                }
            });
        }
        return this.newErrorMenuItem;
    }

    private JMenuItem getNewCompletionMenuItem() {
        if (this.newCompletionMenuItem == null) {
            this.newCompletionMenuItem = new JMenuItem();
            this.newCompletionMenuItem.setText("Completion");
            this.newCompletionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ErrorBrowserEditor.this.docSelected.getNode("NewCompletion") != null) {
                        ErrorBrowserEditor.log("\t[ATENTION: 'NewCompletion' is not allowed as a valid completion name, please change it before adding new errors]");
                    } else {
                        Completion completion = new Completion();
                        completion.setValue("NewCompletion");
                        completion.setAttributeValue("name", "NewCompletion");
                        ErrorBrowserEditor.this.docSelected.putNode(completion);
                        ErrorBrowserEditor.this.complexSelected = completion;
                        ErrorBrowserEditor.log("\t[New Completion Added ]");
                    }
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                }
            });
        }
        return this.newCompletionMenuItem;
    }

    private JPopupMenu getRemovePopupMenu() {
        if (this.removePopupMenu == null) {
            this.removePopupMenu = new JPopupMenu();
            this.removePopupMenu.add(this.getRemoveSelectedItem());
            this.removePopupMenu.add(this.getCleanAllFilesItem());
        }
        return this.removePopupMenu;
    }

    private JMenuItem getRemoveSelectedItem() {
        if (this.removeSelectedItem == null) {
            this.removeSelectedItem = new JMenuItem();
            this.removeSelectedItem.setText("Remove selected file");
            this.removeSelectedItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ErrorBrowserEditor.this.docSelected == null) {
                        return;
                    }
                    manager.removeDocument(ErrorBrowserEditor.this.docSelected.toString());
                    ErrorBrowserEditor.this.docNodeSelected = null;
                    ErrorBrowserEditor.this.docSelected = null;
                    ErrorBrowserEditor.this.complexNodeSelected = null;
                    ErrorBrowserEditor.this.complexSelected = null;
                    ErrorBrowserEditor.this.refreshDocsTree();
                    ErrorBrowserEditor.this.refreshDocTable();
                    ErrorBrowserEditor.this.refreshMembersTable();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                    ErrorBrowserEditor.this.refreshNodesTree();
                }
            });
        }
        return this.removeSelectedItem;
    }

    private JMenuItem getCleanAllFilesItem() {
        if (this.cleanAllFilesItem == null) {
            this.cleanAllFilesItem = new JMenuItem();
            this.cleanAllFilesItem.setText("Clear list");
            this.cleanAllFilesItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    manager.removeAll();
                    ErrorBrowserEditor.this.docSelected = null;
                    ErrorBrowserEditor.this.docNodeSelected = null;
                    ErrorBrowserEditor.this.refreshDocsTree();
                    ErrorBrowserEditor.this.refreshDocTable();
                    ErrorBrowserEditor.this.refreshNodesTree();
                    ErrorBrowserEditor.this.refreshNodeAttributesTable();
                    ErrorBrowserEditor.this.refreshMembersTable();
                }
            });
        }
        return this.cleanAllFilesItem;
    }

    public static void main(String[] stringArray) {
        ErrorBrowserEditor errorBrowserEditor = new ErrorBrowserEditor();
        errorBrowserEditor.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXmlView() throws IOException {
        InputStreamReader inputStreamReader = null;
        String string = "";
        if (this.docSelected == null) {
            this.xmlEditorPane.setText(string);
            return;
        }
        try {
            int n;
            inputStreamReader = new FileReader(this.docSelected.getPath());
            while ((n = inputStreamReader.read()) != -1) {
                string = string + (char)n;
            }
            this.xmlEditorPane.setText(string);
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
    }

    private void enterEditMode() {
        boolean bl = true;
        if (this.docSelected == null) {
            return;
        }
        File file = new File(this.docSelected.getPath());
        ErrorBrowserEditor.log("[Entering Edit Mode]");
        if (!file.exists()) {
            bl = false;
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!file.canWrite()) {
            JOptionPane.showMessageDialog(this, "You don't have permission to change this document", "Warning", 2);
            ErrorBrowserEditor.log("[Save disabled]");
        } else {
            this.saveButton.setEnabled(true);
        }
        if (!bl) {
            file.delete();
        }
        this.editButton.setEnabled(false);
        this.cancelEditButton.setEnabled(true);
        this.nodesEditPanel.setVisible(true);
        this.membersEditPanel.setVisible(true);
        this.docTable.setEnabled(true);
        this.nodeAttributesTable.setEnabled(true);
        this.membersTable.setEnabled(true);
        this.docsTree.setEnabled(false);
        this.docsTree.setBackground(Color.LIGHT_GRAY);
        this.newDocButton.setEnabled(false);
        this.deleteDocButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void exitEditMode() {
        this.editButton.setEnabled(true);
        this.cancelEditButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.nodesEditPanel.setVisible(false);
        this.membersEditPanel.setVisible(false);
        this.docTable.setEnabled(false);
        this.nodeAttributesTable.setEnabled(false);
        this.membersTable.setEnabled(false);
        this.docsTree.setEnabled(true);
        this.docsTree.setBackground(Color.WHITE);
        this.newDocButton.setEnabled(true);
        this.deleteDocButton.setEnabled(true);
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        ErrorBrowserEditor.log("[Exiting Edit Mode]");
    }

    public static void log(String string) {
        if (!logInfo) {
            return;
        }
        ErrorBrowserEditor.getTextMessagePane().setText(ErrorBrowserEditor.getTextMessagePane().getText() + "\n" + string);
        System.out.println(string);
    }

    public EbeDocumentManager getManager() {
        return manager;
    }
}

