/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.ebe;

import cl.utfsm.acs.ebe.Completion;
import cl.utfsm.acs.ebe.Error;
import cl.utfsm.acs.ebe.Member;
import cl.utfsm.acs.types.AcsComplexType;
import cl.utfsm.acs.types.ComplexObject;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.TreeMap;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EbeDocument
extends ComplexObject {
    private static DOMParser parser;
    protected static AcsComplexType typeType;
    protected TreeMap<String, ComplexObject> nodes = new TreeMap();
    private String path;
    private Document doc;

    public static void setClassType(AcsComplexType acsComplexType) {
        typeType = acsComplexType;
    }

    public static AcsComplexType getClassType() {
        return typeType;
    }

    public EbeDocument() {
        super(typeType);
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    private void readNode(Node node, ComplexObject complexObject) {
        if (node == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string = namedNodeMap.item(i).getNodeName();
            String string2 = namedNodeMap.item(i).getNodeValue();
            if (string.compareTo("name") == 0) {
                complexObject.setValue(string2);
            }
            complexObject.setAttributeValue(string, string2);
        }
    }

    public void load() {
        Object object;
        if (parser == null) {
            parser = new DOMParser();
        }
        try {
            parser.parse(this.path);
            this.doc = parser.getDocument();
        }
        catch (Exception exception) {
            exception.getMessage();
        }
        this.nodes.clear();
        Node node = this.doc.getElementsByTagName(EbeDocument.getClassType().name).item(0);
        this.readNode(node, this);
        NodeList nodeList = this.doc.getElementsByTagName(Completion.getClassType().name);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            object = new Completion();
            this.readNode(node2, (ComplexObject)object);
            this.putNode((ComplexObject)object);
        }
        NodeList nodeList2 = this.doc.getElementsByTagName(Error.getClassType().name);
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object = nodeList2.item(i);
            Error error = new Error();
            this.readNode((Node)object, error);
            for (Node node3 = object.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                if (!node3.getNodeName().matches("Member")) continue;
                Member member = new Member();
                this.readNode(node3, member);
                error.putMember(member);
            }
            this.putNode(error);
        }
    }

    private void fillAttributes(ComplexObject complexObject, Element element) {
        for (String string : complexObject.getAttributes().keySet()) {
            element.setAttribute(string, complexObject.getAttributeValue(string));
        }
    }

    public void save() throws FileNotFoundException, IOException {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement(EbeDocument.getClassType().name);
        this.fillAttributes(this, element);
        for (ComplexObject complexObject : this.nodes.values()) {
            Element element2 = complexObject instanceof Error ? documentImpl.createElement("ErrorCode") : documentImpl.createElement("Code");
            this.fillAttributes(complexObject, element2);
            if (complexObject instanceof Error) {
                Error error = (Error)complexObject;
                for (Member member : error.getMembers().values()) {
                    Element element3 = documentImpl.createElement("Member");
                    this.fillAttributes(member, element3);
                    element2.appendChild(element3);
                }
            }
            element.appendChild(element2);
        }
        documentImpl.appendChild(element);
        this.saveXmlDocument((Document)documentImpl, this.getPath());
    }

    private void saveXmlDocument(Document document, String string) throws FileNotFoundException, IOException {
        OutputFormat outputFormat = new OutputFormat("xml", null, true);
        outputFormat.setEncoding("UTF-8");
        outputFormat.setVersion("1.0");
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)new PrintWriter(new FileOutputStream(string)), outputFormat);
        xMLSerializer.serialize(document);
    }

    public void putNode(ComplexObject complexObject) {
        this.nodes.put(complexObject.getValue(), complexObject);
    }

    public TreeMap<String, ComplexObject> getNodes() {
        return this.nodes;
    }

    public ComplexObject getNode(String string) {
        return this.nodes.get(string);
    }

    public void setDocumentInfo(String string, String string2, String string3, String string4, String string5) {
        this.setAttributeValue("xsi:schemaLocation", string3 + " " + string4);
        this.setAttributeValue("xmlns", string3);
        this.setAttributeValue("xmlns:xsi", string2);
        this.setAttributeValue("_prefix", string);
        this.setAttributeValue("name", string5);
    }

    public void setDocumentInfo(String string) {
        this.setDocumentInfo("alma", "http://www.w3.org/2001/XMLSchema-instance", "Alma/ACSError", "ACSError.xsd", string);
    }
}

