/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend.ast;

import java.util.Collection;
import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.EvaluationException;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.workflow.issues.Issues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check
extends SyntaxElement {
    private Identifier type;
    private boolean errorSeverity = true;
    private Expression msg;
    private Expression constraint;
    private Expression guard;

    public Check(Identifier type, Expression guard, boolean errorSeverity, Expression msg, Expression constraint) {
        this.type = type;
        this.guard = guard;
        this.errorSeverity = errorSeverity;
        this.msg = msg;
        this.constraint = constraint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        try {
            Type toCheck;
            if (ctx.getCallback() != null) {
                ctx.getCallback().pre(this, ctx);
            }
            if ((toCheck = ctx.getTypeForName(this.type.getValue())) == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found: " + this.type.getValue(), this));
                return;
            }
            ctx = ctx.cloneWithVariable(new Variable("this", toCheck));
            if (this.guard != null) {
                Type guardType = null;
                try {
                    guardType = this.guard.analyze(ctx, issues);
                }
                catch (RuntimeException ex) {
                    ctx.handleRuntimeException(ex, this, null);
                }
                if (guardType == null) {
                    return;
                }
                if (!guardType.equals(ctx.getBooleanType())) {
                    issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Boolean expected! (is " + guardType.getName() + ")", this.guard));
                }
            }
            Type constraintType = null;
            try {
                constraintType = this.constraint.analyze(ctx, issues);
            }
            catch (RuntimeException ex) {
                ctx.handleRuntimeException(ex, this, null);
            }
            if (constraintType == null) {
                return;
            }
            if (!constraintType.equals(ctx.getBooleanType())) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Boolean expected! (is " + constraintType.getName() + ")", this.constraint));
            }
            try {
                this.msg.analyze(ctx, issues);
                return;
            }
            catch (RuntimeException ex) {
                ctx.handleRuntimeException(ex, this, null);
                return;
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(null);
            }
        }
    }

    public void validate(ExecutionContext ctx, Collection<?> colToCheck, Issues issues, boolean warnIfNothingChecked) {
        try {
            Type typeToCheck;
            if (ctx.getCallback() != null) {
                ctx.getCallback().pre(this, ctx);
            }
            if ((typeToCheck = ctx.getTypeForName(this.type.getValue())) == null) {
                throw new EvaluationException("Type not found : " + this.type.getValue(), (SyntaxElement)this, ctx);
            }
            boolean someObjectFound = false;
            for (Object o : colToCheck) {
                if (!typeToCheck.isInstance(o)) continue;
                someObjectFound = true;
                try {
                    ctx = ctx.cloneWithVariable(new Variable("this", o));
                    if (!this.process(ctx)) continue;
                    Object result = null;
                    try {
                        result = this.constraint.evaluate(ctx);
                    }
                    catch (RuntimeException e) {
                        String msg = e.getMessage();
                        issues.addError(msg, (Object)e);
                    }
                    if (result != null && !(result instanceof Boolean)) {
                        throw new EvaluationException("Boolean expected! ( was " + result.getClass().getName() + ")", (SyntaxElement)this, ctx);
                    }
                    Boolean r = (Boolean)result;
                    if (!Boolean.FALSE.equals(r)) continue;
                    Object msgResult = null;
                    try {
                        msgResult = this.msg.evaluate(ctx);
                    }
                    catch (RuntimeException e) {
                        String msg = e.getMessage();
                        issues.addError(msg, (Object)e);
                    }
                    String stringResult = "Message evaluation returned null";
                    if (msgResult != null) {
                        stringResult = msgResult.toString();
                    }
                    if (this.errorSeverity) {
                        issues.addError(stringResult, o);
                        continue;
                    }
                    issues.addWarning(stringResult, o);
                }
                catch (NullPointerException nullPointerException) {
                    Object msgResult = this.msg.evaluate(ctx);
                    String stringResult = "Message evaluation returned null";
                    if (msgResult != null) {
                        stringResult = msgResult.toString();
                    }
                    if (this.errorSeverity) {
                        issues.addError(String.valueOf(stringResult) + " (NPE in constraint evaluation)", o);
                        continue;
                    }
                    issues.addWarning(String.valueOf(stringResult) + " (NPE in constraint evaluation)", o);
                }
            }
            if (warnIfNothingChecked && !someObjectFound) {
                issues.addWarning("The constraint did not match any model elements. Context: " + this.type.toString() + ", message: " + this.msg);
            }
        }
        finally {
            if (ctx.getCallback() != null) {
                ctx.getCallback().post(null);
            }
        }
    }

    private boolean process(ExecutionContext ctx) {
        if (this.guard != null) {
            Object result = this.guard.evaluate(ctx);
            return result instanceof Boolean && (Boolean)result != false;
        }
        return true;
    }

    public String toString() {
        return this.type + " " + this.msg;
    }

    public boolean isErrorCheck() {
        return this.errorSeverity;
    }

    public Expression getConstraint() {
        return this.constraint;
    }

    public Expression getGuard() {
        return this.guard;
    }

    public Expression getMsg() {
        return this.msg;
    }

    public Identifier getType() {
        return this.type;
    }
}

