/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend;

import java.io.StringReader;
import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ExecutionContextImpl;
import org.openarchitectureware.expression.Resource;
import org.openarchitectureware.expression.TypeSystemImpl;
import org.openarchitectureware.type.MetaModel;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.xtend.ast.Extension;
import org.openarchitectureware.xtend.ast.ExtensionFile;
import org.openarchitectureware.xtend.parser.ParseFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendFacade {
    private ExecutionContext ctx;

    private XtendFacade(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    public final XtendFacade cloneWithExtensions(String extensionCode) {
        return new XtendFacade(this.ctx.cloneWithResource(this.parse(extensionCode)));
    }

    public final void registerMetaModel(MetaModel mm) {
        if (!(this.ctx instanceof ExecutionContextImpl)) {
            throw new IllegalStateException("Couldn't register Metamodel - ExecutionContextImpl expected.");
        }
        ((ExecutionContextImpl)this.ctx).registerMetaModel(mm);
    }

    private ExtensionFile parse(String extFile) {
        return ParseFacade.file(new StringReader(extFile), "nofile");
    }

    public static final XtendFacade create(String ... extFile) {
        return XtendFacade.create(new ExecutionContextImpl(new TypeSystemImpl()), extFile);
    }

    public static final XtendFacade create(ExecutionContext ctx, final String ... extFile) {
        ctx = ctx.cloneWithResource(new Resource(){

            public String getFullyQualifiedName() {
                return null;
            }

            public void setFullyQualifiedName(String fqn) {
            }

            public String[] getImportedNamespaces() {
                return null;
            }

            public String[] getImportedExtensions() {
                return extFile;
            }
        });
        return new XtendFacade(ctx);
    }

    public Object call(String ext, Object ... params) {
        Extension extension;
        if (params == null) {
            params = new Object[1];
        }
        if ((extension = this.ctx.getExtension(ext, params)) == null) {
            throw new IllegalArgumentException("Couldn't find extension " + ext);
        }
        return extension.evaluate(params, this.ctx);
    }

    public Type analyze(String string, Object[] objects, Set<AnalysationIssue> issues) {
        if (objects == null) {
            objects = new Object[]{};
        }
        Extension extension = this.ctx.getExtension(string, objects);
        Type[] params = new Type[objects.length];
        int i = 0;
        while (i < params.length) {
            params[i] = this.ctx.getType(objects[i]);
            ++i;
        }
        return extension.getReturnType(params, this.ctx, issues);
    }
}

