/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.type.impl.oawclassic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.openarchitectureware.type.Feature;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.FeatureImpl;
import org.openarchitectureware.type.impl.java.JavaOperationImpl;
import org.openarchitectureware.type.impl.java.JavaPropertyImpl;
import org.openarchitectureware.type.impl.java.JavaTypeStrategy;
import org.openarchitectureware.type.impl.java.TypeFinder;
import org.openarchitectureware.workflow.util.StringHelper;

public class OAWClassicStrategy
implements JavaTypeStrategy {
    private boolean convertPropertiesToLowerCase = true;

    private boolean isOAWClassicGetter(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public Feature[] getFeatures(TypeFinder typeFinder, Class clazz, Type owner) {
        ArrayList<FeatureImpl> result = new ArrayList<FeatureImpl>();
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (this.isOAWClassicGetter(method)) {
                Method getterMethod = method;
                Method setterMethod = null;
                String propName = method.getName();
                if (this.convertPropertiesToLowerCase) {
                    propName = StringHelper.firstLower((String)propName);
                }
                result.add(new JavaPropertyImpl(owner, propName, typeFinder.builtinAwareGetTypeForClass(clazz), getterMethod, setterMethod));
            } else {
                Type rt = typeFinder.builtinAwareGetTypeForClass(method.getReturnType());
                if (rt != null) {
                    Type[] params = new Type[method.getParameterTypes().length];
                    boolean nullParam = false;
                    int j = 0;
                    while (j < params.length && !nullParam) {
                        params[j] = typeFinder.builtinAwareGetTypeForClass(method.getParameterTypes()[j]);
                        nullParam = params[j] == null;
                        ++j;
                    }
                    if (!nullParam) {
                        result.add(new JavaOperationImpl(owner, method.getName(), rt, params, method));
                    }
                }
            }
            ++i;
        }
        return result.toArray(new Feature[result.size()]);
    }

    public void setConvertPropertiesToLowerCase(boolean bool) {
        this.convertPropertiesToLowerCase = bool;
    }
}

