/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openarchitectureware.debug.model.NameValuePair;
import org.openarchitectureware.debug.model.SyntaxElementTO;
import org.openarchitectureware.debug.processing.IElementAdapter;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.ChainExpression;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.FeatureCall;
import org.openarchitectureware.expression.ast.Literal;
import org.openarchitectureware.expression.ast.OperationCall;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.expression.debug.BaseSpecialTreatment;
import org.openarchitectureware.expression.debug.ExpressionModelPresentation;
import org.openarchitectureware.expression.debug.NoResourceSpecial;
import org.openarchitectureware.type.AbstractTypeImpl;
import org.openarchitectureware.type.Callable;
import org.openarchitectureware.type.Feature;
import org.openarchitectureware.type.Property;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.PolymorphicResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionElementAdapter
implements IElementAdapter {
    public static final String TYPE = "expression";
    protected ExecutionContext context;
    protected ExpressionModelPresentation pres;
    protected Set<BaseSpecialTreatment> specials = new HashSet<BaseSpecialTreatment>();
    private final Map<Type, Map<String, Callable>> typeCache = new HashMap<Type, Map<String, Callable>>();

    public ExpressionElementAdapter() {
        this.specials.add(new NoResourceSpecial());
        this.pres = new ExpressionModelPresentation(this.specials);
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = (ExecutionContext)context;
    }

    public String getAdapterType() {
        return TYPE;
    }

    public boolean canHandle(Object element) {
        if (element instanceof Expression) {
            return true;
        }
        if (element instanceof SyntaxElementTO) {
            SyntaxElementTO se = (SyntaxElementTO)element;
            return se.resource.endsWith(".ext");
        }
        return false;
    }

    public boolean shallHandle(Object element) {
        return element instanceof OperationCall && ((OperationCall)element).getName().getValue().length() > 2;
    }

    public boolean shallSuspend(Object element, int flag) {
        boolean result = true;
        for (BaseSpecialTreatment special : this.specials) {
            result &= !special.shallNotSuspend(element, flag, this.context);
        }
        return result;
    }

    public SyntaxElementTO createElementTO(Object element) {
        SyntaxElementTO to = this.pres.getStartPresentation((SyntaxElement)element, this.context);
        for (BaseSpecialTreatment special : this.specials) {
            special.adaptSyntaxElementTO(to, element);
        }
        return to;
    }

    public boolean isSurroundingElement(Object element) {
        return false;
    }

    public SyntaxElementTO createEndElementTO(Object element) {
        return this.pres.getEndPresentation((SyntaxElement)element, this.context);
    }

    public String getVariableDetailRep(Object element) {
        return this.pres.getStringRep(element);
    }

    public String getVariableSimpleRep(Object element) {
        return this.pres.getVariableSimpleRep(element, this.context);
    }

    public boolean checkVariableHasMembers(Object element) {
        if (element instanceof Collection) {
            return !((Collection)element).isEmpty();
        }
        if (element instanceof Type) {
            Type t = (Type)element;
            return t.getAllProperties().size() > 0;
        }
        return this.context.getType(element).getAllProperties().size() > 0;
    }

    public List<NameValuePair> getVariables(Object element) {
        if (element instanceof ChainExpression || element instanceof Literal) {
            return Collections.EMPTY_LIST;
        }
        if (element instanceof OperationCall) {
            Expression[] params;
            ArrayList<NameValuePair> result = this.getAllVisibleVariables();
            Map<String, Variable> visibleVariables = this.context.getVisibleVariables();
            Expression[] expressionArray = params = ((OperationCall)element).getParams();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureCall fc;
                Expression expression = expressionArray[n2];
                if (expression instanceof FeatureCall && !(expression instanceof OperationCall) && !visibleVariables.containsKey((fc = (FeatureCall)expression).toString())) {
                    result.addAll(this.evaluateFeatureCall(fc));
                }
                ++n2;
            }
            Expression target = ((OperationCall)element).getTarget();
            if (target instanceof FeatureCall && !(target instanceof OperationCall) && !visibleVariables.containsKey(target.toString())) {
                FeatureCall fc = (FeatureCall)target;
                result.addAll(this.evaluateFeatureCall(fc));
            }
            return result;
        }
        if (element instanceof FeatureCall) {
            return this.evaluateFeatureCall((FeatureCall)element);
        }
        if (element instanceof Collection) {
            ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
            Collection col = (Collection)element;
            int i = 0;
            for (Object object : col) {
                result.add(new NameValuePair("[" + i + "]", object));
                ++i;
            }
            return result;
        }
        Type type = this.context.getType(element);
        return this.getAllPropertiesFor(type, element);
    }

    public Object findElement(SyntaxElementTO se, Object actual, int flag) {
        if (actual == null) {
            return null;
        }
        if (actual instanceof OperationCall) {
            OperationCall op = (OperationCall)actual;
            int start = this.pres.getStart(op);
            if (se.resource.endsWith(this.pres.getStringRep(op.getFileName())) && se.start == start) {
                return actual;
            }
        }
        return null;
    }

    protected ArrayList<NameValuePair> getAllVisibleVariables() {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        Map<String, Variable> visibleVariables = this.context.getVisibleVariables();
        for (Map.Entry<String, Variable> nameValuePair : visibleVariables.entrySet()) {
            result.add(new NameValuePair(nameValuePair.getKey(), nameValuePair.getValue().getValue()));
        }
        return result;
    }

    private List<NameValuePair> evaluateFeatureCall(FeatureCall fc) {
        return this.getEvalResultProperties(fc.toString(), fc.evaluate(this.context.cloneWithoutMonitor()));
    }

    private List<NameValuePair> getEvalResultProperties(String prefix, Object evaluate) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        if (evaluate instanceof Collection) {
            result.add(new NameValuePair(prefix, evaluate));
            return result;
        }
        Type type = this.context.getType(evaluate);
        return this.getAllPropertiesFor(type, evaluate);
    }

    private List<NameValuePair> getAllPropertiesFor(Type type, Object element) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        for (Property property : this.getAllProperties(type)) {
            String name = property.getName();
            if (name.equals("wait") || name.startsWith("notify")) continue;
            Object value = null;
            try {
                value = property.get(element);
            }
            catch (Exception e) {
                value = "Error: " + e.getMessage();
            }
            if (value == null) continue;
            result.add(new NameValuePair(name, value));
        }
        return result;
    }

    private Set<? extends Property> getAllProperties(Type type) {
        return PolymorphicResolver.select(this.getAllFeatures(type), Property.class);
    }

    public final Set<Callable> getAllFeatures(Type type) {
        Map<Object, Object> allFeatures;
        if (this.typeCache.containsKey(type)) {
            allFeatures = this.typeCache.get(type);
        } else {
            allFeatures = new HashMap();
            Feature[] contribs = ((AbstractTypeImpl)type).getContributedFeatures();
            this.addIfNotExist(allFeatures, (Collection<Callable>)Arrays.asList(contribs));
            for (Type type2 : type.getSuperTypes()) {
                if (type2 == null) continue;
                this.addIfNotExist(allFeatures, this.getAllFeatures(type2));
            }
            this.typeCache.put(type, allFeatures);
        }
        HashSet<Callable> result = new HashSet<Callable>();
        result.addAll(allFeatures.values());
        return result;
    }

    private void addIfNotExist(Map<String, Callable> all, Collection<Callable> more) {
        for (Callable one : more) {
            String name = one.getName();
            if (all.containsKey(name)) continue;
            all.put(name, one);
        }
    }
}

