/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.ast;

import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetExpression
extends Expression {
    private Expression varExpression;
    private Expression targetExpression;
    private Identifier varName;

    public LetExpression(Identifier varName, Expression varExpression, Expression target) {
        this.varName = varName;
        this.varExpression = varExpression;
        this.targetExpression = target;
    }

    public Expression getVarExpression() {
        return this.varExpression;
    }

    public Expression getTargetExpression() {
        return this.targetExpression;
    }

    public String getName() {
        return this.varName.getValue();
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object o = this.varExpression.evaluate(ctx);
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), o));
        return this.targetExpression.evaluate(ctx);
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = this.varExpression.analyze(ctx, issues);
        if (t == null) {
            return null;
        }
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), t));
        return this.targetExpression.analyze(ctx, issues);
    }

    @Override
    protected String toStringInternal() {
        return "let " + this.varName + "=" + this.varExpression + " : " + this.targetExpression;
    }
}

