/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.ast;

import org.openarchitectureware.expression.ast.AbstractVisitor;
import org.openarchitectureware.expression.ast.BooleanLiteral;
import org.openarchitectureware.expression.ast.BooleanOperation;
import org.openarchitectureware.expression.ast.Case;
import org.openarchitectureware.expression.ast.Cast;
import org.openarchitectureware.expression.ast.ChainExpression;
import org.openarchitectureware.expression.ast.CollectionExpression;
import org.openarchitectureware.expression.ast.ConstructorCallExpression;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.FeatureCall;
import org.openarchitectureware.expression.ast.GlobalVarExpression;
import org.openarchitectureware.expression.ast.ISyntaxElement;
import org.openarchitectureware.expression.ast.IfExpression;
import org.openarchitectureware.expression.ast.IntegerLiteral;
import org.openarchitectureware.expression.ast.LetExpression;
import org.openarchitectureware.expression.ast.ListLiteral;
import org.openarchitectureware.expression.ast.NullLiteral;
import org.openarchitectureware.expression.ast.OperationCall;
import org.openarchitectureware.expression.ast.RealLiteral;
import org.openarchitectureware.expression.ast.StringLiteral;
import org.openarchitectureware.expression.ast.SwitchExpression;
import org.openarchitectureware.expression.ast.TypeSelectExpression;

public abstract class AbstractExpressionVisitor
extends AbstractVisitor {
    public final Object visit(ISyntaxElement ele) {
        Object result = null;
        if (result == null && ele instanceof BooleanOperation) {
            result = this.visitBooleanOperation((BooleanOperation)ele);
        }
        if (result == null && ele instanceof Cast) {
            result = this.visitCast((Cast)ele);
        }
        if (result == null && ele instanceof ConstructorCallExpression) {
            result = this.visitConstructorCallExpression((ConstructorCallExpression)ele);
        }
        if (result == null && ele instanceof GlobalVarExpression) {
            result = this.visitGlobalVarExpression((GlobalVarExpression)ele);
        }
        if (result == null && ele instanceof ChainExpression) {
            result = this.visitChainExpression((ChainExpression)ele);
        }
        if (result == null && ele instanceof CollectionExpression) {
            result = this.visitCollectionExpression((CollectionExpression)ele);
        }
        if (result == null && ele instanceof OperationCall) {
            result = this.visitOperationCall((OperationCall)ele);
        }
        if (result == null && ele instanceof TypeSelectExpression) {
            result = this.visitTypeSelectExpression((TypeSelectExpression)ele);
        }
        if (result == null && ele instanceof FeatureCall) {
            result = this.visitFeatureCall((FeatureCall)ele);
        }
        if (result == null && ele instanceof IfExpression) {
            result = this.visitIfExpression((IfExpression)ele);
        }
        if (result == null && ele instanceof LetExpression) {
            result = this.visitLetExpression((LetExpression)ele);
        }
        if (result == null && ele instanceof SwitchExpression) {
            result = this.visitSwitchExpression((SwitchExpression)ele);
        }
        if (result == null && ele instanceof ListLiteral) {
            result = this.visitListLiteral((ListLiteral)ele);
        }
        if (result == null && ele instanceof BooleanLiteral) {
            result = this.visitBooleanLiteral((BooleanLiteral)ele);
        }
        if (result == null && ele instanceof IntegerLiteral) {
            result = this.visitIntegerLiteral((IntegerLiteral)ele);
        }
        if (result == null && ele instanceof NullLiteral) {
            result = this.visitNullLiteral((NullLiteral)ele);
        }
        if (result == null && ele instanceof RealLiteral) {
            result = this.visitRealLiteral((RealLiteral)ele);
        }
        if (result == null && ele instanceof StringLiteral) {
            result = this.visitStringLiteral((StringLiteral)ele);
        }
        return result;
    }

    protected Object visitBooleanOperation(BooleanOperation node) {
        if (node.getLeft() != null) {
            node.getLeft().accept(this);
        }
        if (node.getRight() != null) {
            node.getRight().accept(this);
        }
        return node;
    }

    protected Object visitCast(Cast node) {
        if (node.getTarget() != null) {
            node.getTarget().accept(this);
        }
        return node;
    }

    protected Object visitConstructorCallExpression(ConstructorCallExpression node) {
        return node;
    }

    protected Object visitGlobalVarExpression(GlobalVarExpression node) {
        return node;
    }

    protected Object visitChainExpression(ChainExpression ce) {
        if (ce.getFirst() != null) {
            ce.getFirst().accept(this);
        }
        if (ce.getNext() != null) {
            ce.getNext().accept(this);
        }
        return ce;
    }

    protected Object visitFeatureCall(FeatureCall fc) {
        if (fc.getTarget() != null) {
            fc.getTarget().accept(this);
        }
        return fc;
    }

    protected Object visitCollectionExpression(CollectionExpression node) {
        if (node.getClosure() != null) {
            node.getClosure().accept(this);
        }
        if (node.getTarget() != null) {
            node.getTarget().accept(this);
        }
        return node;
    }

    protected Object visitOperationCall(OperationCall oc) {
        if (oc.getTarget() != null) {
            oc.getTarget().accept(this);
        }
        if (oc.getParamsAsList() != null) {
            for (Expression expr : oc.getParamsAsList()) {
                expr.accept(this);
            }
        }
        return oc;
    }

    protected Object visitTypeSelectExpression(TypeSelectExpression node) {
        if (node.getTarget() != null) {
            node.getTarget().accept(this);
        }
        return node;
    }

    protected Object visitIfExpression(IfExpression node) {
        if (node.getCondition() != null) {
            node.getCondition().accept(this);
        }
        if (node.getThenPart() != null) {
            node.getThenPart().accept(this);
        }
        if (node.getElsePart() != null) {
            node.getElsePart().accept(this);
        }
        return node;
    }

    protected Object visitLetExpression(LetExpression node) {
        if (node.getTargetExpression() != null) {
            node.getTargetExpression().accept(this);
        }
        if (node.getVarExpression() != null) {
            node.getVarExpression().accept(this);
        }
        return node;
    }

    protected Object visitSwitchExpression(SwitchExpression node) {
        for (Case caze : node.getCases()) {
            if (caze.getCondition() != null) {
                caze.getCondition().accept(this);
            }
            if (caze.getThenPart() == null) continue;
            caze.getThenPart().accept(this);
        }
        if (node.getSwitchExpr() != null) {
            node.getSwitchExpr().accept(this);
        }
        if (node.getDefaultExpr() != null) {
            node.getDefaultExpr().accept(this);
        }
        return node;
    }

    protected Object visitListLiteral(ListLiteral node) {
        return node;
    }

    protected Object visitBooleanLiteral(BooleanLiteral node) {
        return node;
    }

    protected Object visitIntegerLiteral(IntegerLiteral node) {
        return node;
    }

    protected Object visitNullLiteral(NullLiteral node) {
        return node;
    }

    protected Object visitRealLiteral(RealLiteral node) {
        return node;
    }

    protected Object visitStringLiteral(StringLiteral node) {
        return node;
    }
}

