/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.userdb.offline;

import alma.obsprep.ot.userdb.EmailAddress;
import alma.obsprep.ot.userdb.QueryResults;
import alma.obsprep.ot.userdb.User;
import alma.obsprep.ot.userdb.UserDatabase;
import alma.obsprep.ot.userdb.exceptions.InvalidArgumentException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class OfflineDatabase
implements UserDatabase {
    private static final List<User> db = new ArrayList<User>();
    private final int MIN_NAME_LENGTH = 3;
    private final int MIN_UID_MATCH = 3;

    public boolean isAlive() {
        return true;
    }

    public QueryResults matchEmail(String email) throws InvalidArgumentException {
        if (!EmailAddress.isValidText((String)email)) {
            throw new InvalidArgumentException("Invalid email address");
        }
        ArrayList<User> matches = new ArrayList<User>();
        for (User u : db) {
            if (!u.getEmail().equals(email)) continue;
            matches.add(u);
        }
        return new QueryResults(matches);
    }

    public QueryResults matchEmail(List<String> addresses) throws InvalidArgumentException {
        LinkedHashSet matches = new LinkedHashSet();
        for (String email : addresses) {
            matches.addAll(this.matchEmail(email).getMatches());
        }
        ArrayList asList = new ArrayList();
        asList.addAll(matches);
        return new QueryResults(asList);
    }

    public QueryResults matchName(String name) {
        String normalised = this.removeAccents(name);
        ArrayList<User> matches = new ArrayList<User>();
        for (User u : db) {
            if (!this.removeAccents(u.getFirstName()).contains(normalised) && !this.removeAccents(u.getSurname()).contains(normalised) && !this.removeAccents(u.getFullName()).contains(normalised)) continue;
            matches.add(u);
        }
        return new QueryResults(matches);
    }

    public QueryResults matchName(List<String> names) {
        LinkedHashSet matches = new LinkedHashSet();
        for (String name : names) {
            matches.addAll(this.matchName(name).getMatches());
        }
        ArrayList asList = new ArrayList();
        asList.addAll(matches);
        return new QueryResults(asList);
    }

    public QueryResults matchUid(String uid) {
        String normalised = this.removeAccents(uid);
        ArrayList<User> matches = new ArrayList<User>();
        for (User u : db) {
            if (!u.getUid().equalsIgnoreCase(normalised)) continue;
            matches.add(u);
        }
        return new QueryResults(matches);
    }

    public QueryResults matchUid(List<String> uids) {
        LinkedHashSet matches = new LinkedHashSet();
        for (String uid : uids) {
            matches.addAll(this.matchUid(uid).getMatches());
        }
        ArrayList asList = new ArrayList();
        asList.addAll(matches);
        return new QueryResults(asList);
    }

    private String removeAccents(String input) {
        String normalised = Normalizer.normalize(input, Normalizer.Form.NFKD);
        normalised = normalised.replaceAll("[^\\p{ASCII}]", "");
        return normalised.toLowerCase();
    }

    public static List<User> getUsers() {
        return db;
    }

    static {
        db.add(new User("john", "John Lennon", "The Beatles", "john@thebeatles.com"));
        db.add(new User("paul", "Paul McCartney", "The Beatles", "paul@thebeatles.com"));
        db.add(new User("george", "George Harrison", "The Beatles", "george@thebeatles.com"));
        db.add(new User("ringo", "Ringo Starr", "The Beatles", "ringo@thebeatles.com"));
        db.add(new User("sam", "Stewart McLay", "UK ATC", "sam@roe.ac.uk"));
        db.add(new User("sjw", "Stewart Williams", "UK ATC", "sjw@roe.ac.uk"));
        db.add(new User("alan", "Alan Bridger", "UK ATC", "ab@roe.ac.uk"));
        db.add(new User("hiroshi", "Hiroshi Yatagai", "NAOJ", "yatagai.hiroshi@nao.ac.jp"));
        db.add(new User("marcus", "Marcus Schilling", "European Southern Observatory", "mschilli@eso.org"));
        db.add(new User("rein", "Rein H. Warmels", "European Southern Observatory", "rwarmels@eso.org"));
        db.add(new User("andy", "Andy Biggs", "European Southern Observatory", "abiggs@eso.org"));
        db.add(new User("amsrichards", "Anita Richards", "University of Manchester", "a.m.s.richards@manchester.ac.uk"));
        db.add(new User("mzwaan", "Martin Zwaan", "European Southern Observatory", "mzwaan@eso.org"));
        db.add(new User("evkampen", "Eelco Van Kampen", "European Southern Observatory", "evkampen@eso.org"));
        db.add(new User("psalome", "Philippe Salom\u00e9", "IRAM", "salome@iram.fr"));
        db.add(new User("lanyman", "Lars-\u00c5ke Nyman", "Joint ALMA Office", "lnyman@alma.cl"));
        db.add(new User("wfrieswijk", "Wilfreid Frieswijk", "Leiden Observatory", "frieswyk@astro.rug.nl"));
        db.add(new User("mrawlings", "Mark Rawlings", "Joint ALMA Office", "mrawling@alma.cl"));
        db.add(new User("jjorgensen", "Jes J\u00f8rgensen", "University of Bonn", "jes@astro.uni-bonn.de"));
        db.add(new User("azanichelli", "Alessandra Zanichelli", "INAF", "a.zanichelli@ira.inaf.it"));
        db.add(new User("smuller", "Sebastian Muller", "Onsala Space Observatory", "sebastien.muller@chalmers.se"));
        db.add(new User("sokumura", "Sachiko Okumura", "Nobeyama Radio Observatory", "sokumura@nro.nao.ac.jp"));
        db.add(new User("saigo", "Saigo Kazuya", "NAOJ", "saigo.kazuya@nao.ac.jp"));
        db.add(new User("splai", "Shih-Ping Lai", "ASIAA", "splai@asiaa.sinica.edu.tw"));
        db.add(new User("thunter", "Todd Hunter", "NRAO", "thunter@nrao.edu"));
        db.add(new User("jcortes", "Juan Cort\u00e9s", "Joint ALMA Observatory", "jcortes@alma.cl"));
        db.add(new User("rkneissl", "R\u00fcdiger Kneissl", "Joint ALMA Observatory", "kneissel@alma.cl"));
        db.add(new User("ktachihara", "Kengo Tachihara", "NAOJ", "k.tachihara@nao.ac.jp"));
        db.add(new User("hliszt", "Harvey Liszt", "NRAO", "hliszt@nrao.edu"));
        db.add(new User("jhibbard", "John Hibbard", "NRAO", "jhibbard@nrao.edu"));
        db.add(new User("awootten", "Al Wootten", "NRAO", "awootten@nrao.edu"));
        db.add(new User("clonsdale", "Carol Lonsdale", "NRAO", "clonsdale@nrao.edu"));
        db.add(new User("rindebetouw", "R\u00e9my Indebetouw", "University of Virginia", "remy@virginia.edu"));
    }
}

