/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.userdb.ldap;

import alma.obsprep.ot.userdb.QueryResults;
import alma.obsprep.ot.userdb.User;
import alma.obsprep.ot.userdb.UserDatabase;
import alma.obsprep.ot.userdb.exceptions.InvalidArgumentException;
import alma.obsprep.ot.userdb.exceptions.InvestigatorDatabaseException;
import alma.userrepository.addressbook.AddressBookSession;
import alma.userrepository.errors.CommunicationException;
import alma.userrepository.errors.InvalidSearchFilterException;
import alma.userrepository.errors.UserRepositoryException;
import alma.userrepository.shared.DirectorySessionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserRepositoryDatabase
implements UserDatabase {
    private static final List<String> ATTRIBUTES = new ArrayList<String>();
    private static final String FIRST_NAME = "givenName";
    private static final String SURNAME = "sn";
    private static final String FULL_NAME = "cn";
    private static final String UID = "uid";
    private static final String EMAIL = "mail";
    private static final String TELEPHONE = "telephoneNumber";
    private static final String AFFILIATION = "o";

    public boolean isAlive() {
        return DirectorySessionFactory.getInstance().isAlive();
    }

    public QueryResults matchEmail(String email) throws alma.obsprep.ot.userdb.exceptions.CommunicationException, InvestigatorDatabaseException {
        String filter = this.getEmailFilter(email);
        return this.submitQuery(filter);
    }

    public QueryResults matchEmail(List<String> addresses) throws InvalidArgumentException, alma.obsprep.ot.userdb.exceptions.CommunicationException, InvestigatorDatabaseException {
        String filter = this.getEmailFilter(addresses);
        QueryResults results = this.submitQuery(filter);
        return this.sortByEmail(results, addresses);
    }

    public QueryResults matchName(String name) throws alma.obsprep.ot.userdb.exceptions.CommunicationException, InvestigatorDatabaseException {
        String filter = this.getNameFilter(name);
        return this.submitQuery(filter);
    }

    public QueryResults matchName(List<String> names) throws alma.obsprep.ot.userdb.exceptions.CommunicationException, InvestigatorDatabaseException {
        String filter = this.getNameFilter(names);
        return this.submitQuery(filter);
    }

    public QueryResults matchUid(String uid) throws alma.obsprep.ot.userdb.exceptions.CommunicationException, InvestigatorDatabaseException {
        String filter = this.getUidFilter(uid);
        return this.submitQuery(filter);
    }

    public QueryResults matchUid(List<String> uids) throws alma.obsprep.ot.userdb.exceptions.CommunicationException, InvestigatorDatabaseException {
        String filter = this.getUidFilter(uids);
        QueryResults unsorted = this.submitQuery(filter);
        return this.sortByUid(unsorted, uids);
    }

    private QueryResults sortByUid(QueryResults results, List<String> uids) {
        List unsorted = results.getMatches();
        ArrayList<User> sorted = new ArrayList<User>();
        for (String uid : uids) {
            for (User user : unsorted) {
                if (!user.getUid().equals(uid) || sorted.contains(user)) continue;
                sorted.add(user);
            }
        }
        unsorted.removeAll(sorted);
        sorted.addAll(unsorted);
        return new QueryResults(sorted);
    }

    private QueryResults sortByEmail(QueryResults results, List<String> addresses) {
        List unsorted = results.getMatches();
        ArrayList<User> sorted = new ArrayList<User>();
        for (String email : addresses) {
            for (User user : unsorted) {
                if (!user.getEmail().equals(email) || sorted.contains(user)) continue;
                sorted.add(user);
            }
        }
        unsorted.removeAll(sorted);
        sorted.addAll(unsorted);
        return new QueryResults(sorted);
    }

    private QueryResults submitQuery(String filter) throws alma.obsprep.ot.userdb.exceptions.CommunicationException, InvestigatorDatabaseException {
        try {
            AddressBookSession session = DirectorySessionFactory.getInstance().newAddressBookSession(null, null);
            List results = session.searchGetAttributes(filter, ATTRIBUTES);
            return this.convertLdapResults(results);
        }
        catch (InvalidSearchFilterException ex) {
            Logger.getLogger(UserRepositoryDatabase.class.getName()).log(Level.INFO, null, ex);
            return new QueryResults();
        }
        catch (CommunicationException ex) {
            Logger.getLogger(UserRepositoryDatabase.class.getName()).log(Level.SEVERE, null, ex);
            throw new alma.obsprep.ot.userdb.exceptions.CommunicationException("Error communicating with user repository: " + (Object)((Object)ex), (Throwable)ex);
        }
        catch (UserRepositoryException ex) {
            Logger.getLogger(UserRepositoryDatabase.class.getName()).log(Level.SEVERE, null, ex);
            throw new InvestigatorDatabaseException("Unexpected error while searching for '" + filter + "':" + (Object)((Object)ex), (Throwable)ex);
        }
    }

    private QueryResults convertLdapResults(List<Map<String, String>> results) {
        ArrayList<User> users = new ArrayList<User>();
        for (Map<String, String> map : results) {
            users.add(this.convertMapToUser(map));
        }
        return new QueryResults(users);
    }

    private User convertMapToUser(Map<String, String> map) {
        User user = new User();
        user.setUid(map.get(UID));
        user.setFullName(map.get(FULL_NAME));
        user.setFirstName(map.get(FIRST_NAME));
        user.setSurname(map.get(SURNAME));
        user.setEmail(map.get(EMAIL));
        user.setTelephone(map.get(TELEPHONE));
        user.setAffiliation(map.get(AFFILIATION));
        return user;
    }

    private String getNameFilter(String name) {
        String filter = "(&(objectClass=almaUser)(|(cn=*" + name + "*)(" + FIRST_NAME + "=*" + name + "*)(" + SURNAME + "=*" + name + "*)))";
        return filter;
    }

    private String getNameFilter(List<String> names) {
        StringBuilder sb = new StringBuilder("(&(objectClass=almaUser)(|");
        for (String name : names) {
            sb.append("(|(cn=*" + name + "*)(" + FIRST_NAME + "=*" + name + "*)(" + SURNAME + "=*" + name + "*))");
        }
        sb.append("))");
        return sb.toString();
    }

    private String getEmailFilter(String email) {
        String filter = "(&(objectClass=almaUser)(mail=" + email + "))";
        return filter;
    }

    private String getEmailFilter(List<String> addresses) {
        StringBuilder sb = new StringBuilder("(&(objectClass=almaUser)(|");
        for (String email : addresses) {
            sb.append("(mail=" + email + ")");
        }
        sb.append("))");
        return sb.toString();
    }

    private String getUidFilter(String uid) {
        String filter = "(&(objectClass=almaUser)(uid=" + uid + "))";
        return filter;
    }

    private String getUidFilter(List<String> uids) {
        StringBuilder sb = new StringBuilder("(&(objectClass=almaUser)(|");
        for (String uid : uids) {
            sb.append("(uid=" + uid + ")");
        }
        sb.append("))");
        return sb.toString();
    }

    static {
        ATTRIBUTES.add(UID);
        ATTRIBUTES.add(FULL_NAME);
        ATTRIBUTES.add(FIRST_NAME);
        ATTRIBUTES.add(SURNAME);
        ATTRIBUTES.add(AFFILIATION);
        ATTRIBUTES.add(EMAIL);
        ATTRIBUTES.add(TELEPHONE);
    }
}

