/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.tree;

import cern.laser.client.data.Alarm;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class AlarmTreeModel
extends DefaultTreeModel {
    public AlarmTreeModel(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(defaultMutableTreeNode);
    }

    public DefaultMutableTreeNode addChild(Alarm alarm, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (alarm == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.root;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new NodeContent(alarm));
        this.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, 0);
        this.nodeStructureChanged(defaultMutableTreeNode);
        return defaultMutableTreeNode2;
    }

    public void clearTree(Alarm alarm) {
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            this.removeNodeFromParent(defaultMutableTreeNode);
        }
        ((DefaultMutableTreeNode)this.root).setUserObject(alarm);
        this.nodeStructureChanged(this.root);
    }

    public class NodeContent {
        private final Alarm alarm;

        public NodeContent(Alarm alarm) {
            if (alarm == null) {
                throw new IllegalArgumentException("The content can't be null");
            }
            this.alarm = alarm;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.alarm.getTriplet().getFaultMember());
            stringBuilder.append(' ');
            stringBuilder.append(this.alarm.getTriplet().getFaultCode());
            stringBuilder.append(": ");
            stringBuilder.append(this.alarm.getProblemDescription());
            return stringBuilder.toString();
        }
    }
}

