/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.toolbar;

import alma.acsplugins.alarmsystem.gui.CernSysPanel;
import alma.acsplugins.alarmsystem.gui.sound.AlarmSound;
import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import alma.acsplugins.alarmsystem.gui.table.AlarmTable;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import alma.acsplugins.alarmsystem.gui.toolbar.SoundWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Toolbar
extends JPanel
implements ActionListener,
DocumentListener {
    private final CernSysPanel alarmPanel;
    private JComboBox autoAckLevelCB = new JComboBox<ComboBoxValues>(ComboBoxValues.values());
    private ImageIcon activeReductionIcon;
    private ImageIcon inactiveReductionIcon;
    private JToggleButton reductionRulesBtn;
    private ImageIcon pausedIcon = new ImageIcon(Toolbar.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/play.png"));
    private ImageIcon notPausedIcon = new ImageIcon(Toolbar.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/pause.png"));
    private ImageIcon filterIcon = new ImageIcon(Toolbar.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/filters.png"));
    private JToggleButton showBtn = new JToggleButton("Show", this.filterIcon, false);
    private JToggleButton hideBtn = new JToggleButton("Hide", this.filterIcon, false);
    private JButton pauseBtn = new JButton("Pause", this.notPausedIcon);
    private JLabel autoAckLbl = new JLabel("Auto ack: ");
    private JTextField searchTF = new JTextField(16);
    private JButton nextSearchBtn = new JButton(new ImageIcon(Toolbar.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/resultset_next.png")));
    private JButton prevSearchBtn = new JButton(new ImageIcon(Toolbar.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/resultset_previous.png")));
    private final AlarmTable table;
    private final AlarmTableModel model;
    private final SoundWidget soundComponent;

    public Toolbar(AlarmTable alarmTable, AlarmTableModel alarmTableModel, AlarmSound alarmSound, boolean bl, CernSysPanel cernSysPanel) {
        if (alarmTable == null) {
            throw new IllegalArgumentException("The table can't be null");
        }
        if (alarmTableModel == null) {
            throw new IllegalArgumentException("The model can't be null");
        }
        if (cernSysPanel == null) {
            throw new IllegalArgumentException("The panel can't be null");
        }
        this.soundComponent = new SoundWidget(alarmSound);
        this.table = alarmTable;
        this.model = alarmTableModel;
        this.alarmPanel = cernSysPanel;
        this.initialize(bl);
    }

    private void initialize(boolean bl) {
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.add(this.soundComponent);
        Font font = this.autoAckLbl.getFont();
        Font font2 = font.deriveFont(font.getSize() * 80 / 100);
        this.autoAckLbl.setFont(font2);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.autoAckLbl);
        this.autoAckLevelCB.setFont(font2);
        this.autoAckLevelCB.setEditable(false);
        this.autoAckLevelCB.setOpaque(true);
        ComboBoxValues.initSizes();
        this.autoAckLevelCB.setRenderer(new ComboBoxRenderer());
        this.autoAckLevelCB.setSelectedIndex(ComboBoxValues.NONE.ordinal());
        this.autoAckLevelCB.setMaximumRowCount(ComboBoxValues.values().length);
        this.autoAckLevelCB.setEditable(false);
        this.autoAckLevelCB.addActionListener(this);
        Dimension dimension = new Dimension(ComboBoxValues.getWidth(), ComboBoxValues.getHeight());
        this.autoAckLevelCB.setMinimumSize(dimension);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.autoAckLevelCB);
        this.activeReductionIcon = new ImageIcon(this.getClass().getResource("/alma/acsplugins/alarmsystem/gui/resources/arrow_in.png"));
        this.inactiveReductionIcon = new ImageIcon(this.getClass().getResource("/alma/acsplugins/alarmsystem/gui/resources/arrow_out.png"));
        this.reductionRulesBtn = new JToggleButton("Reduce", this.activeReductionIcon, bl);
        this.reductionRulesBtn.setFont(font2);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.reductionRulesBtn);
        this.reductionRulesBtn.addActionListener(this);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.pauseBtn);
        this.pauseBtn.addActionListener(this);
        this.pauseBtn.setFont(font2);
        this.add(Box.createHorizontalStrut(5));
        this.add(new JSeparator(1));
        this.add(Box.createHorizontalStrut(5));
        JLabel jLabel = new JLabel("Search");
        this.add(jLabel);
        jLabel.setFont(font2);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.searchTF);
        this.searchTF.setEditable(true);
        this.searchTF.getDocument().addDocumentListener(this);
        this.searchTF.setToolTipText("Search");
        this.add(Box.createHorizontalStrut(3));
        this.add(this.prevSearchBtn);
        this.prevSearchBtn.setToolTipText("Search prev");
        this.prevSearchBtn.addActionListener(this);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.nextSearchBtn);
        this.nextSearchBtn.setToolTipText("Search next");
        this.nextSearchBtn.addActionListener(this);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.showBtn);
        this.showBtn.setFont(font2);
        this.showBtn.setToolTipText("Filter in");
        this.showBtn.addActionListener(this);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.hideBtn);
        this.hideBtn.setFont(font2);
        this.hideBtn.setToolTipText("Filter out");
        this.hideBtn.addActionListener(this);
        this.add(Box.createHorizontalStrut(2));
        this.ratioSearchBtns();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block23: {
            if (actionEvent.getSource() == this.autoAckLevelCB) {
                this.model.setAutoAckLevel((ComboBoxValues)((Object)this.autoAckLevelCB.getSelectedItem()));
            } else if (actionEvent.getSource() == this.reductionRulesBtn) {
                this.model.applyReductions(this.reductionRulesBtn.isSelected());
                if (this.reductionRulesBtn.isSelected()) {
                    this.reductionRulesBtn.setIcon(this.activeReductionIcon);
                } else {
                    this.reductionRulesBtn.setIcon(this.inactiveReductionIcon);
                }
            } else if (actionEvent.getSource() == this.pauseBtn) {
                try {
                    if (this.pauseBtn.getIcon() == this.notPausedIcon) {
                        this.alarmPanel.pause();
                        break block23;
                    }
                    this.alarmPanel.resume();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                    JOptionPane.showMessageDialog(this, throwable.getMessage(), "Error pausing/unpausing", 0);
                }
            } else if (actionEvent.getSource() == this.prevSearchBtn) {
                this.table.search(this.searchTF.getText(), false);
            } else if (actionEvent.getSource() == this.nextSearchBtn) {
                this.table.search(this.searchTF.getText(), true);
            } else if (actionEvent.getSource() == this.showBtn) {
                this.searchTF.setEnabled(!this.showBtn.isSelected());
                this.hideBtn.setEnabled(!this.showBtn.isSelected());
                if (this.showBtn.isSelected()) {
                    this.table.filter(this.searchTF.getText(), false);
                } else {
                    this.table.filter(null, false);
                }
            } else if (actionEvent.getSource() == this.hideBtn) {
                this.searchTF.setEnabled(!this.hideBtn.isSelected());
                this.showBtn.setEnabled(!this.hideBtn.isSelected());
                if (this.hideBtn.isSelected()) {
                    this.table.filter(this.searchTF.getText(), true);
                } else {
                    this.table.filter(null, false);
                }
            } else {
                System.err.println("Invalid source of event: " + actionEvent.getSource());
            }
        }
    }

    public void updatePauseBtn(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    Toolbar.this.pauseBtn.setIcon(Toolbar.this.pausedIcon);
                    Toolbar.this.pauseBtn.setText("Play");
                } else {
                    Toolbar.this.pauseBtn.setIcon(Toolbar.this.notPausedIcon);
                    Toolbar.this.pauseBtn.setText("Pause");
                }
            }
        });
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.ratioSearchBtns();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.ratioSearchBtns();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.ratioSearchBtns();
    }

    private void ratioSearchBtns() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = Toolbar.this.searchTF.getText();
                Toolbar.this.prevSearchBtn.setEnabled(string != null && !string.isEmpty());
                Toolbar.this.nextSearchBtn.setEnabled(string != null && !string.isEmpty());
                Toolbar.this.showBtn.setEnabled(string != null && !string.isEmpty());
                Toolbar.this.hideBtn.setEnabled(string != null && !string.isEmpty());
            }
        });
    }

    public static enum ComboBoxValues {
        NONE("None", AlarmGUIType.INACTIVE),
        PRIORITY3("Priority 3", AlarmGUIType.PRIORITY_3),
        PRIORITY2("Priority 2", AlarmGUIType.PRIORITY_2),
        PRIORITY1("Priority 1", AlarmGUIType.PRIORITY_1);

        public final String title;
        public final JLabel normalRenderer;
        public final JLabel selectedRenderer;
        private static int height;
        private static int width;

        private ComboBoxValues(String string2, AlarmGUIType alarmGUIType) {
            this.title = string2;
            this.normalRenderer = new JLabel(string2);
            this.normalRenderer.setBackground(alarmGUIType.backg);
            this.normalRenderer.setForeground(alarmGUIType.foreg);
            this.normalRenderer.setHorizontalAlignment(0);
            this.normalRenderer.setVerticalAlignment(0);
            this.normalRenderer.setOpaque(true);
            Font font = this.normalRenderer.getFont();
            Font font2 = font.deriveFont(font.getSize() * 80 / 100);
            this.normalRenderer.setFont(font2);
            this.selectedRenderer = new JLabel(string2);
            this.selectedRenderer.setBackground(alarmGUIType.foreg);
            this.selectedRenderer.setForeground(alarmGUIType.backg);
            this.selectedRenderer.setHorizontalAlignment(0);
            this.selectedRenderer.setVerticalAlignment(0);
            this.selectedRenderer.setFont(font2);
            this.selectedRenderer.setOpaque(true);
            this.selectedRenderer.setBorder(BorderFactory.createLineBorder(alarmGUIType.backg));
        }

        public static void initSizes() {
            for (ComboBoxValues comboBoxValues : ComboBoxValues.values()) {
                Font font = comboBoxValues.normalRenderer.getFont();
                FontMetrics fontMetrics = comboBoxValues.normalRenderer.getFontMetrics(font);
                int n = fontMetrics.getHeight() + 5;
                int n2 = fontMetrics.charsWidth(comboBoxValues.title.toCharArray(), 0, comboBoxValues.title.length()) + 10;
                ComboBoxValues.setHeight(n);
                ComboBoxValues.setWidth(n2);
            }
            Dimension dimension = new Dimension(ComboBoxValues.getWidth(), ComboBoxValues.getHeight());
            for (ComboBoxValues comboBoxValues : ComboBoxValues.values()) {
                comboBoxValues.normalRenderer.setPreferredSize(dimension);
                comboBoxValues.selectedRenderer.setPreferredSize(dimension);
                comboBoxValues.normalRenderer.setMinimumSize(dimension);
                comboBoxValues.selectedRenderer.setMinimumSize(dimension);
            }
            System.out.println(dimension);
        }

        public static int getHeight() {
            return height;
        }

        public static int getWidth() {
            return width;
        }

        private static void setHeight(int n) {
            if (n > height) {
                height = n;
            }
        }

        private static void setWidth(int n) {
            if (n > width) {
                width = n;
            }
        }

        static {
            height = 0;
            width = 0;
        }
    }

    public class ComboBoxRenderer
    implements ListCellRenderer {
        private JLabel selectedLabel = new JLabel();

        public ComboBoxRenderer() {
            this.selectedLabel.setOpaque(false);
            Dimension dimension = new Dimension(ComboBoxValues.getWidth(), ComboBoxValues.getHeight());
            this.selectedLabel.setMinimumSize(dimension);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n == -1) {
                ComboBoxValues comboBoxValues = (ComboBoxValues)((Object)object);
                this.selectedLabel.setText(comboBoxValues.title);
                this.selectedLabel.setBackground(comboBoxValues.normalRenderer.getBackground());
                this.selectedLabel.setForeground(comboBoxValues.normalRenderer.getForeground());
                return this.selectedLabel;
            }
            if (bl) {
                return ((ComboBoxValues)((Object)object)).selectedRenderer;
            }
            return ((ComboBoxValues)((Object)object)).normalRenderer;
        }
    }
}

