/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.table;

import alma.acsplugins.alarmsystem.gui.table.AlarmTableEntry;
import alma.acsplugins.alarmsystem.gui.table.AlarmsContainer;
import alma.alarmsystem.clients.CategoryClient;
import cern.laser.client.data.Alarm;
import java.util.Vector;

public class AlarmsReductionContainer
extends AlarmsContainer {
    private final Vector<String> indexWithReduction = new Vector();
    private CategoryClient categoryClient = null;

    public AlarmsReductionContainer(int n) {
        super(n);
    }

    public synchronized int size(boolean bl) {
        if (!bl) {
            return super.size();
        }
        return this.indexWithReduction.size();
    }

    @Override
    public synchronized void add(AlarmTableEntry alarmTableEntry) throws AlarmsContainer.AlarmContainerException {
        super.add(alarmTableEntry);
        this.addAlarm(alarmTableEntry);
    }

    private void addAlarm(AlarmTableEntry alarmTableEntry) {
        if (!alarmTableEntry.getStatus().isReduced()) {
            this.indexWithReduction.add(alarmTableEntry.getAlarmId());
        }
        this.hideReducedChildren(alarmTableEntry);
    }

    private void hideReducedChildren(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The entry can't be null");
        }
        if (this.categoryClient == null) {
            return;
        }
        Alarm[] alarmArray = null;
        try {
            if (alarmTableEntry.isNodeParent()) {
                alarmArray = this.categoryClient.getChildren(alarmTableEntry.getAlarmId(), true);
            } else if (alarmTableEntry.isMultiplicityParent()) {
                alarmArray = this.categoryClient.getChildren(alarmTableEntry.getAlarmId(), false);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Error getting children of " + alarmTableEntry.getAlarmId() + ": " + throwable.getMessage());
            throwable.printStackTrace();
            alarmArray = null;
        }
        if (alarmArray != null) {
            for (Alarm alarm : alarmArray) {
                System.out.println("\tchild " + alarm.getAlarmId());
                this.indexWithReduction.remove(alarm.getAlarmId());
            }
        }
    }

    public void setCategoryClient(CategoryClient categoryClient) {
        this.categoryClient = categoryClient;
    }

    public synchronized AlarmTableEntry get(int n, boolean bl) {
        if (!bl) {
            return super.get(n);
        }
        String string = this.indexWithReduction.get(n);
        AlarmTableEntry alarmTableEntry = this.get(string);
        if (alarmTableEntry == null) {
            throw new IllegalStateException("Inconsistent state of reduced container");
        }
        return alarmTableEntry;
    }

    @Override
    public synchronized void clear() {
        this.indexWithReduction.clear();
        super.clear();
    }

    @Override
    public synchronized void remove(AlarmTableEntry alarmTableEntry) throws AlarmsContainer.AlarmContainerException {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        int n = this.indexWithReduction.indexOf(alarmTableEntry.getAlarmId());
        if (n >= 0) {
            this.indexWithReduction.remove(n);
        }
        super.remove(alarmTableEntry);
    }

    @Override
    public synchronized AlarmTableEntry removeOldest() throws AlarmsContainer.AlarmContainerException {
        AlarmTableEntry alarmTableEntry = super.removeOldest();
        this.indexWithReduction.remove(alarmTableEntry.getAlarmId());
        return alarmTableEntry;
    }

    @Override
    public synchronized void replace(AlarmTableEntry alarmTableEntry) throws AlarmsContainer.AlarmContainerException {
        super.replace(alarmTableEntry);
        int n = this.indexWithReduction.indexOf(alarmTableEntry.getAlarmId());
        if (n >= 0) {
            String string = this.indexWithReduction.remove(n);
            this.indexWithReduction.insertElementAt(string, 0);
            if (alarmTableEntry.getStatus().isActive()) {
                this.hideReducedChildren(alarmTableEntry);
            } else {
                this.showActiveChildren(alarmTableEntry, n);
            }
        } else {
            this.addAlarm(alarmTableEntry);
        }
    }

    private void showActiveChildren(AlarmTableEntry alarmTableEntry, int n) {
        if (this.categoryClient == null) {
            return;
        }
        Alarm[] alarmArray = null;
        try {
            if (alarmTableEntry.isMultiplicityParent()) {
                alarmArray = this.categoryClient.getActiveChildren(alarmTableEntry.getAlarmId(), false);
            } else if (alarmTableEntry.isNodeParent()) {
                alarmArray = this.categoryClient.getActiveChildren(alarmTableEntry.getAlarmId(), true);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Error getting children of " + alarmTableEntry.getAlarmId() + ": " + throwable.getMessage());
            throwable.printStackTrace();
            alarmArray = null;
        }
        if (alarmArray != null) {
            for (Alarm alarm : alarmArray) {
                AlarmTableEntry alarmTableEntry2 = this.get(alarm.getAlarmId());
                if (alarmTableEntry2 == null || this.indexWithReduction.indexOf(alarm.getAlarmId()) >= 0) continue;
                this.indexWithReduction.add(alarm.getAlarmId());
            }
        }
    }

    public CategoryClient getCategoryClient() {
        return this.categoryClient;
    }

    public synchronized int hasNotAckAlarms(boolean bl) {
        if (!bl) {
            return super.hasNotAckAlarms();
        }
        int n = Integer.MAX_VALUE;
        for (String string : this.indexWithReduction) {
            AlarmTableEntry alarmTableEntry = this.get(string);
            if (alarmTableEntry.isNew() && alarmTableEntry.getPriority() < n) {
                n = alarmTableEntry.getPriority();
            }
            if (n != 0) continue;
            break;
        }
        return n == Integer.MAX_VALUE ? -1 : n;
    }
}

