/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.table;

import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableEntry;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class AlarmsContainer {
    private HashMap<String, AlarmTableEntry> entries = new HashMap();
    private final Vector<String> index = new Vector();
    private final int maxAlarms;

    public AlarmsContainer(int n) {
        this.maxAlarms = n;
    }

    public synchronized int size() {
        return this.index.size();
    }

    public synchronized void add(AlarmTableEntry alarmTableEntry) throws AlarmContainerException {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The entry can't be null");
        }
        if (alarmTableEntry.getAlarmId() == null || alarmTableEntry.getAlarmId().length() == 0) {
            throw new IllegalStateException("The alarm ID is invalid");
        }
        if (this.index.size() >= this.maxAlarms) {
            throw new ArrayIndexOutOfBoundsException("Container full");
        }
        if (this.entries.containsKey(alarmTableEntry.getAlarmId())) {
            throw new AlarmContainerException("Alarm already in the Container");
        }
        if (this.index.contains(alarmTableEntry.getAlarmId())) {
            throw new IllegalStateException("Inconsistency between index and entries");
        }
        this.index.add(alarmTableEntry.getAlarmId());
        this.entries.put(alarmTableEntry.getAlarmId(), alarmTableEntry);
    }

    public synchronized boolean contains(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The ID can't be null");
        }
        return this.entries.containsKey(string);
    }

    public synchronized AlarmTableEntry get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The position must be greater then 0");
        }
        if (n > this.index.size()) {
            throw new IndexOutOfBoundsException("Can't acces item at pos " + n + ": [0," + this.index.size() + "]");
        }
        String string = this.index.get(n);
        AlarmTableEntry alarmTableEntry = this.get(string);
        if (alarmTableEntry == null) {
            throw new IllegalStateException("Inconsistent state of container");
        }
        return alarmTableEntry;
    }

    public synchronized AlarmTableEntry get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The ID can't be null");
        }
        return this.entries.get(string);
    }

    public synchronized void clear() {
        this.index.clear();
        this.entries.clear();
    }

    public synchronized AlarmTableEntry removeOldest() throws AlarmContainerException {
        if (this.index.size() == 0) {
            throw new AlarmContainerException("The container is empty");
        }
        String string = this.index.remove(0);
        if (string == null) {
            throw new IllegalStateException("The index vector returned a null item");
        }
        AlarmTableEntry alarmTableEntry = this.entries.remove(string);
        if (alarmTableEntry == null) {
            throw new IllegalStateException("The entries  HashMap contains a null entry");
        }
        return alarmTableEntry;
    }

    public synchronized void remove(AlarmTableEntry alarmTableEntry) throws AlarmContainerException {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        String string = alarmTableEntry.getAlarmId();
        int n = this.index.indexOf(string);
        if (n < 0) {
            throw new AlarmContainerException("Alarm not in the container");
        }
        this.index.remove(n);
        AlarmTableEntry alarmTableEntry2 = this.entries.remove(string);
        if (alarmTableEntry2 == null) {
            throw new IllegalStateException("The ID was in index but not in entries");
        }
    }

    public synchronized int removeInactiveAlarms(AlarmGUIType alarmGUIType) throws AlarmContainerException {
        if (alarmGUIType == null) {
            throw new IllegalArgumentException("The type can't be null");
        }
        Vector<String> vector = new Vector<String>();
        for (String object : this.entries.keySet()) {
            vector.add(new String(object));
        }
        int n = 0;
        for (String string : vector) {
            AlarmTableEntry alarmTableEntry = this.entries.get(string);
            if (alarmTableEntry == null) {
                throw new IllegalStateException("Got a null alarm for key " + string);
            }
            if (alarmTableEntry.getStatus().isActive() || alarmGUIType != AlarmGUIType.INACTIVE && alarmTableEntry.getPriority() != alarmGUIType.id) continue;
            this.remove(alarmTableEntry);
            ++n;
        }
        return n;
    }

    public synchronized void replace(AlarmTableEntry alarmTableEntry) throws AlarmContainerException {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        int n = this.index.indexOf(alarmTableEntry.getAlarmId());
        if (n < 0) {
            throw new AlarmContainerException("Entry not present in the container");
        }
        AlarmTableEntry alarmTableEntry2 = this.entries.get(alarmTableEntry.getAlarmId());
        if (alarmTableEntry2 == null) {
            throw new IllegalStateException("Inconsistent state of index and entries");
        }
        alarmTableEntry2.updateAlarm(alarmTableEntry);
        if (alarmTableEntry.getStatus().isActive()) {
            String string = this.index.remove(n);
            this.index.insertElementAt(string, 0);
        }
    }

    public synchronized int hasNotAckAlarms() {
        int n = Integer.MAX_VALUE;
        Set<String> set = this.entries.keySet();
        for (String string : set) {
            AlarmTableEntry alarmTableEntry = this.entries.get(string);
            if (alarmTableEntry.isNew() && alarmTableEntry.getPriority() < n) {
                n = alarmTableEntry.getPriority();
            }
            if (n != 0) continue;
            break;
        }
        return n == Integer.MAX_VALUE ? -1 : n;
    }

    public class AlarmContainerException
    extends Exception {
        public AlarmContainerException() {
        }

        public AlarmContainerException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public AlarmContainerException(String string) {
            super(string);
        }

        public AlarmContainerException(Throwable throwable) {
            super(throwable);
        }
    }
}

