/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.table;

import alma.acs.util.IsoDateFormat;
import alma.acsplugins.alarmsystem.gui.ConnectionListener;
import alma.acsplugins.alarmsystem.gui.table.AlarmCounter;
import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableEntry;
import alma.acsplugins.alarmsystem.gui.table.AlarmsReductionContainer;
import alma.acsplugins.alarmsystem.gui.toolbar.Toolbar;
import alma.alarmsystem.clients.CategoryClient;
import cern.laser.client.data.Alarm;
import cern.laser.client.services.selection.AlarmSelectionListener;
import cern.laser.client.services.selection.LaserSelectionException;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class AlarmTableModel
extends AbstractTableModel
implements AlarmSelectionListener,
Runnable {
    private SimpleDateFormat dateFormat = new IsoDateFormat();
    private HashMap<AlarmGUIType, AlarmCounter> counters = new HashMap();
    private ConnectionListener connectionListener = null;
    private LinkedBlockingQueue<AlarmTableEntry> queue = new LinkedBlockingQueue(15000);
    private Semaphore paused = new Semaphore(1);
    private volatile boolean terminateThread = false;
    private final Thread thread;
    public static final int MAX_ALARMS = 20000;
    public static final int QUEUE_SIZE = 15000;
    private boolean waitIfQueueFull = false;
    private JComponent owner;
    private AlarmsReductionContainer items = null;
    private boolean applyReductionRules;
    private Toolbar.ComboBoxValues autoAckLvl = Toolbar.ComboBoxValues.NONE;

    public AlarmTableModel(JComponent jComponent, boolean bl) {
        if (jComponent == null) {
            throw new IllegalArgumentException("The owner component can't be null");
        }
        this.owner = jComponent;
        this.applyReductionRules = bl;
        this.items = new AlarmsReductionContainer(20000);
        for (AlarmGUIType alarmGUIType : AlarmGUIType.values()) {
            this.counters.put(alarmGUIType, new AlarmCounter());
        }
        this.thread = new Thread((Runnable)this, "AlarmTableModel");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void onAlarm(Alarm alarm) {
        AlarmTableEntry alarmTableEntry = new AlarmTableEntry(alarm);
        if (this.waitIfQueueFull) {
            while (!this.terminateThread) {
                try {
                    this.queue.put(alarmTableEntry);
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        } else {
            this.queue.offer(alarmTableEntry);
        }
    }

    private void addAlarm(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        if (!alarmTableEntry.getStatus().isActive()) {
            return;
        }
        try {
            this.items.add(alarmTableEntry);
        }
        catch (Exception exception) {
            System.err.println("Error adding an alarm: " + exception.getMessage());
            exception.printStackTrace(System.err);
            JOptionPane.showInternalMessageDialog(this.owner, exception.getMessage(), "Error adding alarm", 0);
            return;
        }
        this.counters.get((Object)alarmTableEntry.getAlarmType()).incCounter();
    }

    private void autoAcknowledge(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        if (alarmTableEntry.getStatus().isActive()) {
            throw new IllegalArgumentException("Trying to acknowledge an active alarm");
        }
        if (this.autoAckLvl == Toolbar.ComboBoxValues.NONE) {
            return;
        }
        int n = 999999;
        switch (this.autoAckLvl) {
            case PRIORITY1: {
                n = 1;
                break;
            }
            case PRIORITY2: {
                n = 2;
                break;
            }
            case PRIORITY3: {
                n = 3;
            }
        }
        if (alarmTableEntry.getPriority() >= n) {
            this.acknowledge(alarmTableEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acknowledge(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        if (alarmTableEntry.getStatus().isActive()) {
            throw new IllegalArgumentException("Trying to acknowledge an active alarm");
        }
        try {
            AlarmsReductionContainer alarmsReductionContainer = this.items;
            synchronized (alarmsReductionContainer) {
                this.items.remove(alarmTableEntry);
            }
        }
        catch (Exception exception) {
            System.err.println("Error removing an alarm: " + exception.getMessage());
            exception.printStackTrace(System.err);
            JOptionPane.showInternalMessageDialog(this.owner, exception.getMessage(), "Error removing alarm", 0);
            return;
        }
        this.counters.get((Object)AlarmGUIType.fromAlarm(alarmTableEntry)).decCounter();
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAlarm(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        AlarmTableEntry alarmTableEntry2 = this.items.get(alarmTableEntry.getAlarmId());
        AlarmGUIType alarmGUIType = alarmTableEntry2.getAlarmType();
        boolean bl = alarmTableEntry2.getStatus().isActive();
        try {
            AlarmsReductionContainer alarmsReductionContainer = this.items;
            synchronized (alarmsReductionContainer) {
                this.items.replace(alarmTableEntry);
            }
        }
        catch (Exception exception) {
            System.err.println("Error replacing an alarm: " + exception.getMessage());
            exception.printStackTrace(System.err);
            JOptionPane.showInternalMessageDialog(this.owner, exception.getMessage(), "Error replacing alarm", 0);
            return;
        }
        if (bl == alarmTableEntry.getStatus().isActive()) {
            return;
        }
        this.counters.get((Object)alarmTableEntry2.getAlarmType()).incCounter();
        this.counters.get((Object)alarmGUIType).decCounter();
        if (!alarmTableEntry.getStatus().isActive()) {
            this.autoAcknowledge(alarmTableEntry);
        }
    }

    public void onException(LaserSelectionException laserSelectionException) {
        if (this.connectionListener == null) {
            System.err.println("Exception: " + laserSelectionException.getCode());
            return;
        }
        if (laserSelectionException.getCode().equals("HEARTBEAT_LOST")) {
            this.connectionListener.heartbeatLost();
        } else if (laserSelectionException.getCode().equals("HEARTBEAT_RECONNECTED")) {
            this.connectionListener.connected();
        } else if (laserSelectionException.getCode().equals("CONNECTION_DROPPED")) {
            this.connectionListener.disconnected();
        } else if (laserSelectionException.getCode().equals("CONNECTION_REESTABILISHED")) {
            this.connectionListener.connected();
        } else {
            System.err.println("Exception: " + laserSelectionException.getCode());
            laserSelectionException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        AlarmsReductionContainer alarmsReductionContainer = this.items;
        synchronized (alarmsReductionContainer) {
            return this.items.size(this.applyReductionRules);
        }
    }

    @Override
    public int getColumnCount() {
        return AlarmTableColumn.values().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmTableEntry getAlarmAt(int n) {
        AlarmTableEntry alarmTableEntry;
        if (n < 0) {
            return null;
        }
        AlarmsReductionContainer alarmsReductionContainer = this.items;
        synchronized (alarmsReductionContainer) {
            alarmTableEntry = this.items.get(n, this.applyReductionRules);
        }
        return alarmTableEntry;
    }

    public Object getCellContent(int n, int n2) {
        AlarmTableEntry alarmTableEntry = this.getAlarmAt(n);
        AlarmTableColumn alarmTableColumn = AlarmTableColumn.values()[n2];
        switch (alarmTableColumn) {
            case TIME: {
                return this.dateFormat.format(alarmTableEntry.getStatus().getSourceTimestamp());
            }
            case COMPONENT: {
                return alarmTableEntry.getTriplet().getFaultMember();
            }
            case CODE: {
                return alarmTableEntry.getTriplet().getFaultCode();
            }
            case PRIORITY: {
                int n3 = alarmTableEntry.getPriority();
                return new Priority(n3, alarmTableEntry.getAlarmType());
            }
            case DESCRIPTION: {
                return alarmTableEntry.getProblemDescription();
            }
            case CAUSE: {
                return alarmTableEntry.getCause();
            }
            case ACTION: {
                return alarmTableEntry.getAction();
            }
            case CONSEQUENCE: {
                return alarmTableEntry.getConsequence();
            }
            case GSM: {
                return alarmTableEntry.getResponsiblePerson().getGsmNumber();
            }
            case CONTACT: {
                return alarmTableEntry.getResponsiblePerson().getFirstName();
            }
            case EMAIL: {
                return alarmTableEntry.getResponsiblePerson().getEMail();
            }
            case URL: {
                return alarmTableEntry.getHelpURL();
            }
            case TRIPLET: {
                return "[" + alarmTableEntry.getTriplet().getFaultFamily() + ", " + alarmTableEntry.getTriplet().getFaultMember() + ", " + alarmTableEntry.getTriplet().getFaultCode() + "]";
            }
            case FAMILY: {
                return alarmTableEntry.getTriplet().getFaultFamily();
            }
        }
        return "N/A";
    }

    public void setAutoAckLevel(Toolbar.ComboBoxValues comboBoxValues) {
        if (comboBoxValues == null) {
            throw new IllegalArgumentException("The level can't be null");
        }
        this.autoAckLvl = comboBoxValues;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getCellContent(n, n2);
    }

    @Override
    public String getColumnName(int n) {
        return AlarmTableColumn.values()[n].title;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == AlarmTableColumn.PRIORITY.ordinal()) {
            return Priority.class;
        }
        return super.getColumnClass(n);
    }

    public AlarmTableEntry getRowAlarm(int n) {
        return this.getRowEntry(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlarmTableEntry getRowEntry(int n) {
        AlarmsReductionContainer alarmsReductionContainer = this.items;
        synchronized (alarmsReductionContainer) {
            if (n < 0 || n >= this.items.size(this.applyReductionRules)) {
                throw new IllegalArgumentException("Invalid row: " + n + " not in [0," + this.items.size(this.applyReductionRules) + "[");
            }
            return this.items.get(n, this.applyReductionRules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowAlarmNew(int n) {
        AlarmsReductionContainer alarmsReductionContainer = this.items;
        synchronized (alarmsReductionContainer) {
            if (n < 0 || n >= this.items.size(this.applyReductionRules)) {
                throw new IllegalArgumentException("Invalid row: " + n + " not in [0," + this.items.size(this.applyReductionRules) + "[");
            }
            return this.items.get(n, this.applyReductionRules).isNew();
        }
    }

    public AlarmCounter getAlarmCounter(AlarmGUIType alarmGUIType) {
        if (alarmGUIType == null) {
            throw new IllegalArgumentException("The alarm type can't be null");
        }
        AlarmCounter alarmCounter = this.counters.get((Object)alarmGUIType);
        if (alarmCounter == null) {
            throw new IllegalStateException("A counter for the type " + (Object)((Object)alarmGUIType) + "does not exist");
        }
        return alarmCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarmSelected(int n) {
        AlarmsReductionContainer alarmsReductionContainer = this.items;
        synchronized (alarmsReductionContainer) {
            this.items.get(n, this.applyReductionRules).alarmSeen();
        }
        this.fireTableRowsUpdated(n, n);
    }

    public synchronized void removeInactiveAlarms(AlarmGUIType alarmGUIType) {
        if (alarmGUIType == null) {
            throw new IllegalArgumentException("The type can't be null");
        }
        System.out.println("removing inactive alarms of type " + (Object)((Object)alarmGUIType));
        int n = 0;
        try {
            n = this.items.removeInactiveAlarms(alarmGUIType);
        }
        catch (Exception exception) {
            System.out.println("Error removing inactive alarms " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.counters.get((Object)AlarmGUIType.INACTIVE).decCounter();
            }
            this.fireTableDataChanged();
        }
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public void applyReductions(boolean bl) {
        this.applyReductionRules = bl;
        this.fireTableDataChanged();
    }

    public void setCategoryClient(CategoryClient categoryClient) {
        this.items.setCategoryClient(categoryClient);
    }

    public CategoryClient getCategoryClient() {
        return this.items.getCategoryClient();
    }

    public synchronized void clear() {
        this.items.clear();
    }

    public void pause(boolean bl) {
        if (bl) {
            while (!this.terminateThread) {
                try {
                    this.paused.acquire();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        } else {
            this.paused.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminateThread) {
            AlarmTableEntry alarmTableEntry;
            try {
                alarmTableEntry = this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            try {
                this.paused.acquire();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            this.paused.release();
            AlarmsReductionContainer alarmsReductionContainer = this.items;
            synchronized (alarmsReductionContainer) {
                if (this.items.size(this.applyReductionRules) == 20000 && !this.items.contains(alarmTableEntry.getAlarmId())) {
                    AlarmTableEntry alarmTableEntry2 = null;
                    try {
                        alarmTableEntry2 = this.items.removeOldest();
                    }
                    catch (Exception exception) {
                        System.err.println("Error removing the oldest alarm: " + exception.getMessage());
                        exception.printStackTrace(System.err);
                        JOptionPane.showInternalMessageDialog(this.owner, exception.getMessage(), "Error removing the oldest alarm", 0);
                        return;
                    }
                    this.counters.get((Object)alarmTableEntry2.getAlarmType()).decCounter();
                }
                if (this.items.contains(alarmTableEntry.getAlarmId())) {
                    this.replaceAlarm(alarmTableEntry);
                } else {
                    this.addAlarm(alarmTableEntry);
                }
            }
            this.fireTableDataChanged();
        }
    }

    public void close() {
        this.terminateThread = true;
        this.thread.interrupt();
    }

    public int hasNotAckAlarms() {
        return this.items.hasNotAckAlarms(this.applyReductionRules);
    }

    public class Priority
    implements Comparable<Priority> {
        public final int priority;
        public final AlarmGUIType type;

        public Priority(int n, AlarmGUIType alarmGUIType) {
            this.priority = n;
            this.type = alarmGUIType;
        }

        public String toString() {
            return PriorityLabel.fromPriorityNumber(this.priority).toString();
        }

        @Override
        public int compareTo(Priority priority) {
            boolean bl;
            if (priority == null) {
                throw new NullPointerException();
            }
            if (this.priority == priority.priority && this.type == priority.type) {
                return 0;
            }
            boolean bl2 = this.type != AlarmGUIType.INACTIVE;
            boolean bl3 = bl = priority.type != AlarmGUIType.INACTIVE;
            if (bl2 == bl) {
                Integer n = this.priority;
                return n.compareTo(priority.priority);
            }
            if (bl2) {
                return -1;
            }
            return 1;
        }
    }

    public static enum PriorityLabel {
        VERY_HIGH("VERY HIGH", Color.red),
        HIGH("HIGH", new Color(255, 165, 31)),
        MEDIUM("MEDIUM", Color.yellow),
        LOW("LOW", new Color(188, 255, 188));

        public final String description;
        public final Color color;

        private PriorityLabel(String string2, Color color) {
            this.description = string2;
            this.color = color;
        }

        public String toString() {
            return this.description;
        }

        public static PriorityLabel fromPriorityNumber(int n) {
            switch (n) {
                case 0: {
                    return VERY_HIGH;
                }
                case 1: {
                    return HIGH;
                }
                case 2: {
                    return MEDIUM;
                }
                case 3: {
                    return LOW;
                }
            }
            throw new IndexOutOfBoundsException("Invalid priority");
        }

        public static String fromPriorityDesc(int n) {
            return PriorityLabel.fromPriorityNumber((int)n).description;
        }
    }

    public static enum AlarmTableColumn {
        HIDES_CHILDREN("", "Parent node flag", true),
        REDUCED("", "Reduced flag", true),
        ICON("", "Not acknowledged flag", true),
        TIME("Time", null, true),
        COMPONENT("Component", null, true),
        FAMILY("Family", null, true),
        CODE("Code", null, false),
        CAUSE("Cause", null, true),
        DESCRIPTION("Description", null, true),
        ACTION("Action", null, true),
        PRIORITY("Priority", null, true),
        CONSEQUENCE("Consequence", null, false),
        URL("URL", null, false),
        CONTACT("Contact", null, false),
        EMAIL("email", null, false),
        GSM("GSM", null, false),
        TRIPLET("Triplet", null, false);

        public final String title;
        public final String popupTitle;
        public boolean visibleAtStartup;

        private AlarmTableColumn(String string2, String string3, boolean bl) {
            this.title = string2;
            this.popupTitle = string3 == null ? string2 : string3;
            this.visibleAtStartup = bl;
        }
    }
}

