/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.table;

import alma.acsplugins.alarmsystem.gui.table.AlarmTableEntry;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public enum AlarmGUIType {
    PRIORITY_0(Color.white, Color.red, "Priority 0", "flag_red.png"),
    PRIORITY_1(Color.black, new Color(255, 165, 31), "Priority 1", "flag_orange.png"),
    PRIORITY_2(Color.black, Color.yellow, "Priority 2", "flag_light_yellow.png"),
    PRIORITY_3(Color.black, new Color(255, 255, 198), "Priority 3", "flag_yellow.png"),
    INACTIVE(Color.black, new Color(188, 255, 188), "Inactive", "flag_green.png");

    public static final String iconFolder = "/alma/acsplugins/alarmsystem/gui/resources/";
    public final Color backg;
    public final Color foreg;
    public final String tile;
    public final int id;
    public final JLabel flagRenderer;

    private AlarmGUIType(Color color, Color color2, String string2, String string3) {
        this.backg = color2;
        this.foreg = color;
        this.tile = string2;
        this.id = this.ordinal();
        ImageIcon imageIcon = string3 != null ? new ImageIcon(((Object)((Object)this)).getClass().getResource(iconFolder + string3)) : null;
        this.flagRenderer = new JLabel(imageIcon, 0);
    }

    public static AlarmGUIType fromID(int n) {
        if (n < 0 || n >= AlarmGUIType.values().length) {
            throw new IllegalArgumentException("Invalid id " + n);
        }
        return AlarmGUIType.values()[n];
    }

    public static AlarmGUIType fromAlarm(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("A null alarm can't have type!");
        }
        if (!alarmTableEntry.getStatus().isActive()) {
            return INACTIVE;
        }
        switch (alarmTableEntry.getPriority()) {
            case 0: {
                return PRIORITY_0;
            }
            case 1: {
                return PRIORITY_1;
            }
            case 2: {
                return PRIORITY_2;
            }
            case 3: {
                return PRIORITY_3;
            }
        }
        throw new IllegalStateException("Inavlid priority from alarm: " + alarmTableEntry.getPriority());
    }

    public String toString() {
        return this.tile;
    }
}

