/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.statusline;

import alma.acsplugins.alarmsystem.gui.CernSysPanel;
import alma.acsplugins.alarmsystem.gui.ConnectionListener;
import alma.acsplugins.alarmsystem.gui.statusline.ConnectionWidget;
import alma.acsplugins.alarmsystem.gui.statusline.CounterWidget;
import alma.acsplugins.alarmsystem.gui.statusline.StatusMessageTF;
import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StatusLine
extends JPanel
implements ActionListener,
ConnectionListener {
    private CounterWidget[] counters = new CounterWidget[AlarmGUIType.values().length];
    private final AlarmTableModel tableModel;
    private final CernSysPanel alarmPanel;
    private final Timer timer;
    private static final int TIMER_INTERVAL = 2000;
    private ConnectionWidget connectionWidget;
    private final StatusMessageTF statusMessageLbl = new StatusMessageTF();

    public StatusLine(AlarmTableModel alarmTableModel, CernSysPanel cernSysPanel) {
        if (alarmTableModel == null) {
            throw new IllegalArgumentException("The AlarmTableModel can't be null");
        }
        if (cernSysPanel == null) {
            throw new IllegalArgumentException("The AlarmPanel can't be null");
        }
        this.alarmPanel = cernSysPanel;
        this.tableModel = alarmTableModel;
        this.initialize();
        this.timer = new Timer(2000, this);
        this.timer.setRepeats(true);
        this.timer.addActionListener(this);
        this.connectionWidget.setConnectionState(ConnectionWidget.ConnectionStatus.DISCONNECTED);
    }

    private void initialize() {
        BoxLayout boxLayout = new BoxLayout(this, 2);
        this.setLayout(boxLayout);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = new CounterWidget(AlarmGUIType.values()[i], this.tableModel.getAlarmCounter(AlarmGUIType.values()[i]), this.tableModel);
            jPanel.add(this.counters[i].getComponent());
        }
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.add(this.statusMessageLbl);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.connectionWidget = new ConnectionWidget(this.alarmPanel);
        jPanel3.add(this.connectionWidget);
        this.add(jPanel3);
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public void pause() {
        this.timer.stop();
    }

    public void resume() {
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            for (CounterWidget counterWidget : this.counters) {
                counterWidget.update();
            }
        }
    }

    @Override
    public void connected() {
        this.connectionWidget.setConnectionState(ConnectionWidget.ConnectionStatus.CONNECTED);
    }

    @Override
    public void connecting() {
        this.connectionWidget.setConnectionState(ConnectionWidget.ConnectionStatus.CONNECTING);
    }

    @Override
    public void disconnected() {
        this.connectionWidget.setConnectionState(ConnectionWidget.ConnectionStatus.DISCONNECTED);
    }

    @Override
    public void heartbeatLost() {
        this.connectionWidget.setConnectionState(ConnectionWidget.ConnectionStatus.HEARTBEAT_LOST);
    }

    public void showMessage(String string, boolean bl) {
        this.statusMessageLbl.showMessage(string, bl);
    }
}

