/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.statusline;

import alma.acsplugins.alarmsystem.gui.table.AlarmCounter;
import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import cern.laser.client.data.Alarm;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CounterWidget
implements ActionListener {
    private final JTextField widget;
    private final AlarmGUIType alarmType;
    private final AlarmCounter counter;
    private AlarmTableModel alarmModel;
    private JPopupMenu statusLinePM = new JPopupMenu();
    private JMenuItem popupMI;

    public CounterWidget(AlarmGUIType alarmGUIType, AlarmCounter alarmCounter, AlarmTableModel alarmTableModel) {
        if (alarmGUIType == null) {
            throw new IllegalArgumentException("The type can't be null");
        }
        if (alarmCounter == null) {
            throw new IllegalArgumentException("The AlarmCounter can't be null");
        }
        if (alarmTableModel == null) {
            throw new IllegalArgumentException("The AlarmTableModel can't be null");
        }
        this.alarmType = alarmGUIType;
        this.counter = alarmCounter;
        this.alarmModel = alarmTableModel;
        int n = Integer.valueOf(20000).toString().length();
        this.widget = new JTextField(n);
        this.widget.setHorizontalAlignment(0);
        this.widget.setForeground(this.alarmType.foreg);
        this.widget.setBackground(this.alarmType.backg);
        this.widget.setEditable(false);
        this.popupMI = new JMenuItem("Remove " + this.alarmType.tile + " alarms");
        this.statusLinePM.add(this.popupMI);
        this.widget.addMouseListener(new CounterWidgetMouseAdapter());
        this.popupMI.addActionListener(this);
        String string = "Num. of " + (Object)((Object)alarmGUIType);
        if (alarmGUIType != AlarmGUIType.INACTIVE) {
            string = string + " inactive";
        }
        string = string + " alarms";
        this.widget.setToolTipText(string);
    }

    public Component getComponent() {
        return this.widget;
    }

    public void update() {
        this.widget.setText(Integer.valueOf(this.counter.getCount()).toString());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.popupMI) {
            this.alarmModel.removeInactiveAlarms(this.alarmType);
        }
    }

    private class CounterWidgetMouseAdapter
    extends MouseAdapter {
        public Alarm selectedAlarm;

        private CounterWidgetMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            class ShowPopup
            extends Thread {
                MouseEvent e;

                public ShowPopup(MouseEvent mouseEvent) {
                    this.e = mouseEvent;
                }

                @Override
                public void run() {
                    CounterWidget.this.statusLinePM.show(CounterWidget.this.widget, this.e.getX(), this.e.getY());
                }
            }
            SwingUtilities.invokeLater(new ShowPopup(mouseEvent));
        }
    }
}

