/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.statusline;

import alma.acsplugins.alarmsystem.gui.CernSysPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class ConnectionWidget
extends JLabel
implements ActionListener {
    private JPopupMenu popMenu;
    private JMenuItem reconnectMI;
    private ConnectionStatus currentState;
    private CernSysPanel alarmPanel;

    public ConnectionWidget(CernSysPanel cernSysPanel) {
        if (cernSysPanel == null) {
            throw new IllegalArgumentException("The AlarmPanel can't be null");
        }
        this.alarmPanel = cernSysPanel;
        this.initialize();
        this.addMouseListener(new StatusLineMouseAdapter());
    }

    private void initialize() {
        this.popMenu = new JPopupMenu();
        this.reconnectMI = new JMenuItem("Reconnect");
        this.popMenu.add(this.reconnectMI);
        this.reconnectMI.addActionListener(this);
    }

    public void setConnectionState(ConnectionStatus connectionStatus) {
        if (connectionStatus == null) {
            throw new IllegalArgumentException("The state can't be null");
        }
        this.currentState = connectionStatus;
        class SetConnState
        extends Thread {
            public ConnectionStatus status;

            SetConnState() {
            }

            @Override
            public void run() {
                ConnectionWidget.this.setIcon(this.status.icon);
                ConnectionWidget.this.setToolTipText(this.status.tooltip);
            }
        }
        SetConnState setConnState = new SetConnState();
        setConnState.status = connectionStatus;
        SwingUtilities.invokeLater(setConnState);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.reconnectMI) {
            System.out.println("Reconnecting");
            class Reconnect
            extends Thread {
                Reconnect() {
                }

                @Override
                public void run() {
                    try {
                        ConnectionWidget.this.alarmPanel.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        ConnectionWidget.this.alarmPanel.connect();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Error connecting: " + throwable.getMessage());
                        throwable.printStackTrace(System.err);
                    }
                }
            }
            Reconnect reconnect = new Reconnect();
            reconnect.setName("Reconnect");
            reconnect.setDaemon(true);
            ((Thread)reconnect).run();
        }
    }

    public class StatusLineMouseAdapter
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            class ShowPopup
            extends Thread {
                MouseEvent e;

                public ShowPopup(MouseEvent mouseEvent) {
                    ConnectionWidget.this.reconnectMI.setEnabled(ConnectionWidget.this.currentState != ConnectionStatus.CONNECTED && !ConnectionWidget.this.alarmPanel.isConnecting());
                    this.e = mouseEvent;
                }

                @Override
                public void run() {
                    ConnectionWidget.this.popMenu.show(ConnectionWidget.this, this.e.getX(), this.e.getY());
                }
            }
            SwingUtilities.invokeLater(new ShowPopup(mouseEvent));
        }
    }

    public static enum ConnectionStatus {
        CONNECTED("Connected", "/console-connected.png"),
        CONNECTING("Connecting", "/console-connecting.png"),
        DISCONNECTED("Disconnected", "/console-disconnected.png"),
        HEARTBEAT_LOST("Alarm component down", "/console-delay.png");

        public final ImageIcon icon;
        public String tooltip;

        private ConnectionStatus(String string2, String string3) {
            this.icon = new ImageIcon(((Object)((Object)this)).getClass().getResource(string3));
            this.tooltip = string2;
        }
    }
}

