/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.reduced;

import alma.acsplugins.alarmsystem.gui.CernSysPanel;
import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import alma.acsplugins.alarmsystem.gui.table.AlarmTable;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableEntry;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import alma.acsplugins.alarmsystem.gui.tree.AlarmTree;
import alma.alarmsystem.clients.CategoryClient;
import cern.laser.client.data.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class ReducedChainDlg
extends JDialog
implements ActionListener {
    private final JButton closeBtn = new JButton("Close");
    private final JButton refreshBtn = new JButton("Refresh");
    private final AlarmTable table;
    private final AlarmTree tree = new AlarmTree();
    private final AlarmTableModel model;
    private final CernSysPanel panel;
    private final CategoryClient categoryClient;
    private AlarmTableEntry alarm;

    public ReducedChainDlg(CategoryClient categoryClient, AlarmTableEntry alarmTableEntry, CernSysPanel cernSysPanel) {
        if (categoryClient == null) {
            throw new IllegalArgumentException("The category client can't be null");
        }
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        if (cernSysPanel == null) {
            throw new IllegalArgumentException("The panel can't be null");
        }
        this.categoryClient = categoryClient;
        this.alarm = alarmTableEntry;
        this.panel = cernSysPanel;
        this.model = new AlarmTableModel(this.rootPane, false);
        this.table = new AlarmTable(this.model, cernSysPanel);
        this.initialize();
        this.refreshContent();
    }

    private void initialize() {
        this.setIconImage(new ImageIcon(AlarmGUIType.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/arrow_in.png")).getImage());
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(1);
        this.rootPane.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JScrollPane jScrollPane = new JScrollPane(20, 30);
        jScrollPane.setViewportView(this.table);
        this.table.addRemoveColumn(AlarmTableModel.AlarmTableColumn.ICON, false);
        jTabbedPane.addTab("Table view", jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane(20, 30);
        jScrollPane2.setViewportView(this.tree);
        jTabbedPane.addTab("Tree view", jScrollPane2);
        this.rootPane.add((Component)jTabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.add(this.refreshBtn);
        this.refreshBtn.addActionListener(this);
        this.refreshBtn.setEnabled(false);
        jPanel.add(this.closeBtn);
        this.closeBtn.addActionListener(this);
        this.rootPane.add((Component)jPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    public void close() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReducedChainDlg.this.setVisible(false);
                ReducedChainDlg.this.dispose();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeBtn) {
            this.close();
        } else if (actionEvent.getSource() == this.refreshBtn) {
            this.refreshContent();
        }
    }

    private void refreshContent() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                ReducedChainDlg.this.refreshBtn.setEnabled(true);
                ReducedChainDlg.this.model.clear();
                ReducedChainDlg.this.setTitle("Reduction chain of [" + ReducedChainDlg.this.alarm.getAlarmId() + "]");
                ReducedChainDlg.this.tree.clear(ReducedChainDlg.this.alarm);
                ReducedChainDlg.this.getAlarmChain(ReducedChainDlg.this.alarm, null);
                ReducedChainDlg.this.tree.expandRow(0);
                ReducedChainDlg.this.model.fireTableDataChanged();
            }
        };
        thread.setDaemon(true);
        thread.setName("ReducedchainDlg.refreshTableContent " + this.alarm.getAlarmId());
        thread.start();
    }

    private void getAlarmChain(Alarm alarm, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.model.onAlarm(alarm);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.tree.add(alarm, defaultMutableTreeNode);
        if (alarm != null) {
            Alarm[] alarmArray = null;
            try {
                alarmArray = alarm.isNodeParent() ? this.categoryClient.getChildren(alarm.getAlarmId(), true) : this.categoryClient.getChildren(alarm.getAlarmId(), false);
            }
            catch (Throwable throwable) {
                System.err.println("Error getting the children of " + this.alarm.getAlarmId());
                throwable.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this.table, "Error getting children of " + this.alarm.getAlarmId(), "Error getting alarms", 0);
                return;
            }
            if (alarmArray != null) {
                for (Alarm alarm2 : alarmArray) {
                    this.getAlarmChain(alarm2, defaultMutableTreeNode2);
                }
            }
        }
    }

    public void setRootAlarm(AlarmTableEntry alarmTableEntry) {
        if (alarmTableEntry == null) {
            throw new IllegalArgumentException("The alarm can't be null");
        }
        this.alarm = alarmTableEntry;
        this.refreshContent();
    }
}

