/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui.detail;

import alma.acs.util.IsoDateFormat;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import cern.laser.client.data.Alarm;
import cern.laser.client.data.ResponsiblePerson;
import cern.laser.client.data.Status;
import cern.laser.client.data.Triplet;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class AlarmDetailTable
extends JTable {
    private final AlarmDetailTableModel model = new AlarmDetailTableModel();
    private Alarm alarm = null;
    private Vector<String> propertyNames = null;
    private final JLabel renderer = new JLabel();

    public AlarmDetailTable() {
        this.setModel(this.model);
        this.initialize();
    }

    private void initialize() {
        this.setAutoResizeMode(3);
        this.setTitleColumnSize(null);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setHeaderValue("Field");
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        tableColumn2.setHeaderValue("Value");
    }

    private int setTitleColumnSize(Vector<String> vector) {
        BufferedImage bufferedImage = new BufferedImage(100, 100, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        for (RowTitles rowTitles : RowTitles.values()) {
            if (n >= fontMetrics.stringWidth(rowTitles.title)) continue;
            n = fontMetrics.stringWidth(rowTitles.title);
        }
        if (vector != null) {
            for (String string : vector) {
                if (n >= fontMetrics.stringWidth(string)) continue;
                n = fontMetrics.stringWidth(string);
            }
        }
        Object object = this.getColumnModel().getColumn(0);
        ((TableColumn)object).setPreferredWidth(n += 20);
        ((TableColumn)object).setMinWidth(n);
        ((TableColumn)object).setMaxWidth(n);
        ((TableColumn)object).setWidth(n);
        ((TableColumn)object).setResizable(false);
        object = this.getColumnModel().getColumn(1);
        ((TableColumn)object).setResizable(true);
        return n;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "Field";
        }
        return "Value";
    }

    public void showAlarmDetails(Alarm alarm) {
        this.alarm = alarm;
        Status status = alarm.getStatus();
        if (status == null) {
            this.propertyNames = null;
        } else {
            Properties properties = status.getUserProperties();
            if (properties == null || properties.isEmpty()) {
                this.propertyNames = null;
            } else {
                this.propertyNames = new Vector();
                Set<String> set = properties.stringPropertyNames();
                for (String string : set) {
                    this.propertyNames.add(string);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlarmDetailTable.this.setTitleColumnSize(AlarmDetailTable.this.propertyNames);
            }
        });
        this.model.fireTableDataChanged();
    }

    public class AlarmDetailTableModel
    extends AbstractTableModel {
        private SimpleDateFormat dateFormat = new IsoDateFormat();
        private final String blankStr = "";

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            Properties properties;
            int n = RowTitles.values().length;
            if (AlarmDetailTable.this.alarm != null && (properties = AlarmDetailTable.this.alarm.getStatus().getUserProperties()) != null) {
                n += properties.size();
            }
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (n < RowTitles.values().length) {
                    return RowTitles.values()[n].htmlTitle;
                }
                return AlarmDetailTable.this.propertyNames.get(n - RowTitles.values().length);
            }
            if (AlarmDetailTable.this.alarm == null) {
                return "";
            }
            if (n >= RowTitles.values().length) {
                String string = (String)AlarmDetailTable.this.propertyNames.get(n - RowTitles.values().length);
                return AlarmDetailTable.this.alarm.getStatus().getUserProperties().getProperty(string);
            }
            switch (RowTitles.values()[n]) {
                case COMPONENT: {
                    return AlarmDetailTable.this.alarm.getTriplet().getFaultMember();
                }
                case CAUSE: {
                    return AlarmDetailTable.this.alarm.getCause();
                }
                case DESCRIPTION: {
                    return AlarmDetailTable.this.alarm.getProblemDescription();
                }
                case ACTION: {
                    return AlarmDetailTable.this.alarm.getAction();
                }
                case CONSEQUENCE: {
                    return AlarmDetailTable.this.alarm.getConsequence();
                }
                case EMAIL: {
                    return AlarmDetailTable.this.alarm.getPiquetEmail();
                }
                case GSM: {
                    return AlarmDetailTable.this.alarm.getPiquetGSM();
                }
                case HOST: {
                    Status status = AlarmDetailTable.this.alarm.getStatus();
                    if (status != null) {
                        return status.getSourceHostname();
                    }
                    return "";
                }
                case ID: {
                    return AlarmDetailTable.this.alarm.getAlarmId();
                }
                case RESPONSIBLE: {
                    ResponsiblePerson responsiblePerson = AlarmDetailTable.this.alarm.getResponsiblePerson();
                    if (responsiblePerson != null) {
                        return responsiblePerson.getFirstName() + " " + responsiblePerson.getFamilyName();
                    }
                    return "";
                }
                case STATUS: {
                    Status status = AlarmDetailTable.this.alarm.getStatus();
                    if (status != null) {
                        if (status.isActive()) {
                            return "Active";
                        }
                        return "Cleared";
                    }
                    return "";
                }
                case TRIPLET: {
                    Triplet triplet = AlarmDetailTable.this.alarm.getTriplet();
                    if (triplet != null) {
                        StringBuilder stringBuilder = new StringBuilder("<");
                        stringBuilder.append(triplet.getFaultFamily());
                        stringBuilder.append(", ");
                        stringBuilder.append(triplet.getFaultMember());
                        stringBuilder.append(", ");
                        stringBuilder.append(triplet.getFaultCode());
                        stringBuilder.append(">");
                        return stringBuilder.toString();
                    }
                    return "Cleared";
                }
                case URL: {
                    return AlarmDetailTable.this.alarm.getHelpURL();
                }
                case PRIORITY: {
                    int n3 = AlarmDetailTable.this.alarm.getPriority();
                    return AlarmTableModel.PriorityLabel.fromPriorityNumber(n3);
                }
                case TIMESTAMP: {
                    return this.dateFormat.format(AlarmDetailTable.this.alarm.getStatus().getSourceTimestamp());
                }
                case FAMILY: {
                    return AlarmDetailTable.this.alarm.getTriplet().getFaultFamily();
                }
                case CODE: {
                    return AlarmDetailTable.this.alarm.getTriplet().getFaultCode();
                }
            }
            return "";
        }
    }

    public static enum RowTitles {
        COMPONENT("Component"),
        TIMESTAMP("Source timestamp "),
        CAUSE("Cause"),
        PRIORITY("Priority"),
        DESCRIPTION("Description"),
        ACTION("Action"),
        CONSEQUENCE("Consequence"),
        STATUS("Status"),
        HOST("Host"),
        URL("Help page:"),
        RESPONSIBLE("Contact"),
        EMAIL("Email"),
        GSM("GSM"),
        CODE("Code"),
        FAMILY("Family"),
        TRIPLET("Triplet"),
        ID("ID");

        private final String title;
        private final String htmlTitle;

        private RowTitles(String string2) {
            this.title = string2;
            this.htmlTitle = "<HTML><B>" + string2 + "</B></HTML>";
        }
    }
}

