/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui;

import alma.acs.container.ContainerServices;
import alma.acsplugins.alarmsystem.gui.AlSysNotAvailPanel;
import alma.acsplugins.alarmsystem.gui.AlarmPanel;
import alma.acsplugins.alarmsystem.gui.ConnectionListener;
import alma.acsplugins.alarmsystem.gui.detail.AlarmDetailTable;
import alma.acsplugins.alarmsystem.gui.sound.AlarmSound;
import alma.acsplugins.alarmsystem.gui.statusline.StatusLine;
import alma.acsplugins.alarmsystem.gui.table.AlarmTable;
import alma.acsplugins.alarmsystem.gui.table.AlarmTableModel;
import alma.acsplugins.alarmsystem.gui.toolbar.Toolbar;
import alma.alarmsystem.clients.CategoryClient;
import alma.maciErrType.wrappers.AcsJCannotGetComponentEx;
import cern.laser.client.data.Alarm;
import cern.laser.client.services.selection.AlarmSelectionListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class CernSysPanel
extends JPanel {
    private Toolbar toolbar;
    private StatusLine statusLine;
    public final boolean ACTIVATE_RDUCTION_RULES = true;
    private AlarmTableModel model;
    private AlarmTable alarmTable;
    private AlarmDetailTable detailTable;
    private AlarmSound alarmSound;
    private JScrollPane tableScrollPane = new JScrollPane(20, 30);
    private JScrollPane detailsScrollPane = new JScrollPane(20, 30);
    private JSplitPane splitPane;
    private final AlarmPanel alarmPanel;
    private volatile boolean connecting = false;
    private volatile boolean closed = false;
    private ConnectionListener connectionListener;
    private Thread connectThread;
    private Thread disconnectThread;
    private CategoryClient categoryClient = null;
    private ContainerServices contSvc = null;
    private final AlSysNotAvailPanel notAvaiPnl;

    public CernSysPanel(AlarmPanel alarmPanel, AlSysNotAvailPanel alSysNotAvailPanel) {
        if (alSysNotAvailPanel == null) {
            throw new IllegalArgumentException("AlSysNotAvailPanel can't be null");
        }
        this.alarmPanel = alarmPanel;
        this.notAvaiPnl = alSysNotAvailPanel;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.model = new AlarmTableModel(this, true);
        this.alarmSound = new AlarmSound(this.model);
        this.alarmTable = new AlarmTable(this.model, this);
        this.statusLine = new StatusLine(this.model, this);
        this.connectionListener = this.statusLine;
        this.model.setConnectionListener(this.statusLine);
        this.detailTable = new AlarmDetailTable();
        this.tableScrollPane.setViewportView(this.alarmTable);
        Dimension dimension = new Dimension(300, 150);
        this.tableScrollPane.setMinimumSize(dimension);
        this.tableScrollPane.setPreferredSize(dimension);
        this.detailsScrollPane.setViewportView(this.detailTable);
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel("Alarm details"));
        jPanel.add((Component)jPanel2, "First");
        jPanel.add((Component)this.detailsScrollPane, "Center");
        dimension = new Dimension(120, 150);
        jPanel.setMinimumSize(dimension);
        jPanel.setPreferredSize(dimension);
        this.splitPane = new JSplitPane(1, this.tableScrollPane, jPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(1.0);
        this.add((Component)this.splitPane, "Center");
        this.toolbar = new Toolbar(this.alarmTable, this.model, this.alarmSound, true, this);
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.statusLine, "South");
    }

    public void close() {
        this.alarmSound.close();
        this.model.close();
        this.alarmTable.close();
    }

    public void pause() throws Exception {
        this.model.pause(true);
        this.statusLine.pause();
        this.toolbar.updatePauseBtn(true);
    }

    public void resume() throws Exception {
        this.model.pause(false);
        this.statusLine.resume();
        this.toolbar.updatePauseBtn(false);
    }

    public void showMessage(String string, boolean bl) {
        this.statusLine.showMessage(string, bl);
    }

    public void showAlarmDetails(Alarm alarm) {
        this.detailTable.showAlarmDetails(alarm);
    }

    public synchronized void addSpecialAlarm(Alarm alarm) throws Exception {
        if (alarm == null || alarm.getAlarmId() == null || alarm.getAlarmId().isEmpty()) {
            throw new Exception("The alarm cant'be null and must have a valid ID!");
        }
        this.model.onAlarm(alarm);
    }

    public void setModel(AlarmTableModel alarmTableModel) {
        this.model = alarmTableModel;
    }

    public void connect() {
        if (this.connecting || this.closed) {
            return;
        }
        this.connecting = true;
        this.connectionListener.connecting();
        this.notAvaiPnl.addMessage("Connecting to the alarm service");
        this.notAvaiPnl.addMessage("Instantiating the category client");
        try {
            this.categoryClient = new CategoryClient(this.contSvc);
        }
        catch (Throwable throwable) {
            System.err.println("Error instantiating the CategoryClient: " + throwable.getMessage());
            this.notAvaiPnl.addMessage("Error instantiating the CategoryClient: " + throwable.getMessage());
            throwable.printStackTrace(System.err);
            this.connectionListener.disconnected();
            this.categoryClient = null;
            this.connecting = false;
            return;
        }
        while (!this.closed) {
            this.notAvaiPnl.addMessage("Connecting to the categories");
            try {
                this.categoryClient.connect((AlarmSelectionListener)this.model);
                this.notAvaiPnl.addMessage("CategoryClient connected");
                break;
            }
            catch (AcsJCannotGetComponentEx acsJCannotGetComponentEx) {
                for (int i = 0; i < 30; ++i) {
                    if (this.closed) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                acsJCannotGetComponentEx.printStackTrace();
            }
            catch (Throwable throwable) {
                System.err.println("Error connecting CategoryClient: " + throwable.getMessage() + ", " + throwable.getClass().getName());
                this.notAvaiPnl.addMessage("Error connecting CategoryClient: " + throwable.getMessage() + ", " + throwable.getClass().getName());
                throwable.printStackTrace(System.err);
                this.connectionListener.disconnected();
                this.connecting = false;
                return;
            }
        }
        if (this.closed) {
            this.model.setCategoryClient(null);
            return;
        }
        this.notAvaiPnl.addMessage("Connected to the alarm service");
        this.connecting = false;
        this.connectionListener.connected();
        this.statusLine.start();
        this.model.setCategoryClient(this.categoryClient);
        this.alarmPanel.showPanel("CERN_pnl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.statusLine.stop();
        this.model.setCategoryClient(null);
        while (this.connectThread != null && this.connectThread.isAlive()) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {}
        }
        try {
            this.categoryClient.close();
        }
        catch (Throwable throwable) {
            System.err.println("Error closinging CategoryClient: " + throwable.getMessage());
            throwable.printStackTrace(System.err);
        }
        finally {
            this.categoryClient = null;
            this.connectionListener.disconnected();
        }
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public void setContainerServices(ContainerServices containerServices) {
        if (containerServices == null) {
            throw new IllegalArgumentException("Invalid null ContainerServices");
        }
        this.contSvc = containerServices;
    }

    public void start() throws Exception {
        if (this.contSvc == null) {
            throw new Exception("ContainerServices not set");
        }
        this.closed = false;
        if (this.categoryClient == null) {
            class StartAlarmPanel
            extends Thread {
                StartAlarmPanel() {
                }

                @Override
                public void run() {
                    CernSysPanel.this.connect();
                }
            }
            this.connectThread = new StartAlarmPanel();
            this.connectThread.setName("StartAlarmPanel");
            this.connectThread.setDaemon(true);
            this.connectThread.start();
        }
    }

    public void stop() throws Exception {
        this.closed = true;
        class StopAlarmPanel
        extends Thread {
            StopAlarmPanel() {
            }

            @Override
            public void run() {
                try {
                    CernSysPanel.this.disconnect();
                }
                catch (Throwable throwable) {
                    System.err.println("Ignored error while disconnecting category client: " + throwable.getMessage());
                    throwable.printStackTrace(System.err);
                }
            }
        }
        this.disconnectThread = new StopAlarmPanel();
        this.disconnectThread.setName("StopAlarmPanel");
        this.disconnectThread.start();
        this.close();
    }
}

