/*
 * Decompiled with CFR 0.152.
 */
package alma.acsplugins.alarmsystem.gui;

import alma.acs.alarmsystem.corbaservice.AlarmServiceUtils;
import alma.acs.container.ContainerServices;
import alma.acs.container.ContainerServicesBase;
import alma.acs.gui.util.panel.IPanel;
import alma.acsplugins.alarmsystem.gui.AcsAlSysPanel;
import alma.acsplugins.alarmsystem.gui.AlSysNotAvailPanel;
import alma.acsplugins.alarmsystem.gui.CernSysPanel;
import alma.acsplugins.alarmsystem.gui.table.AlarmGUIType;
import cern.laser.client.data.Alarm;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AlarmPanel
extends JPanel
implements IPanel {
    private ContainerServices contSvc = null;
    private JFrame frame = null;
    private final CernSysPanel cernSysPnl;
    private AcsAlSysPanel acsASPnl = new AcsAlSysPanel();
    private AlSysNotAvailPanel alSysNotAvailPnl = new AlSysNotAvailPanel();
    private final CardLayout layout = new CardLayout();
    private final JPanel panel = new JPanel();
    public static final String alSysNotAvailName = "CERN_N/A_pnl";
    public static final String cernSysName = "CERN_pnl";
    public static final String acsASName = "ACS_pnl";
    private boolean isAcsAs;

    public AlarmPanel() {
        super(true);
        this.cernSysPnl = new CernSysPanel(this, this.alSysNotAvailPnl);
        this.initialize();
    }

    public AlarmPanel(JFrame jFrame) {
        super(true);
        if (jFrame == null) {
            throw new IllegalArgumentException("Invalid null frame in constructor");
        }
        this.frame = jFrame;
        this.frame.setIconImage(new ImageIcon(AlarmGUIType.class.getResource("/alma/acsplugins/alarmsystem/gui/resources/flag_red.png")).getImage());
        this.cernSysPnl = new CernSysPanel(this, this.alSysNotAvailPnl);
        this.initialize();
    }

    private void initialize() {
        this.panel.setLayout(this.layout);
        this.panel.add((Component)this.alSysNotAvailPnl, alSysNotAvailName);
        this.panel.add((Component)this.cernSysPnl, cernSysName);
        this.panel.add((Component)this.acsASPnl, acsASName);
        this.panel.setLayout(this.layout);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.showPanel(alSysNotAvailName);
    }

    public void pause() throws Exception {
        this.cernSysPnl.pause();
    }

    public void resume() throws Exception {
        this.cernSysPnl.resume();
    }

    public void start() throws Exception {
        if (this.contSvc == null) {
            throw new Exception("PluginContainerServices not set");
        }
        this.cernSysPnl.start();
    }

    public void stop() throws Exception {
        this.cernSysPnl.stop();
    }

    public void setServices(ContainerServices containerServices) {
        this.contSvc = containerServices;
        this.cernSysPnl.setContainerServices(this.contSvc);
        this.initAlarmServiceType();
    }

    public boolean runRestricted(boolean bl) throws Exception {
        return bl;
    }

    public void setACSContainerServices(ContainerServices containerServices) {
        if (containerServices == null) {
            throw new IllegalArgumentException("Invalid null ContainerServices");
        }
        this.contSvc = containerServices;
        this.cernSysPnl.setContainerServices(containerServices);
        this.initAlarmServiceType();
    }

    public boolean isOMCPlugin() {
        return this.frame == null;
    }

    public boolean isConnecting() {
        return this.cernSysPnl.isConnecting();
    }

    public synchronized void addSpecialAlarm(Alarm alarm) throws Exception {
        this.cernSysPnl.addSpecialAlarm(alarm);
    }

    public void showMessage(String string, boolean bl) {
        this.cernSysPnl.showMessage(string, bl);
    }

    public void showAlarmDetails(Alarm alarm) {
        this.cernSysPnl.showAlarmDetails(alarm);
    }

    private void initAlarmServiceType() {
        if (this.contSvc == null) {
            throw new IllegalStateException("The ContainerServices is still null!");
        }
        System.out.println("getAlarmServiceType");
        AlarmServiceUtils alarmServiceUtils = new AlarmServiceUtils((ContainerServicesBase)this.contSvc);
        boolean bl = false;
        try {
            bl = alarmServiceUtils.getAlarmServiceType();
        }
        catch (Throwable throwable) {
            System.err.println("Unable to get the alarm system type: " + throwable.getMessage());
            throwable.printStackTrace(System.err);
        }
        this.isAcsAs = bl;
        if (this.isAcsAs) {
            this.showPanel(acsASName);
        }
    }

    public void showPanel(final String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Invalid name of panel (null or empty name)");
        }
        boolean bl = false;
        if (string.equals(cernSysName) || string.equals(acsASName) || string.equals(alSysNotAvailName)) {
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("Panel name " + string + " NOT defined");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlarmPanel.this.layout.show(AlarmPanel.this.panel, string);
            }
        });
    }
}

