/*
 * Decompiled with CFR 0.152.
 */
package cern.cmw.mom.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Category;

public final class MomConfig {
    private static Properties cmwProperties = null;
    public static final String CONFIGURATION_PROPERTY = "cmw.mom.config";
    public static final String CONFIGURATION_PROPERTY_FILE = "cmw-mom-config.properties";
    public static final String CONFIGURATION_FILE = "cmw-mom.properties";
    public static final String CONNECTION_RETRY_PERIOD_PROPERTY = "cmw.mom.retry";
    public static final String CONNECTION_RETRY_NUMBER_PROPERTY = "cmw.mom.maxretry";
    public static final String CONNECTION_PING_INTERVAL_PROPERTY = "cmw.mom.ping";
    public static final String USERNAME_PROPERTY = "cmw.mom.username";
    public static final String PASSWORD_PROPERTY = "cmw.mom.password";
    public static final String BROKER_LIST_PROPERTY = "cmw.mom.brokerlist";
    public static final String LOAD_BALANCING_PROPERTY = "cmw.mom.loadbalancing";
    public static final String KEEP_ALIVE_PROPERTY = "cmw.mom.keepalive";
    public static final String MSG_PERSISTANCE_PROPERTY = "cmw.mom.persistance";
    public static final String MSG_PRIORITY_PROPERTY = "cmw.mom.priority";
    public static final String MSG_TIMETOLIVE_PROPERTY = "cmw.mom.timetolive";
    public static final String SEQUENTIAL_PROPERTY = "cmw.mom.sequential";
    public static final String SELECTOR_AT_BROKER_PROPERTY = "cmw.mom.selectoratbroker";
    public static final String NOTIFICATION_PROPERTY = "cmw.mom.notification";
    private static final String DEFAULT_CONNECTION_RETRY_PERIOD = "10";
    private static final String DEFAULT_CONNECTION_RETRY_NUMBER = "99999";
    private static final String DEFAULT_CONNECTION_PING_INTERVAL = "5";
    private static final String DEFAULT_USERNAME = "cmw_usr";
    private static final String DEFAULT_PASSWORD = "cmw_pwd";
    private static final String DEFAULT_BROKER_LIST = "sljas1:2506";
    private static final String DEFAULT_LOAD_BALANCING = "false";
    private static final String DEFAULT_KEEP_ALIVE = "0";
    private static final String DEFAULT_MSG_PERSISTANCE = "false";
    private static final String DEFAULT_MSG_PRIORITY = "4";
    private static final String DEFAULT_MSG_TIMETOLIVE = "60000";
    private static final String DEFAULT_SEQUENTIAL = "true";
    private static final String DEFAULT_SELECTOR_AT_BROKER = "false";
    private static final String DEFAULT_NOTIFICATION = "false";
    static Category cat = Category.getInstance((String)MomConfig.class.getName());

    public static synchronized Properties getProperties(ClassLoader classLoader) {
        if (cmwProperties == null) {
            InputStream inputStream;
            cat.info((Object)"loading configuration...");
            cmwProperties = new Properties();
            InputStream inputStream2 = null;
            try {
                cat.debug((Object)"attempting to load configuration from system property...");
                inputStream2 = MomConfig.getInputStream(classLoader, System.getProperty(CONFIGURATION_PROPERTY));
            }
            catch (Exception exception) {
                cat.debug((Object)("failed : " + exception.getMessage()));
            }
            if (inputStream2 == null) {
                cat.debug((Object)"failed");
                try {
                    cat.debug((Object)"attempting to load configuration from default config file...");
                    inputStream2 = MomConfig.getInputStream(classLoader, CONFIGURATION_FILE);
                }
                catch (Exception exception) {
                    cat.debug((Object)("failed : " + exception.getMessage()));
                }
                if (inputStream2 == null) {
                    cat.debug((Object)"failed");
                    try {
                        cat.debug((Object)"attempting to load configuration from property file...");
                        inputStream = MomConfig.getInputStream(classLoader, CONFIGURATION_PROPERTY_FILE);
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        inputStream2 = MomConfig.getInputStream(classLoader, properties.getProperty(CONFIGURATION_PROPERTY));
                    }
                    catch (Exception exception) {
                        cat.debug((Object)("failed : " + exception.getMessage()));
                    }
                }
            }
            if (inputStream2 != null) {
                try {
                    inputStream = new BufferedInputStream(inputStream2);
                    cmwProperties.load(inputStream);
                    inputStream2.close();
                    cat.info((Object)"configuration loaded");
                }
                catch (IOException iOException) {
                    cat.warn((Object)"could not load configuration, using defaults", (Throwable)iOException);
                }
            } else {
                cat.warn((Object)"could not load configuration, using defaults");
            }
            MomConfig.setProperties();
        }
        return cmwProperties;
    }

    private static InputStream getInputStream(ClassLoader classLoader, String string) throws IOException {
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            catch (Exception exception) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (Exception exception2) {
                    throw new IOException("unable to get the configuration");
                }
            }
        }
        return inputStream;
    }

    private static void setProperties() {
        cmwProperties.setProperty(CONNECTION_RETRY_PERIOD_PROPERTY, System.getProperty(CONNECTION_RETRY_PERIOD_PROPERTY, cmwProperties.getProperty(CONNECTION_RETRY_PERIOD_PROPERTY, DEFAULT_CONNECTION_RETRY_PERIOD)));
        cmwProperties.setProperty(CONNECTION_RETRY_NUMBER_PROPERTY, System.getProperty(CONNECTION_RETRY_NUMBER_PROPERTY, cmwProperties.getProperty(CONNECTION_RETRY_NUMBER_PROPERTY, DEFAULT_CONNECTION_RETRY_NUMBER)));
        cmwProperties.setProperty(CONNECTION_PING_INTERVAL_PROPERTY, System.getProperty(CONNECTION_PING_INTERVAL_PROPERTY, cmwProperties.getProperty(CONNECTION_PING_INTERVAL_PROPERTY, DEFAULT_CONNECTION_PING_INTERVAL)));
        cmwProperties.setProperty(USERNAME_PROPERTY, System.getProperty(USERNAME_PROPERTY, cmwProperties.getProperty(USERNAME_PROPERTY, DEFAULT_USERNAME)));
        cmwProperties.setProperty(PASSWORD_PROPERTY, System.getProperty(PASSWORD_PROPERTY, cmwProperties.getProperty(PASSWORD_PROPERTY, DEFAULT_PASSWORD)));
        cmwProperties.setProperty(BROKER_LIST_PROPERTY, System.getProperty(BROKER_LIST_PROPERTY, cmwProperties.getProperty(BROKER_LIST_PROPERTY, DEFAULT_BROKER_LIST)));
        cmwProperties.setProperty(LOAD_BALANCING_PROPERTY, System.getProperty(LOAD_BALANCING_PROPERTY, cmwProperties.getProperty(LOAD_BALANCING_PROPERTY, "false")));
        cmwProperties.setProperty(KEEP_ALIVE_PROPERTY, System.getProperty(KEEP_ALIVE_PROPERTY, cmwProperties.getProperty(KEEP_ALIVE_PROPERTY, DEFAULT_KEEP_ALIVE)));
        cmwProperties.setProperty(MSG_PERSISTANCE_PROPERTY, System.getProperty(MSG_PERSISTANCE_PROPERTY, cmwProperties.getProperty(MSG_PERSISTANCE_PROPERTY, "false")));
        cmwProperties.setProperty(MSG_PRIORITY_PROPERTY, System.getProperty(MSG_PRIORITY_PROPERTY, cmwProperties.getProperty(MSG_PRIORITY_PROPERTY, DEFAULT_MSG_PRIORITY)));
        cmwProperties.setProperty(MSG_TIMETOLIVE_PROPERTY, System.getProperty(MSG_TIMETOLIVE_PROPERTY, cmwProperties.getProperty(MSG_TIMETOLIVE_PROPERTY, DEFAULT_MSG_TIMETOLIVE)));
        cmwProperties.setProperty(SEQUENTIAL_PROPERTY, System.getProperty(SEQUENTIAL_PROPERTY, cmwProperties.getProperty(SEQUENTIAL_PROPERTY, DEFAULT_SEQUENTIAL)));
        cmwProperties.setProperty(SELECTOR_AT_BROKER_PROPERTY, System.getProperty(SELECTOR_AT_BROKER_PROPERTY, cmwProperties.getProperty(SELECTOR_AT_BROKER_PROPERTY, "false")));
        cmwProperties.setProperty(NOTIFICATION_PROPERTY, System.getProperty(NOTIFICATION_PROPERTY, cmwProperties.getProperty(NOTIFICATION_PROPERTY, "false")));
        StringWriter stringWriter = new StringWriter();
        cmwProperties.list(new PrintWriter(stringWriter));
        cat.debug((Object)("using properties :\n" + stringWriter.toString()));
    }
}

