/*
 * Decompiled with CFR 0.152.
 */
package cern.cmw.mom.pubsub.impl;

import cern.cmw.mom.pubsub.ExceptionListener;
import cern.cmw.mom.pubsub.MOMException;
import cern.cmw.mom.pubsub.NotificationHelper;
import cern.cmw.mom.pubsub.Subscriber;
import cern.cmw.mom.pubsub.SubscriptionListener;
import cern.cmw.mom.pubsub.impl.ConnectionException;
import cern.cmw.mom.pubsub.impl.JMSTopicConnection;
import cern.cmw.mom.pubsub.impl.JMSTopicConnectionFactory;
import cern.cmw.mom.pubsub.impl.SubscriptionHandle;
import cern.cmw.mom.util.MomConfig;
import cern.cmw.mom.util.TopicAdminHelper;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import org.apache.log4j.Category;

public class DefaultSubscriberImpl
implements Subscriber,
javax.jms.ExceptionListener {
    static Category cat = Category.getInstance((String)DefaultSubscriberImpl.class.getName());
    private Boolean loadBalancing;
    private Boolean selectorAtBroker;
    private Boolean sequential;
    private ExceptionListener listener = null;
    private HashMap subscribers = null;
    private JMSTopicConnection connection = null;
    private Map topicDirectory = null;
    private Message notificationMessage = null;
    private Properties momProperties = null;
    private String brokerList;
    private String password;
    private String subscriberId = null;
    private String username;
    private Thread keepAliveThread = null;
    private TopicPublisher notificationPublisher = null;
    private TopicSession serviceSession = null;
    private boolean closed = true;
    private boolean keepAliveEnabled = false;
    private boolean notificationsEnabled = false;
    private int keepAliveInterval = 0;

    public DefaultSubscriberImpl() throws MOMException {
        this.username = null;
        this.password = null;
        this.brokerList = null;
        this.loadBalancing = null;
        this.selectorAtBroker = null;
        this.sequential = null;
        this.open();
    }

    public DefaultSubscriberImpl(String string, String string2, String string3, Boolean bl, Boolean bl2, Boolean bl3) throws MOMException {
        this.username = string;
        this.password = string2;
        this.brokerList = string3;
        this.loadBalancing = bl;
        this.selectorAtBroker = bl3;
        this.sequential = bl2;
        this.open();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.listener = exceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        cat.debug((Object)"close()");
        HashMap hashMap = this.subscribers;
        synchronized (hashMap) {
            SubscriptionHandle subscriptionHandle2 = null;
            this.keepAliveEnabled = false;
            try {
                for (SubscriptionHandle subscriptionHandle2 : this.subscribers.values()) {
                    if (!NotificationHelper.isNotification(subscriptionHandle2.getSubscriptionTopic())) {
                        this.publishNotification(3, subscriptionHandle2);
                    }
                    subscriptionHandle2.getSubscriber().close();
                    subscriptionHandle2.getSession().close();
                }
                this.subscribers.clear();
                if (this.notificationPublisher != null) {
                    this.notificationPublisher.close();
                    this.notificationPublisher = null;
                }
                if (this.serviceSession != null) {
                    this.serviceSession.close();
                    this.serviceSession = null;
                }
                if (this.topicDirectory != null) {
                    this.topicDirectory.clear();
                    this.topicDirectory = null;
                }
            }
            catch (JMSException jMSException) {
                cat.error((Object)("Exception raised closing a Subscriber : " + jMSException.getMessage()));
            }
            if (this.connection != null) {
                try {
                    this.connection.stop();
                }
                catch (ConnectionException connectionException) {
                    connectionException.printStackTrace();
                }
                this.connection.close();
                this.connection = null;
            }
            this.closed = true;
        }
        cat.debug((Object)"closed.");
    }

    public void onException(JMSException jMSException) {
        cat.warn((Object)("onException(): " + (Object)((Object)jMSException)));
    }

    public void open() throws MOMException {
        cat.debug((Object)"open()");
        this.initialize(false);
        this.setConnectionIdentifier();
        this.subscribers = new HashMap();
        if (this.notificationsEnabled && this.keepAliveInterval > 0) {
            this.keepAliveEnabled = true;
            this.keepAliveThread = this.createKeepAliveThread();
            this.keepAliveThread.setPriority(1);
            this.keepAliveThread.setDaemon(true);
            this.keepAliveThread.start();
        }
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long subscribe(String string, SubscriptionListener subscriptionListener, String string2) throws JMSException, NamingException {
        cat.info((Object)("subscribe(" + string + ", listener, " + string2 + ")"));
        if (this.closed) {
            throw new JMSException("Subscriber closed.");
        }
        SubscriptionHandle subscriptionHandle = new SubscriptionHandle();
        subscriptionHandle.setSubscriptionTopic(string);
        subscriptionHandle.setSubscriptionSelector(string2);
        subscriptionHandle.setSubscriptionListener(subscriptionListener);
        StringBuffer stringBuffer = new StringBuffer();
        if (NotificationHelper.isNotification(string)) {
            stringBuffer.append(string2);
        } else {
            if (string2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("( (");
            stringBuffer.append("SUBSCRIPTION_ID");
            stringBuffer.append(" IS NULL) OR (");
            stringBuffer.append("SUBSCRIPTION_ID");
            stringBuffer.append(" = '");
            stringBuffer.append(this.subscriberId);
            stringBuffer.append("@");
            stringBuffer.append(subscriptionHandle.getSubscriptionToken());
            stringBuffer.append("') )");
        }
        TopicSession topicSession = null;
        TopicSubscriber topicSubscriber = null;
        Topic topic = this.createTopic(string);
        try {
            topicSession = this.connection.createTopicSession();
            topicSubscriber = topicSession.createSubscriber(topic, stringBuffer.toString(), false);
        }
        catch (JMSSecurityException jMSSecurityException) {
            cat.error((Object)"JMSSecurityException caught");
            throw new NamingException(jMSSecurityException.getMessage());
        }
        catch (JMSException jMSException) {
            cat.error((Object)"JMSException caught");
            throw new NamingException(jMSException.getMessage());
        }
        catch (ConnectionException connectionException) {
            cat.error((Object)"ConnectionException caught");
            throw new JMSException(connectionException.getMessage());
        }
        catch (Exception exception) {
            cat.error((Object)"Generic exception caught", (Throwable)exception);
        }
        topicSubscriber.setMessageListener((MessageListener)subscriptionListener);
        subscriptionHandle.setSubscriber(topicSubscriber);
        subscriptionHandle.setSession(topicSession);
        HashMap hashMap = this.subscribers;
        synchronized (hashMap) {
            this.subscribers.put(new Long(subscriptionHandle.getSubscriptionToken()), subscriptionHandle);
        }
        if (!NotificationHelper.isNotification(string)) {
            this.publishNotification(2, subscriptionHandle);
        }
        return subscriptionHandle.getSubscriptionToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unSubscribe(long l) throws JMSException {
        cat.info((Object)("unSubscribe(" + l + ")"));
        if (this.closed) {
            throw new JMSException("Subscriber closed.");
        }
        HashMap hashMap = this.subscribers;
        synchronized (hashMap) {
            Long l2 = new Long(l);
            SubscriptionHandle subscriptionHandle = (SubscriptionHandle)this.subscribers.get(l2);
            if (subscriptionHandle != null) {
                subscriptionHandle.getSubscriber().close();
                subscriptionHandle.getSession().close();
                if (!NotificationHelper.isNotification(subscriptionHandle.getSubscriptionTopic())) {
                    this.publishNotification(3, subscriptionHandle);
                }
                this.subscribers.remove(l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unSubscribeAll() throws JMSException {
        cat.info((Object)"unSubscribeAll()");
        System.out.println("### DefaultSubscriberImpl::unSubscribeAll");
        if (this.closed) {
            throw new JMSException("Subscriber closed.");
        }
        HashMap hashMap = this.subscribers;
        synchronized (hashMap) {
            SubscriptionHandle subscriptionHandle2 = null;
            for (SubscriptionHandle subscriptionHandle2 : this.subscribers.values()) {
                if (!NotificationHelper.isNotification(subscriptionHandle2.getSubscriptionTopic())) {
                    this.publishNotification(3, subscriptionHandle2);
                }
                subscriptionHandle2.getSubscriber().close();
                subscriptionHandle2.getSession().close();
            }
            this.subscribers.clear();
        }
    }

    protected Topic createTopic(String string) throws JMSException, NamingException {
        cat.debug((Object)("createTopic(" + string + ")"));
        Topic topic = null;
        if (NotificationHelper.isNotification(string) || TopicAdminHelper.validateTopic(string, this.connection.getUsername(), 1)) {
            topic = (Topic)this.topicDirectory.get(string);
            if (topic == null) {
                topic = this.serviceSession.createTopic(string);
                this.topicDirectory.put(string, topic);
            }
        } else {
            throw new NamingException("[" + string + "] is not a valid topic name");
        }
        return topic;
    }

    protected void finalize() throws Throwable {
        cat.debug((Object)"finalize()");
        this.close();
        super.finalize();
        cat.debug((Object)(this.subscriberId + " finalized."));
    }

    protected void recoverSubscriptions() {
        cat.info((Object)"recoverSubscriptions()");
        try {
            SubscriptionHandle subscriptionHandle2 = null;
            for (SubscriptionHandle subscriptionHandle2 : this.subscribers.values()) {
                if (!NotificationHelper.isNotification(subscriptionHandle2.getSubscriptionTopic())) {
                    this.publishNotification(3, subscriptionHandle2);
                }
                cat.debug((Object)("Recovering subscription to : " + subscriptionHandle2.getSubscriptionTopic()));
                TopicSession topicSession = this.connection.createTopicSession();
                TopicSubscriber topicSubscriber = topicSession.createSubscriber(this.createTopic(subscriptionHandle2.getSubscriptionTopic()), subscriptionHandle2.getSubscriptionSelector(), false);
                topicSubscriber.setMessageListener(subscriptionHandle2.getSubscriptionListener());
                subscriptionHandle2.setSession(topicSession);
                subscriptionHandle2.setSubscriber(topicSubscriber);
                if (NotificationHelper.isNotification(subscriptionHandle2.getSubscriptionTopic())) continue;
                this.publishNotification(2, subscriptionHandle2);
            }
            cat.info((Object)"Subscriptions succesfully recovered.");
        }
        catch (Exception exception) {
            cat.error((Object)"unable to recover subscriptions", (Throwable)exception);
        }
    }

    private void setConnectionIdentifier() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            cat.warn((Object)"Exception raised attempting to get the hostname.", (Throwable)exception);
            string = new String("HOSTNAME");
        }
        this.subscriberId = new String(string + "@" + this.connection.getConnectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionHandle getSubscriptionHandle(long l) {
        HashMap hashMap = this.subscribers;
        synchronized (hashMap) {
            return (SubscriptionHandle)this.subscribers.get(new Long(l));
        }
    }

    private Thread createKeepAliveThread() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                cat.info((Object)"KeepAliveThread started.");
                while (DefaultSubscriberImpl.this.keepAliveEnabled) {
                    DefaultSubscriberImpl.this.publishKeepAliveNotifications();
                    try {
                        Thread.sleep(DefaultSubscriberImpl.this.keepAliveInterval * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                cat.info((Object)"KeepAliveThread exited.");
            }
        };
        return thread;
    }

    private void initialize(boolean bl) throws MOMException {
        cat.debug((Object)"initialize()");
        this.momProperties = MomConfig.getProperties(this.getClass().getClassLoader());
        this.keepAliveInterval = Integer.valueOf(this.momProperties.getProperty("cmw.mom.keepalive"));
        this.notificationsEnabled = Boolean.valueOf(this.momProperties.getProperty("cmw.mom.notification"));
        this.topicDirectory = new HashMap();
        try {
            this.connection = JMSTopicConnectionFactory.createJMSTopicConnection(this.username, this.password, this.brokerList, this.loadBalancing, this.sequential, this.selectorAtBroker);
            this.connection.connect(bl);
            this.connection.setExceptionListener(this);
            this.serviceSession = this.connection.createTopicSession();
            this.connection.start();
        }
        catch (ConnectionException connectionException) {
            throw new MOMException("Unable to estabilish a connection, cause is : " + connectionException.getMessage());
        }
        try {
            this.notificationPublisher = this.serviceSession.createPublisher(null);
            this.notificationPublisher.setDeliveryMode(1);
            this.notificationPublisher.setTimeToLive(60000L);
            this.notificationMessage = this.serviceSession.createMessage();
        }
        catch (JMSException jMSException) {
            System.out.println("Exception caught: " + jMSException.getMessage());
            jMSException.printStackTrace(System.err);
            throw new MOMException("Exception raised attempting to create the notifications publisher, cause is : " + jMSException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishKeepAliveNotifications() {
        cat.debug((Object)"publishKeepAliveNotifications()");
        if (this.connection.isConnected()) {
            SubscriptionHandle subscriptionHandle2 = null;
            Collection collection = null;
            HashMap hashMap = this.subscribers;
            synchronized (hashMap) {
                collection = ((Map)this.subscribers.clone()).values();
            }
            try {
                for (SubscriptionHandle subscriptionHandle2 : collection) {
                    if (NotificationHelper.isNotification(subscriptionHandle2.getSubscriptionTopic())) continue;
                    this.publishNotification(4, subscriptionHandle2);
                }
            }
            catch (JMSException jMSException) {
                cat.error((Object)"unable to publish keep alive notifications", (Throwable)jMSException);
            }
        }
    }

    private void publishNotification(int n, SubscriptionHandle subscriptionHandle) throws JMSException {
        if (this.notificationsEnabled) {
            cat.info((Object)("publishNotification(" + n + ", " + subscriptionHandle.getSubscriptionTopic() + ", " + subscriptionHandle.getSubscriptionSelector() + ")"));
            this.notificationMessage.setIntProperty("NOTIFICATION_TYPE", n);
            this.notificationMessage.setStringProperty("SELECTOR", subscriptionHandle.getSubscriptionSelector());
            this.notificationMessage.setStringProperty("TOPIC", subscriptionHandle.getSubscriptionTopic());
            this.notificationMessage.setStringProperty("SUBSCRIPTION_ID", this.subscriberId + "@" + subscriptionHandle.getSubscriptionToken());
            Topic topic = null;
            try {
                topic = this.createTopic(NotificationHelper.CarrierTopics[n]);
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
            }
            this.notificationPublisher.publish(topic, this.notificationMessage);
        }
    }
}

