/*
 * Decompiled with CFR 0.152.
 */
package cern.cmw.mom.pubsub.impl;

import alma.acs.container.ContainerServicesBase;
import cern.cmw.mom.pubsub.impl.ConnectionException;
import cern.cmw.mom.pubsub.impl.JMSTopicConnection;
import cern.cmw.mom.util.MomConfig;
import com.cosylab.acs.jms.ACSJMSTopicConnectionFactory;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import org.apache.log4j.Category;

public class ACSJMSTopicConnectionImpl
implements JMSTopicConnection {
    public static ContainerServicesBase containerServices = null;
    static Category cat = Category.getInstance((String)ACSJMSTopicConnectionImpl.class.getName());
    private Properties momProperties = null;
    private String password = null;
    private String username = null;
    private TopicConnection brokerConnection = null;
    private TopicConnectionFactory factory = null;
    private boolean connected = false;
    private int pingInterval = 0;
    private int retryInterval = 0;
    private int retryNumber = 0;

    protected ACSJMSTopicConnectionImpl(String string, String string2, String string3, Boolean bl, Boolean bl2, Boolean bl3) throws JMSException {
        cat.debug((Object)"DefaultJMSTopicConnectionImpl()");
        this.momProperties = MomConfig.getProperties(this.getClass().getClassLoader());
        this.username = string != null ? string : this.momProperties.getProperty("cmw.mom.username");
        this.password = string2 != null ? string2 : this.momProperties.getProperty("cmw.mom.password");
        this.retryInterval = Integer.parseInt(this.momProperties.getProperty("cmw.mom.retry"));
        this.retryNumber = Integer.parseInt(this.momProperties.getProperty("cmw.mom.maxretry"));
        this.pingInterval = Integer.parseInt(this.momProperties.getProperty("cmw.mom.ping"));
        this.factory = new ACSJMSTopicConnectionFactory(containerServices);
    }

    public static ACSJMSTopicConnectionImpl instance(String string, String string2, String string3, Boolean bl, Boolean bl2, Boolean bl3) throws ConnectionException {
        cat.debug((Object)"instance()");
        ACSJMSTopicConnectionImpl aCSJMSTopicConnectionImpl = null;
        try {
            aCSJMSTopicConnectionImpl = new ACSJMSTopicConnectionImpl(string, string2, string3, bl, bl2, bl3);
        }
        catch (JMSException jMSException) {
            throw new ConnectionException(jMSException.getMessage());
        }
        return aCSJMSTopicConnectionImpl;
    }

    @Override
    public String getConnectId() {
        String string = "";
        if (this.isConnected()) {
            try {
                string = this.brokerConnection.getClientID();
            }
            catch (JMSException jMSException) {
                jMSException.printStackTrace();
            }
        }
        return string;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) throws ConnectionException {
        cat.debug((Object)"setExceptionListener()");
        if (this.isConnected()) {
            try {
                this.brokerConnection.setExceptionListener(exceptionListener);
            }
            catch (JMSException jMSException) {
                throw new ConnectionException(jMSException.getMessage());
            }
        } else {
            throw new ConnectionException("Not connected!");
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void close() {
        cat.debug((Object)"close()");
        if (this.brokerConnection != null) {
            try {
                this.brokerConnection.close();
            }
            catch (JMSException jMSException) {
                cat.warn((Object)jMSException.getMessage());
            }
        }
        this.disconnect();
    }

    @Override
    public void connect(boolean bl) throws ConnectionException {
        cat.debug((Object)"connect()");
        int n = 1;
        if (bl) {
            n = this.retryNumber;
        }
        for (int i = 0; !this.connected && i < n; ++i) {
            if (bl) {
                try {
                    Thread.sleep(this.retryInterval * 1000);
                }
                catch (InterruptedException interruptedException) {
                    cat.error((Object)interruptedException.getMessage());
                }
            }
            try {
                this.brokerConnection = this.factory.createTopicConnection();
                this.connected = true;
                continue;
            }
            catch (JMSException jMSException) {
                cat.warn((Object)"Connection refused", (Throwable)jMSException);
            }
        }
        if (!this.connected) {
            throw new ConnectionException("Unable to (re)estabilish a connection to the message broker!");
        }
    }

    @Override
    public TopicSession createTopicSession() throws ConnectionException {
        cat.debug((Object)"createTopicSession()");
        if (this.isConnected()) {
            try {
                return this.brokerConnection.createTopicSession(false, 1);
            }
            catch (JMSException jMSException) {
                throw new ConnectionException(jMSException.getMessage());
            }
        }
        throw new ConnectionException("Not connected!");
    }

    @Override
    public void disconnect() {
        cat.debug((Object)"disconnect()");
        if (this.isConnected()) {
            // empty if block
        }
        this.brokerConnection = null;
        this.connected = false;
        cat.info((Object)"disconnected");
    }

    @Override
    public void start() throws ConnectionException {
        cat.debug((Object)"start()");
        if (containerServices == null) {
            throw new ConnectionException("ContainerServices is null");
        }
        if (this.isConnected()) {
            try {
                this.brokerConnection.start();
            }
            catch (JMSException jMSException) {
                throw new ConnectionException(jMSException.getMessage());
            }
        } else {
            throw new ConnectionException("Not connected!");
        }
    }

    @Override
    public void stop() throws ConnectionException {
        cat.debug((Object)"stop()");
        if (this.isConnected()) {
            try {
                this.brokerConnection.stop();
            }
            catch (JMSException jMSException) {
                throw new ConnectionException(jMSException.getMessage());
            }
        } else {
            throw new ConnectionException("Not connected!");
        }
    }

    protected void finalize() throws Throwable {
        cat.debug((Object)"finalize()");
        this.close();
        super.finalize();
    }
}

