/*
 * Decompiled with CFR 0.152.
 */
package cern.cmw.mom.pubsub;

import cern.cmw.mom.pubsub.Notification;
import cern.cmw.mom.pubsub.impl.ConsumerAliveNotificationImpl;
import cern.cmw.mom.pubsub.impl.ConsumerCloseNotificationImpl;
import cern.cmw.mom.pubsub.impl.ConsumerOpenNotificationImpl;
import cern.cmw.mom.pubsub.impl.NotificationImpl;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.Category;

public final class NotificationHelper {
    static Category cat = Category.getInstance((String)NotificationHelper.class.getName());
    private static final String T_NOTIFICATIONS_ROOT = "CMW.ADMIN.NOTIFICATIONS";
    private static final String T_NOTIFICATIONS = "CMW.ADMIN.NOTIFICATIONS.#";
    private static final String T_CONSUMER_NOTIFICATIONS = "CMW.ADMIN.NOTIFICATIONS.CONSUMER.#";
    private static final String T_OPEN_SUB_NOTIFICATIONS = "CMW.ADMIN.NOTIFICATIONS.CONSUMER.OPEN_SUBSCRIPTION";
    private static final String T_CLOSE_SUB_NOTIFICATIONS = "CMW.ADMIN.NOTIFICATIONS.CONSUMER.CLOSE_SUBSCRIPTION";
    private static final String T_KEEP_ALIVE_NOTIFICATIONS = "CMW.ADMIN.NOTIFICATIONS.CONSUMER.KEEP_ALIVE_SUBSCRIPTION";
    public static final String[] CarrierTopics = new String[]{"CMW.ADMIN.NOTIFICATIONS.#", "CMW.ADMIN.NOTIFICATIONS.CONSUMER.#", "CMW.ADMIN.NOTIFICATIONS.CONSUMER.OPEN_SUBSCRIPTION", "CMW.ADMIN.NOTIFICATIONS.CONSUMER.CLOSE_SUBSCRIPTION", "CMW.ADMIN.NOTIFICATIONS.CONSUMER.KEEP_ALIVE_SUBSCRIPTION"};
    public static final int NOTIFICATION = 0;
    public static final int CONSUMER_NOTIFICATION = 1;
    public static final int CONSUMER_OPEN_NOTIFICATION = 2;
    public static final int CONSUMER_CLOSE_NOTIFICATION = 3;
    public static final int CONSUMER_ALIVE_NOTIFICATION = 4;
    public static final String NOTIFICATION_TYPE_PROPERTY = "NOTIFICATION_TYPE";
    public static final String TOPIC_PROPERTY = "TOPIC";
    public static final String SELECTOR_PROPERTY = "SELECTOR";
    public static final String SUBSCRIPTION_ID_PROPERTY = "SUBSCRIPTION_ID";

    public static final boolean isNotification(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(T_NOTIFICATIONS_ROOT);
    }

    public static Notification messageToNotification(Message message) {
        if (message != null) {
            try {
                if (message.propertyExists(NOTIFICATION_TYPE_PROPERTY)) {
                    switch (message.getIntProperty(NOTIFICATION_TYPE_PROPERTY)) {
                        case 0: {
                            return new NotificationImpl(message);
                        }
                        case 2: {
                            return new ConsumerOpenNotificationImpl(message);
                        }
                        case 3: {
                            return new ConsumerCloseNotificationImpl(message);
                        }
                        case 4: {
                            return new ConsumerAliveNotificationImpl(message);
                        }
                    }
                    cat.error((Object)"Unknown NOTIFICATION_TYPE");
                    return null;
                }
            }
            catch (JMSException jMSException) {
                cat.error((Object)"Unable to unwrap the Notification");
                jMSException.printStackTrace();
            }
        }
        return null;
    }
}

