/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.tmcdb.Persistence.Util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class TMCDBConfig {
    private static TMCDBConfig instance = null;
    private static DBType dbType;
    private static String dbUser;
    private static String dbPassword;
    private static String dbUrl;
    private static String confName;
    private static String fileName;
    private static String dbConnectionEnabled;

    private TMCDBConfig() {
        this.fetchConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TMCDBConfig getInstance() {
        if (instance != null) return instance;
        Class<TMCDBConfig> clazz = TMCDBConfig.class;
        synchronized (TMCDBConfig.class) {
            if (instance != null) return instance;
            instance = new TMCDBConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getDbUser() {
        return dbUser;
    }

    public String getDbPassword() {
        return dbPassword;
    }

    public String getDbUrl() {
        return dbUrl;
    }

    public DBType getDbType() {
        return dbType;
    }

    public String getConfigurationName() {
        return confName;
    }

    public String getFileName() {
        return fileName;
    }

    public boolean isDBConnectionEnabled() {
        return !dbConnectionEnabled.equalsIgnoreCase("false");
    }

    private void fetchConfiguration() {
        String string;
        Properties properties = new Properties();
        fileName = "dbConfig.properties";
        File file = new File(fileName);
        boolean bl = false;
        try {
            properties.load(new FileInputStream(file));
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bl && (string = System.getenv("ACSDATA")) != null) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            fileName = string + "config/dbConfig.properties";
            file = new File(fileName);
            try {
                properties.load(new FileInputStream(file));
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) {
            throw new RuntimeException("The configuration file dbConfig.properties could not be found, neither in current working directory nor in $ACSDATA/config.");
        }
        string = properties.getProperty("tmcdb.db.backend");
        if (string.equals("oracle")) {
            dbType = DBType.ORACLE;
            dbUser = properties.getProperty("tmcdb.oracle.user");
            dbPassword = properties.getProperty("tmcdb.oracle.passwd");
            dbUrl = properties.getProperty("tmcdb.oracle.url");
        } else if (string.equals("hsqldb")) {
            dbType = DBType.HSQLDB;
            dbUser = properties.getProperty("tmcdb.hsqldb.user");
            dbPassword = properties.getProperty("tmcdb.hsqldb.passwd");
            dbUrl = properties.getProperty("tmcdb.hsqldb.url");
        }
        dbConnectionEnabled = properties.getProperty("tmc.dbconnection.enabled");
        if (dbConnectionEnabled == null) {
            dbConnectionEnabled = "true";
        }
        confName = properties.getProperty("tmcdb.confname");
    }

    static {
        dbConnectionEnabled = "true";
    }

    public static enum DBType {
        ORACLE,
        HSQLDB;

    }
}

