/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.console.impl;

import alma.alarmsystem.AlarmService;
import cern.laser.client.LaserConnectionException;
import cern.laser.client.impl.common.AlarmServiceSingleton;
import cern.laser.client.impl.services.selection.AlarmSelectionHandlerImpl;
import cern.laser.client.impl.services.selection.CategorySelectionImpl;
import cern.laser.client.services.selection.CategorySelection;
import cern.laser.client.services.selection.Selection;
import cern.laser.console.Behaviour;
import cern.laser.console.CommentedAlarmMap;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.LaserUserNotFoundException;
import cern.laser.console.User;
import cern.laser.console.impl.BehaviourImpl;
import cern.laser.console.impl.ConfigurationImpl;
import java.util.ArrayList;
import java.util.Collection;

public class UserImpl
implements User {
    private AlarmService laser;
    private ArrayList configurations = new ArrayList();
    private LocalConsoleUser user;

    public UserImpl(String string) throws LaserConsoleException {
        this.user = new LocalConsoleUser(string, string);
        try {
            this.laser = AlarmServiceSingleton.getInstance();
        }
        catch (Exception exception) {
            throw new LaserConsoleException("unable to create a console user : " + exception.getMessage(), exception);
        }
    }

    @Override
    public String getName() throws LaserConsoleException {
        return this.user.userId;
    }

    public void setName(String string) throws LaserConsoleException {
        this.user.userId = string;
    }

    @Override
    public String getPassword() throws LaserConsoleException {
        if (this.user.password == null) {
            throw new IllegalArgumentException("User's password not set!");
        }
        return this.user.password;
    }

    @Override
    public void setPassword(String string) throws LaserConsoleException {
        if (string == null) {
            throw new IllegalArgumentException("Null given to set as user's password!");
        }
        this.user.password = string;
    }

    @Override
    public String getDefaultPrinter() throws LaserConsoleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultPrinter(String string) throws LaserConsoleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection getConfigurations() throws LaserConsoleException, LaserConnectionException {
        if (this.configurations.size() == 0) {
            this.configurations.add(this.getDefaultConfiguration());
        }
        return this.configurations;
    }

    @Override
    public Configuration getConfiguration(String string) throws LaserConsoleException, LaserConnectionException {
        return new ConfigurationImpl(string);
    }

    @Override
    public Configuration createConfiguration(String string) throws LaserConsoleException {
        Configuration configuration;
        try {
            configuration = this.getDefaultConfiguration();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new LaserConsoleException(exception.getMessage());
        }
        CategorySelectionImpl categorySelectionImpl = new CategorySelectionImpl();
        configuration.getSelection().setCategorySelection((CategorySelection)categorySelectionImpl);
        return configuration;
    }

    @Override
    public Configuration createConfiguration(Configuration configuration) throws LaserConsoleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeConfiguration(String string) throws LaserConsoleException {
    }

    @Override
    public Configuration getDefaultConfiguration() throws LaserConsoleException, LaserConnectionException {
        try {
            return new Configuration(){
                private String name = "Client-side in memory configuration";
                private boolean isDefault = true;
                private Behaviour behaviour = new BehaviourImpl();
                private Selection selection = AlarmSelectionHandlerImpl.get().createSelection();
                private CommentedAlarmMap highlighted = new CommentedAlarmMap();
                private CommentedAlarmMap autoHighlighted = new CommentedAlarmMap();
                private CommentedAlarmMap autoKlaxoned = new CommentedAlarmMap();
                private CommentedAlarmMap inhibited = new CommentedAlarmMap();
                private CommentedAlarmMap masked = new CommentedAlarmMap();
                private CommentedAlarmMap acknowledged = new CommentedAlarmMap();
                private CommentedAlarmMap newIndicator = new CommentedAlarmMap();
                private Boolean activeListFont = new Boolean(false);

                @Override
                public String getName() throws LaserConsoleException {
                    return this.name;
                }

                @Override
                public void setName(String string) throws LaserConsoleException {
                    this.name = string;
                }

                @Override
                public boolean isDefault() throws LaserConsoleException {
                    return this.isDefault;
                }

                @Override
                public Selection getSelection() throws LaserConsoleException {
                    return this.selection;
                }

                @Override
                public void setSelection(Selection selection) throws LaserConsoleException {
                    this.selection = selection;
                }

                @Override
                public Behaviour createBehaviour() {
                    return new BehaviourImpl();
                }

                @Override
                public Behaviour getBehaviour() throws LaserConsoleException {
                    return this.behaviour;
                }

                @Override
                public void setBehaviour(Behaviour behaviour) throws LaserConsoleException {
                    this.behaviour = behaviour;
                }

                @Override
                public CommentedAlarmMap getMasked() throws LaserConsoleException {
                    return this.masked;
                }

                @Override
                public void setMasked(CommentedAlarmMap commentedAlarmMap) throws LaserConsoleException {
                    this.masked = commentedAlarmMap;
                }

                @Override
                public CommentedAlarmMap getInhibited() throws LaserConsoleException {
                    return this.inhibited;
                }

                @Override
                public void setInhibited(CommentedAlarmMap commentedAlarmMap) throws LaserConsoleException {
                    this.inhibited = commentedAlarmMap;
                }

                @Override
                public CommentedAlarmMap getHighlighted() throws LaserConsoleException {
                    return this.highlighted;
                }

                @Override
                public void setHighlighted(CommentedAlarmMap commentedAlarmMap) throws LaserConsoleException {
                    this.highlighted = commentedAlarmMap;
                }

                @Override
                public CommentedAlarmMap getAutoHighlighted() throws LaserConsoleException {
                    return this.autoHighlighted;
                }

                @Override
                public void setAutoHighlighted(CommentedAlarmMap commentedAlarmMap) throws LaserConsoleException {
                    this.autoHighlighted = commentedAlarmMap;
                }

                @Override
                public CommentedAlarmMap getAutoKlaxoned() throws LaserConsoleException {
                    return this.autoKlaxoned;
                }

                @Override
                public void setAutoKlaxoned(CommentedAlarmMap commentedAlarmMap) throws LaserConsoleException {
                    this.autoKlaxoned = commentedAlarmMap;
                }

                @Override
                public CommentedAlarmMap getAcknowledged() throws LaserConsoleException {
                    return this.acknowledged;
                }

                @Override
                public void setAcknowledged(CommentedAlarmMap commentedAlarmMap) throws LaserConsoleException {
                    this.acknowledged = commentedAlarmMap;
                }

                @Override
                public CommentedAlarmMap getNewIndicator() throws LaserConsoleException {
                    return this.newIndicator;
                }

                @Override
                public void setNewIndicator(CommentedAlarmMap commentedAlarmMap) throws LaserConsoleException {
                    this.newIndicator = commentedAlarmMap;
                }

                @Override
                public Boolean getActiveListFont() throws LaserConsoleException {
                    return this.activeListFont;
                }

                @Override
                public void setActiveListFont(Boolean bl) throws LaserConsoleException {
                    this.activeListFont = bl;
                }
            };
        }
        catch (Throwable throwable) {
            throw new LaserConsoleException("Failed to create default configuration.", throwable);
        }
    }

    @Override
    public void setDefaultConfiguration(String string) throws LaserConsoleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultConfiguration(String string) throws LaserConsoleException {
        throw new UnsupportedOperationException();
    }

    private Object getConsoleConfigurationEntityEJBHome() throws LaserConnectionException {
        throw new UnsupportedOperationException();
    }

    private Object getConsoleUserEntityEJB() throws LaserConnectionException, LaserUserNotFoundException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("\nCONSOLE USER :");
            stringBuffer.append("\nNAME : ");
            stringBuffer.append(this.getName());
            stringBuffer.append("\nPASSWORD : ");
            stringBuffer.append(this.getPassword());
        }
        catch (Exception exception) {
            stringBuffer.append("exception caught : " + exception.getMessage());
        }
        return stringBuffer.toString();
    }

    private class LocalConsoleUser {
        public String userId;
        public String password;

        public LocalConsoleUser(String string, String string2) {
            this.userId = string;
            this.password = string2;
        }
    }
}

