/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.logging;

import alma.acs.logging.ClientLogManager;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.access.PermissionDeniedException;
import alma.archive.exceptions.general.DatabaseException;
import alma.archive.exceptions.general.UndefinedNamespaceException;
import alma.archive.exceptions.general.UnknownSchemaException;
import alma.archive.exceptions.syntax.MalformedQueryException;
import alma.archive.exceptions.syntax.UnderspecifiedQueryException;
import alma.archive.exceptions.user.UserDoesNotExistException;
import alma.archive.logging.ArchiveLoggerImpl;
import alma.archive.logging.ArchiveLoggingQuery;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class ArchiveLoggingCli {
    private InternalIF internal;
    Logger m_logger = ClientLogManager.getAcsLogManager().getLoggerForApplication("ArchiveLoggingCLI", false);

    public ArchiveLoggingCli() throws PermissionDeniedException, DatabaseException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException, ModuleCriticalException, ArchiveException {
        this.internal = InternalIFFactory.getInternalIF((Logger)this.m_logger);
    }

    public static void main(String[] stringArray) throws PermissionDeniedException, DatabaseException, MalformedQueryException, UnderspecifiedQueryException, UnknownSchemaException, UserDoesNotExistException, UndefinedNamespaceException, ModuleCriticalException, ArchiveException, FileNotFoundException {
        Object object;
        if (stringArray.length < 2) {
            ArchiveLoggingCli.helpCLI();
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = "Fetched log entries from " + string + " to " + string2;
        HashMap<String, Integer> hashMap = ArchiveLoggerImpl.getLogLevels();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        int n2 = 30;
        for (int i = 2; i < stringArray.length - 1; i += 2) {
            if (stringArray[i].equals("-type")) {
                object = stringArray[i + 1];
                if (!hashMap.containsKey(object)) {
                    System.out.println("Unknown Log Type, no results.");
                    return;
                }
                n2 = n = hashMap.get(object).intValue();
                string3 = string3 + " of type " + n;
            }
            if (stringArray[i].equals("-routine")) {
                string5 = stringArray[i + 1];
                string3 = string3 + " in routine " + string5;
            }
            if (stringArray[i].equals("-source")) {
                string6 = stringArray[i + 1];
                string3 = string3 + " in source " + string6;
            }
            if (!stringArray[i].equals("-w")) continue;
            string4 = stringArray[i + 1];
            string3 = string3 + "\nWrote output to file " + string4;
        }
        ArchiveLoggingQuery archiveLoggingQuery = new ArchiveLoggingQuery(Logger.global);
        object = archiveLoggingQuery.getLog(string, string2, (short)n, (short)n2, string5, string6, null, Integer.MAX_VALUE);
        ArchiveLoggingCli.output((Collection<String>)object, System.out);
        if (string4 != null) {
            ArchiveLoggingCli.output((Collection<String>)object, new PrintStream(new File(string4)));
        }
        System.out.println(string3 + ".\n" + object.size() + " results in total.");
    }

    private static void output(Collection<String> collection, PrintStream printStream) {
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            printStream.println((Object)iterator.next());
        }
    }

    private static void helpCLI() {
        System.out.println("Usage: archiveLoggingCli ISOtimeStart ISOtimeEnd [-type TYPE] [-routine ROUTINE] [-source SOURCE] [-w fileName]");
        System.out.print("      Allowed types are: ");
        HashMap<String, Integer> hashMap = ArchiveLoggerImpl.getLogLevels();
        for (int i = 0; i < 9; ++i) {
            for (Map.Entry<String, Integer> entry : ArchiveLoggerImpl.getLogLevels().entrySet()) {
                if (entry.getValue() != i) continue;
                System.out.print(entry.getKey() + "   ");
            }
        }
        System.out.println();
    }
}

