/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.logging;

import alma.acs.component.ComponentImplBase;
import alma.acs.component.ComponentLifecycleException;
import alma.acs.container.ContainerServices;
import alma.acs.util.ProcessStreamGobbler;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceFactory;
import alma.alarmsystem.source.ACSFaultState;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.database.oracle.DatabaseWriter;
import alma.archive.wrappers.ArchiveTimeStamp;
import alma.xmlstore.LoggerOperations;
import com.cosylab.logging.engine.ACS.ACSRemoteRawLogListener;
import com.cosylab.logging.engine.ACS.LCEngine;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ArchiveLoggerImpl
extends ComponentImplBase
implements LoggerOperations,
ACSRemoteRawLogListener {
    private InternalIF internal;
    private short archiveLevel;
    private ContainerServices cs;
    private Logger m_logger = Logger.global;
    private LCEngine engine;
    HashMap<String, Integer> logLevelMap;
    String[] usedAtts = new String[]{"TimeStamp", "File", "Line", "Routine", "SourceObject", "Host", "Process", "Context", "Thread", "LogId", "Priority", "Uri", "Audience", "Array", "Antenna"};
    SAXBuilder builder = new SAXBuilder();
    int count = 0;
    BufferedWriter actWriter;
    BufferedWriter oldWriter;
    File actFile;
    File oldFile;
    String actStart = new ArchiveTimeStamp().toISOString();
    String actMax = "0";
    final int logOverlapCheckPeriod = 5000;
    int logOverlapCount = 0;
    boolean checkOverlap = false;
    int maxLogsPerInterval = 0;
    long logIntervalSize;
    long logPeakToleranceInterval = 0L;
    long logsPerIntervalStart = 0L;
    int logsThisInterval = 0;
    int alarmOffIntervalNumber = 100;
    long lastMaxLogsReachedTime = 0L;
    long maxLogsReachedTime = 0L;
    final int logCountCommit = 1000;
    private int logCountSinceCommit = 0;
    final String fileNamePrefix = "logOutput";
    String fileName;
    final String fileSuffix = ".xml";
    ArrayList<String> fileList = new ArrayList();
    String logFilePath;
    String ngasPath;
    String ngasCommand = "ngamsArchiveClient -servers almadev1:7777 -rootDir /tmp/Holger/bulkRAMdisk/ -mimeType \"text/xml\" -pollTime 0 -cleanUpTimeOut 0 -streams 16 -v 1";
    boolean ngasClientStart = false;
    int fileMax;
    int fileSizeLimit;
    long logsReceived = 0L;
    long logsStored = 0L;
    long timeForAllLogs = 0L;
    long timeForParsing = 0L;
    long timeForStoring = 0L;
    long timeForFileStore = 0L;
    FileWriter debugOut;
    boolean maxLogAlarmActive;
    String steEnv = "";
    boolean cleanupDone = false;
    boolean fileWriteAlarmActive = false;

    public ArchiveLoggerImpl() {
        this.logLevelMap = ArchiveLoggerImpl.getLogLevels();
    }

    public static HashMap<String, Integer> getLogLevels() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put(LogTypeHelper.TRACE.acsCoreLevel.name, new Integer(LogTypeHelper.TRACE.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.DEBUG.acsCoreLevel.name, new Integer(LogTypeHelper.DEBUG.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.INFO.acsCoreLevel.name, new Integer(LogTypeHelper.INFO.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.NOTICE.acsCoreLevel.name, new Integer(LogTypeHelper.NOTICE.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.WARNING.acsCoreLevel.name, new Integer(LogTypeHelper.WARNING.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.ERROR.acsCoreLevel.name, new Integer(LogTypeHelper.ERROR.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.CRITICAL.acsCoreLevel.name, new Integer(LogTypeHelper.CRITICAL.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.ALERT.acsCoreLevel.name, new Integer(LogTypeHelper.ALERT.acsCoreLevel.value));
        hashMap.put(LogTypeHelper.EMERGENCY.acsCoreLevel.name, new Integer(LogTypeHelper.EMERGENCY.acsCoreLevel.value));
        return hashMap;
    }

    protected void initializeLogFileMap() throws Exception {
        File[] fileArray = new File(this.logFilePath).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().startsWith("logOutput")) continue;
            this.fileList.add(fileArray[i].getAbsolutePath());
        }
        Collections.sort(this.fileList);
        this.m_logger.info("Found " + this.fileList.size() + " old log files in directory " + this.logFilePath);
        while (this.fileList.size() >= this.fileMax) {
            String string = this.fileList.remove(0);
            this.m_logger.finer("Moving old log file " + string + " to " + this.ngasPath);
            if (!new File(this.ngasPath).exists()) continue;
            if (new File(this.ngasPath).list().length > 0) {
                File[] fileArray2 = new File(this.ngasPath).listFiles();
                for (int i = 0; i < fileArray2.length; ++i) {
                    fileArray2[i].delete();
                }
            }
            if (!new File(string).renameTo(new File(this.ngasPath + File.separator + new File(string).getName()))) {
                this.m_logger.warning("Could not move old log file " + string + " to " + this.ngasPath);
                throw new IOException("Could not move " + string + " to " + this.ngasPath);
            }
            Thread.sleep(1000L);
        }
    }

    public void initialize(ContainerServices containerServices) throws ComponentLifecycleException {
        Object object;
        Object object2;
        super.initialize(containerServices);
        this.cs = containerServices;
        this.m_logger = this.cs.getLogger();
        this.steEnv = System.getenv("LOCATION");
        if (this.steEnv != null) {
            this.m_logger.info("Working on STE environment: " + this.steEnv + "This information will be added to log entries.");
        } else {
            this.m_logger.info("No STE environment defined, logs will be stored without STE info.");
        }
        try {
            DatabaseWriter.instance().testLog();
        }
        catch (Exception exception) {
            this.m_logger.severe("Cannot write logs to Archive: " + exception.toString());
            throw new ComponentLifecycleException((Throwable)exception);
        }
        try {
            this.internal = InternalIFFactory.getInternalIF((Logger)this.m_logger);
        }
        catch (Exception exception) {
            throw new ComponentLifecycleException((Throwable)exception);
        }
        try {
            object2 = this.cs.getCDB();
            object = object2.get_DAO_Servant("alma/" + this.cs.getName());
            this.archiveLevel = (short)object.get_long("Archive_level");
            this.logFilePath = object.get_string("logFileDir");
            this.fileName = this.logFilePath + "/" + "logOutput";
            this.ngasPath = object.get_string("ngasDir");
            this.fileMax = (short)object.get_long("maxNumberLogFiles");
            this.fileSizeLimit = object.get_long("MaxLogFileSize");
            try {
                this.ngasClientStart = object.get_string("archiveLogFilesInNGAS").equalsIgnoreCase("true");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.ngasClientStart) {
                try {
                    this.ngasCommand = object.get_string("ngasCommand");
                }
                catch (Exception exception) {
                    this.m_logger.severe("Could not read ngasCommand from CDB, necessary for starting ngasArchiveClient.");
                    this.sendAlarm();
                    throw new ComponentLifecycleException("Could not read ngasCommand from CDB, necessary for starting ngasArchiveClient.");
                }
            }
            try {
                this.maxLogsPerInterval = object.get_long("logsPerInterval");
                if (this.maxLogsPerInterval > 0) {
                    this.m_logger.info("Checking number of logs in Oracle per second. Maximum per second: " + this.maxLogsPerInterval);
                }
                this.logIntervalSize = object.get_long("logIntervalSize");
                this.logPeakToleranceInterval = object.get_long("logPeakToleranceInterval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_logger.info("Retrieved CDB info. Archive log level: " + this.archiveLevel + ". Log file dir: " + this.logFilePath + ". Max log file size: " + this.fileSizeLimit + ". Max # log files: " + this.fileMax + ". NGAS fetch dir: " + this.ngasPath);
        }
        catch (Exception exception) {
            this.m_logger.severe("Could not read necessary information from CDB: " + exception);
            this.sendAlarm();
            throw new ComponentLifecycleException("Could not read necessary information from CDB: " + exception);
        }
        try {
            this.initializeLogFileMap();
            this.actFile = new File(this.fileName + this.actMax + "--" + new ArchiveTimeStamp(new Timestamp(Calendar.getInstance().getTimeInMillis() + 10000000L)).toISOString() + ".xml");
            this.actWriter = new BufferedWriter(new FileWriter(this.actFile));
            this.actWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\t<Log>\n\t<Header Name=\"Logs written by Archive logger\" Type=\"LOGFILE\" />\n");
            this.m_logger.info("Writing logs to " + this.actFile.getAbsolutePath());
        }
        catch (Exception exception) {
            this.m_logger.severe("Could not open file for writing logs: " + exception);
            this.sendAlarm();
            throw new ComponentLifecycleException("Could not open file for writing logs: " + exception);
        }
        object2 = Runtime.getRuntime();
        if (this.ngasClientStart) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            File file;
            this.m_logger.info("Starting ngamsArchiveClient...");
            object = this.ngasPath;
            if (((String)object).endsWith("queue")) {
                object = ((String)object).substring(0, ((String)object).length() - 5);
            }
            if (((String)object).endsWith("queue/")) {
                object = ((String)object).substring(0, ((String)object).length() - 6);
            }
            if ((file = new File((String)object + File.separator + ".ngamsArchiveClient-PID")).exists()) {
                String string;
                try {
                    object7 = new BufferedReader(new FileReader(file));
                    string = ((BufferedReader)object7).readLine();
                }
                catch (Exception exception) {
                    throw new ComponentLifecycleException("Very strange things happen with " + file);
                }
                try {
                    object6 = new ProcessBuilder("/bin/ps", "--no-headers", "-p", string);
                    object5 = ((ProcessBuilder)object6).start();
                    object4 = new BufferedInputStream(((Process)object5).getInputStream());
                    ((Process)object5).waitFor();
                    if (((InputStream)object4).available() > 0) {
                        object3 = "kill -15 " + string;
                        this.m_logger.info("Found running ngamsArchiveClient. Killing it with command: " + (String)object3);
                        object5 = ((Runtime)object2).exec((String)object3);
                        if (((Process)object5).waitFor() != 0) {
                            this.m_logger.warning("Could not kill existing ngamsArchiveClient process.");
                        }
                        Thread.sleep(1000L);
                        if (file.exists()) {
                            object3 = "kill -9 " + string;
                            this.m_logger.info("ngamsArchiveClient didn't die with SIGTERM. Killing it with command: " + (String)object3);
                            object5 = ((Runtime)object2).exec((String)object3);
                            if (((Process)object5).waitFor() != 0) {
                                this.m_logger.warning("Could not kill existing ngamsArchiveClient process.");
                            } else {
                                file.delete();
                            }
                        }
                    } else {
                        this.m_logger.info("Removing left over PID file from non-existing ngamsArchiveClient");
                        file.delete();
                    }
                }
                catch (IOException iOException) {
                    this.m_logger.warning("Could not kill existing ngamsArchiveClient process. Aborting...");
                    this.sendAlarm();
                    throw new ComponentLifecycleException("Could not kill existing ngamsArchiveClient process.");
                }
                catch (InterruptedException interruptedException) {
                    this.m_logger.warning("Could not kill existing ngamsArchiveClient process. Aborting...");
                    this.sendAlarm();
                    throw new ComponentLifecycleException("Could not kill existing ngamsArchiveClient process.");
                }
            }
            this.m_logger.info("Starting ngamsArchiveClient with " + this.ngasCommand);
            try {
                object7 = new StringTokenizer(this.ngasCommand);
                object6 = new ArrayList<String>();
                while (((StringTokenizer)object7).hasMoreTokens()) {
                    object6.add(((StringTokenizer)object7).nextToken());
                }
                object5 = new ProcessBuilder((List<String>)object6);
                object4 = ((ProcessBuilder)object5).start();
                object3 = new ProcessStreamGobbler((Process)object4, Executors.defaultThreadFactory(), false);
                try {
                    object3.gobble(0L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                this.m_logger.warning("Could not start ngamsArchiveClient. Aborting...");
                this.sendAlarm();
                throw new ComponentLifecycleException("Could not start ngamsArchiveClient.");
            }
        }
        try {
            this.engine = new LCEngine();
            this.engine.addRawLogListener((ACSRemoteRawLogListener)this);
            this.engine.connect(this.cs.getAdvancedContainerServices().getORB(), null);
        }
        catch (Throwable throwable) {
            this.m_logger.severe("Could not initialize connection to logging channel.");
            this.sendAlarm();
            throw new ComponentLifecycleException(throwable);
        }
    }

    private void sendAlarm() {
        try {
            ACSAlarmSystemInterface aCSAlarmSystemInterface = ACSAlarmSystemInterfaceFactory.createSource((String)"ARCHIVE_LOGGER");
            ACSFaultState aCSFaultState = ACSAlarmSystemInterfaceFactory.createFaultState((String)"Logging", (String)"ARCHIVE_LOGGER", (int)2);
            aCSFaultState.setDescriptor("ACTIVE");
            aCSFaultState.setUserTimestamp(new Timestamp(System.currentTimeMillis()));
            Properties properties = new Properties();
            properties.setProperty("ASI_PREFIX", "prefix");
            properties.setProperty("ASI_SUFFIX", "suffix");
            aCSFaultState.setUserProperties(properties);
            aCSAlarmSystemInterface.push(aCSFaultState);
        }
        catch (Exception exception) {
            this.m_logger.warning("Failure when sending alarm: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        ArchiveLoggerImpl archiveLoggerImpl = this;
        synchronized (archiveLoggerImpl) {
            this.cleanupDone = true;
            this.m_logger.fine("cleanup");
            try {
                this.actWriter.write("</Log>");
                this.actWriter.close();
            }
            catch (IOException iOException) {
                this.m_logger.warning("Could not close file for writing logs: " + this.actFile.getAbsolutePath() + ". Got: " + iOException);
            }
            String string = this.fileName + this.actStart + "--" + new ArchiveTimeStamp().toISOString() + ".xml";
            if (!this.actFile.renameTo(new File(string))) {
                this.m_logger.warning("Could not move old log file " + this.fileName + " to " + string);
            }
            this.fileList.add(string);
            if (this.checkOverlap) {
                try {
                    this.oldWriter.write("</Log>");
                    this.oldWriter.close();
                }
                catch (IOException iOException) {
                    this.m_logger.warning("Could not close file for writing logs: " + this.oldFile.getAbsolutePath() + ". Got: " + iOException);
                }
            }
            if (this.ngasClientStart) {
                File file;
                String string2 = this.ngasPath;
                if (string2.endsWith("queue")) {
                    string2 = string2.substring(0, string2.length() - 5);
                }
                if (string2.endsWith("queue/")) {
                    string2 = string2.substring(0, string2.length() - 6);
                }
                if ((file = new File(string2 + File.separator + ".ngamsArchiveClient-PID")).exists()) {
                    BufferedReader bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.m_logger.warning("Very strange things happen with " + file);
                    }
                    try {
                        String string3 = bufferedReader.readLine();
                        String string4 = "kill -15 " + string3;
                        this.m_logger.info("Found running ngamsArchiveClient. Killing it with command: " + string4);
                        Runtime runtime = Runtime.getRuntime();
                        Process process = runtime.exec(string4);
                        if (process.waitFor() != 0) {
                            this.m_logger.warning("Could not kill existing ngamsArchiveClient process.");
                        }
                        Thread.sleep(2000L);
                        if (file.exists()) {
                            string4 = "kill -9 " + string3;
                            this.m_logger.info("ngamsArchiveClient didn't die with SIGTERM. Killing it with command: " + string4);
                            process = runtime.exec(string4);
                            if (process.waitFor() != 0) {
                                this.m_logger.warning("Could not kill existing ngamsArchiveClient process.");
                            } else {
                                file.delete();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        this.m_logger.warning("Could not kill existing ngamsArchiveClient process.");
                    }
                    catch (InterruptedException interruptedException) {
                        this.m_logger.warning("Could not kill existing ngamsArchiveClient process.");
                    }
                }
            }
        }
        super.cleanUp();
        this.engine.close(true);
    }

    public short getArchiveLevel() {
        return this.archiveLevel;
    }

    public void setArchiveLevel(short s) {
        this.archiveLevel = s;
    }

    public synchronized void xmlEntryReceived(String string) {
        if (this.cleanupDone) {
            return;
        }
        Document document = null;
        try {
            document = this.builder.build((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            System.out.println("ArchiveLogger: Could not parse the following log message: " + string);
            exception.printStackTrace();
            return;
        }
        Element element = document.getRootElement();
        String string2 = element.getName();
        this.writeLog(string, element.getAttributeValue(this.usedAtts[0]));
        if (this.logLevelMap.get(string2) == null || this.logLevelMap.get(string2) < this.archiveLevel) {
            return;
        }
        boolean bl = false;
        if (this.maxLogsPerInterval > 0) {
            if (this.logsPerIntervalStart == 0L) {
                this.logsPerIntervalStart = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.logsPerIntervalStart > this.logIntervalSize) {
                this.logsPerIntervalStart = System.currentTimeMillis();
                this.logsThisInterval = 0;
                bl = true;
            }
            if (this.logsThisInterval++ > this.maxLogsPerInterval) {
                this.lastMaxLogsReachedTime = System.currentTimeMillis();
                if (this.maxLogsReachedTime == 0L) {
                    this.maxLogsReachedTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.maxLogsReachedTime > this.logPeakToleranceInterval) {
                    if (!this.maxLogAlarmActive) {
                        this.maxLogAlarmActive = true;
                        this.maxLogsPerSecondReached();
                    }
                    return;
                }
            } else if (this.maxLogAlarmActive && System.currentTimeMillis() - this.lastMaxLogsReachedTime > (long)this.alarmOffIntervalNumber * this.logIntervalSize) {
                this.maxLogsReachedTime = 0L;
                this.maxLogAlarmActive = false;
                this.situationNormalAgain();
            }
        }
        if (this.logCountSinceCommit++ > 1000) {
            bl = true;
        }
        if (bl) {
            this.logCountSinceCommit = 0;
        }
        List list = element.getChildren("Data");
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = ((Element)iterator.next()).getText();
            ++n;
        }
        try {
            this.internal.storeLog(element.getTextNormalize().length() > 2048 ? element.getTextNormalize().substring(0, 2048) : element.getTextNormalize(), this.logLevelMap.get(string2).intValue(), element.getAttributeValue(this.usedAtts[0]), element.getAttributeValue(this.usedAtts[1]), element.getAttributeValue(this.usedAtts[2]), element.getAttributeValue(this.usedAtts[3]), element.getAttributeValue(this.usedAtts[4]), element.getAttributeValue(this.usedAtts[5]), element.getAttributeValue(this.usedAtts[6]), element.getAttributeValue(this.usedAtts[7]), element.getAttributeValue(this.usedAtts[8]), element.getAttributeValue(this.usedAtts[9]), element.getAttributeValue(this.usedAtts[10]), element.getAttributeValue(this.usedAtts[11]), element.getAttributeValue(this.usedAtts[12]), element.getAttributeValue(this.usedAtts[13]), element.getAttributeValue(this.usedAtts[14]), stringArray, string.length() > 4000 ? string.substring(0, 4000) : string, bl, this.steEnv);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.toString());
        }
    }

    private void situationNormalAgain() {
        this.m_logger.info("Number of logs normalized after delay of " + (long)this.alarmOffIntervalNumber * this.logIntervalSize + " milliseconds, situation normal again.");
        try {
            ACSAlarmSystemInterface aCSAlarmSystemInterface = ACSAlarmSystemInterfaceFactory.createSource((String)"ARCHIVE_LOGGER");
            ACSFaultState aCSFaultState = ACSAlarmSystemInterfaceFactory.createFaultState((String)"Logging", (String)"ARCHIVE_LOGGER", (int)1);
            aCSFaultState.setDescriptor("TERMINATE");
            aCSFaultState.setUserTimestamp(new Timestamp(System.currentTimeMillis()));
            Properties properties = new Properties();
            properties.setProperty("ASI_PREFIX", "prefix");
            properties.setProperty("ASI_SUFFIX", "suffix");
            aCSFaultState.setUserProperties(properties);
            aCSAlarmSystemInterface.push(aCSFaultState);
        }
        catch (Exception exception) {
            this.m_logger.warning("Failure when sending alarm: " + exception);
        }
    }

    private void maxLogsPerSecondReached() {
        this.m_logger.warning("Maximum number of logs per second reached. Only subset of logs will be stored in Oracle.");
        try {
            ACSAlarmSystemInterface aCSAlarmSystemInterface = ACSAlarmSystemInterfaceFactory.createSource((String)"ARCHIVE_LOGGER");
            ACSFaultState aCSFaultState = ACSAlarmSystemInterfaceFactory.createFaultState((String)"Logging", (String)"ARCHIVE_LOGGER", (int)1);
            aCSFaultState.setDescriptor("ACTIVE");
            aCSFaultState.setUserTimestamp(new Timestamp(System.currentTimeMillis()));
            Properties properties = new Properties();
            properties.setProperty("ASI_PREFIX", "prefix");
            properties.setProperty("ASI_SUFFIX", "suffix");
            aCSFaultState.setUserProperties(properties);
            aCSAlarmSystemInterface.push(aCSFaultState);
        }
        catch (Exception exception) {
            this.m_logger.warning("Failure when sending alarm: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(String string, String string2) {
        Object object;
        if (this.actFile == null) {
            this.m_logger.fine("Log file not yet initialized, log lost: " + string);
            return;
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.cleanupDone) {
                return;
            }
            object = this.actWriter;
            String string3 = this.actFile.getAbsolutePath();
            if (this.checkOverlap) {
                if (5000 < this.logOverlapCount++) {
                    this.checkOverlap = false;
                    this.logOverlapCount = 0;
                    try {
                        this.oldWriter.write("</Log>");
                        this.oldWriter.close();
                    }
                    catch (IOException iOException) {
                        this.m_logger.warning("Could not close file for writing logs: " + this.oldFile.getAbsolutePath() + ". Got: " + iOException);
                    }
                } else if (string2.compareTo(this.actStart) < 0) {
                    object = this.oldWriter;
                    string3 = this.oldFile.getAbsolutePath();
                }
            }
            try {
                object.write(string + "\n");
            }
            catch (IOException iOException) {
                this.m_logger.warning("Could not write logs to file: " + string3 + ". Got: " + iOException);
                if (!this.fileWriteAlarmActive) {
                    this.sendAlarm();
                }
                this.fileWriteAlarmActive = true;
            }
        }
        if (this.checkOverlap) {
            return;
        }
        if (string2.compareTo(this.actMax) > 0) {
            this.actMax = string2;
            if (this.actFile.length() > (long)this.fileSizeLimit) {
                this.m_logger.finer("Max size for log file " + this.actFile.getAbsolutePath() + " reached. Switching.");
                object2 = this.fileName + this.actStart + "--" + this.actMax + ".xml";
                this.m_logger.info("Log file " + this.actFile.getAbsolutePath() + " reached max size. Writing logs to " + (String)object2);
                object = this;
                synchronized (object) {
                    if (this.cleanupDone) {
                        return;
                    }
                    try {
                        this.actWriter.close();
                    }
                    catch (IOException iOException) {
                        this.m_logger.warning("Could not close file for writing logs: " + this.actFile.getAbsolutePath() + ". Got: " + iOException);
                    }
                    if (!this.actFile.renameTo(new File((String)object2))) {
                        this.m_logger.warning("Could not move old log file " + this.fileName + " to " + (String)object2);
                        if (!this.fileWriteAlarmActive) {
                            this.sendAlarm();
                        }
                        this.fileWriteAlarmActive = true;
                    }
                    this.fileList.add((String)object2);
                    this.oldFile = new File((String)object2);
                    try {
                        this.oldWriter = new BufferedWriter(new FileWriter(this.oldFile, true));
                    }
                    catch (IOException iOException) {
                        this.m_logger.warning("Could not open file for writing logs: " + this.oldFile.getAbsolutePath() + ". Got: " + iOException);
                        if (!this.fileWriteAlarmActive) {
                            this.sendAlarm();
                        }
                        this.fileWriteAlarmActive = true;
                    }
                    this.actStart = this.actMax;
                    this.checkOverlap = true;
                    this.actFile = new File(this.fileName + this.actMax + "--" + new ArchiveTimeStamp(new Timestamp(Calendar.getInstance().getTimeInMillis() + 10000000L)).toISOString() + ".xml");
                    try {
                        this.actWriter = new BufferedWriter(new FileWriter(this.actFile));
                        this.actWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\t<Log>\n\t<Header Name=\"Logs written by Archive logger\" Type=\"LOGFILE\" />\n");
                    }
                    catch (IOException iOException) {
                        this.m_logger.warning("Could not open file for writing logs: " + this.actFile.getAbsolutePath() + ". Got: " + iOException);
                        if (!this.fileWriteAlarmActive) {
                            this.sendAlarm();
                        }
                        this.fileWriteAlarmActive = true;
                    }
                }
                if (this.fileList.size() >= this.fileMax) {
                    object = this.fileList.remove(0);
                    if (this.ngasClientStart) {
                        this.m_logger.info("Moving old log file " + (String)object + " to " + this.ngasPath);
                        if (new File(this.ngasPath).list().length > 0) {
                            File[] fileArray = new File(this.ngasPath).listFiles();
                            for (int i = 0; i < fileArray.length; ++i) {
                                this.m_logger.info("Removing surviving file in NGAS pickup directory: " + fileArray[i].getAbsolutePath());
                                fileArray[i].delete();
                            }
                        }
                        if (!new File((String)object).renameTo(new File(this.ngasPath + File.separator + new File((String)object).getName()))) {
                            this.m_logger.warning("Could not move old log file " + (String)object + " to " + this.ngasPath);
                            if (!this.fileWriteAlarmActive) {
                                this.sendAlarm();
                            }
                            this.fileWriteAlarmActive = true;
                        }
                    } else {
                        new File((String)object).delete();
                    }
                }
            }
        }
    }
}

