/*
 * Decompiled with CFR 0.152.
 */
package alma.ngas.client;

import alma.ngas.client.FileInfo;
import alma.ngas.client.FileReceivedEvent;
import alma.ngas.client.FileReceivedEventListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Vector;
import java.util.logging.Logger;

class MiniServer
implements Runnable {
    int port;
    boolean serve = true;
    boolean takingFile = false;
    boolean ready = false;
    Logger logger;
    Vector<FileReceivedEventListener> listOfFileReceivedEventListeners = new Vector();
    String dataRaw;
    int blockSize = 1024;

    MiniServer(int n, int n2, String string, Logger logger) {
        this.port = n;
        this.blockSize = n2;
        this.dataRaw = string;
        this.logger = logger;
    }

    void notifyListenersOfFileArrival(int n) {
        for (int i = 0; i < this.listOfFileReceivedEventListeners.size(); ++i) {
            FileReceivedEventListener fileReceivedEventListener = this.listOfFileReceivedEventListeners.elementAt(i);
            fileReceivedEventListener.fileReceived(new FileReceivedEvent(n));
        }
        this.logger.info("miniServer is sending message to listeners that a new file has arrived");
    }

    @Override
    public void run() {
        this.takingFile = false;
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
            serverSocketChannel.socket().bind(inetSocketAddress);
            int n = 0;
            while (this.serve) {
                this.ready = true;
                SocketChannel socketChannel = serverSocketChannel.accept();
                if (socketChannel == null) continue;
                Socket socket = socketChannel.socket();
                this.takingFile = true;
                this.takeBinaryFile(socket, n);
                this.takingFile = false;
                socketChannel.close();
                this.notifyListenersOfFileArrival(++n);
            }
            serverSocketChannel.close();
            this.ready = false;
        }
        catch (IOException iOException) {
            this.logger.warning("IOException in MiniServer.run; description is: " + iOException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.warning("IllegalArgumentException in Miniserver.run; description is: " + illegalArgumentException.toString());
        }
    }

    FileInfo takeBinaryFile(Socket socket, int n) {
        String string = this.dataRaw + "serverOut" + n;
        String string2 = null;
        String string3 = "\r\n";
        try {
            char c;
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            String string4 = "";
            do {
                c = (char)dataInputStream.readByte();
            } while (!(string4 = string4 + String.valueOf(c)).endsWith(string3 + string3));
            int n2 = string4.indexOf("filename=\"");
            int n3 = string4.indexOf("\"", n2 + 10);
            if (n2 == -1 || n3 == -1) {
                this.logger.warning("Filename wasn't specified in the HTTP header sent by NGAS, for file " + n);
                return new FileInfo(null, null);
            }
            string2 = string4.substring(n2 + 10, n3);
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            Object object = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            n2 = string4.indexOf("length: ");
            if (n2 == -1) {
                this.logger.warning("Length wasn't specified in the HTTP header sent by NGAS, for file " + n + " with name " + string2);
                return new FileInfo(null, string2);
            }
            n3 = string4.indexOf(string3, n2);
            int n4 = Integer.valueOf(string4.substring(n2 + 8, n3));
            object = new byte[this.blockSize];
            int n5 = 0;
            for (int i = 0; i < n4 && (n5 = dataInputStream.read((byte[])object, 0, this.blockSize)) > 0; i += n5) {
                dataOutputStream.write((byte[])object, 0, n5);
                dataOutputStream.flush();
            }
            printWriter.print("HTTP/1.0 200\nContent-Type: text/plain\n\n");
            dataInputStream.close();
            printWriter.close();
            dataOutputStream.close();
            return new FileInfo(null, string2);
        }
        catch (IOException iOException) {
            this.logger.warning("IOEXception in MiniServer.takeBinaryFile; file name is: " + (string2 == null ? "unknown" : string2) + "; description is: " + iOException.toString());
            return new FileInfo(null, string2);
        }
    }
}

