/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.status;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.jk.status.AbstractJkStatusTask;
import org.apache.tools.ant.BuildException;

public class JkStatusResetTask
extends AbstractJkStatusTask {
    private static final String info = "org.apache.jk.status.JkStatusResetTask/1.1";
    private String worker;
    private String loadbalancer;

    public JkStatusResetTask() {
        this.setUrl("http://localhost/jkstatus");
    }

    public String getInfo() {
        return info;
    }

    public String getLoadbalancer() {
        return this.loadbalancer;
    }

    public void setLoadbalancer(String loadbalancer) {
        this.loadbalancer = loadbalancer;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    protected StringBuffer createLink() {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("?cmd=reset");
            sb.append("&mime=txt");
            sb.append("&w=");
            sb.append(URLEncoder.encode(this.loadbalancer, this.getCharset()));
            if (this.worker != null) {
                sb.append("&sw=");
                sb.append(URLEncoder.encode(this.worker, this.getCharset()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Invalid 'charset' attribute: " + this.getCharset());
        }
        return sb;
    }

    protected void checkParameter() {
        if (this.loadbalancer == null) {
            throw new BuildException("Must specify 'loadbalanacer' attribute");
        }
    }
}

